struct SideInfo {
	int side;
	float x;
	float y;
	float z;
	float brightness;
	float radius;
};

layout(std430) restrict readonly buffer SideInfoBuffer {
    SideInfo data[];
}
sides;

const vec3 normals[6] = {
	vec3(-1.0, 0.0, 0.0),
	vec3(1.0, 0.0, 0.0),
	vec3(0.0, -1.0, 0.0),
	vec3(0.0, 1.0, 0.0),
	vec3(0.0, 0.0, -1.0),
	vec3(0.0, 0.0, 1.0)
};

const mat4 transformations[6] = {
	mat4(
		1.0, 0.0, 0.0, 0.0,
		0.0, 1.0, 0.0, 0.0,
		0.0, 0.0, 1.0, 0.0,
		0.0, 0.0, 0.0, 1.0
	),
	mat4(
	   -1.0, 0.0, 0.0, 0.0,
		0.0, 1.0, 0.0, 0.0,
		0.0, 0.0, 1.0, 0.0,
		0.0, 0.0, 0.0, 1.0
	),
	mat4(
		0.0, -1.0, 0.0, 0.0,
		1.0,  0.0, 0.0, 0.0,
		0.0,  0.0, 1.0, 0.0,
		0.0,  0.0, 0.0, 1.0
	),
	mat4(
		0.0, 1.0, 0.0, 0.0,
	   -1.0, 0.0, 0.0, 0.0,
		0.0, 0.0, 1.0, 0.0,
		0.0, 0.0, 0.0, 1.0
	),
	mat4(
		0.0, 0.0, -1.0, 0.0,
		0.0, 1.0,  0.0, 0.0,
	    1.0, 0.0,  0.0, 0.0,
		0.0, 0.0,  0.0, 1.0
	),
	mat4(
		0.0, 0.0, 1.0, 0.0,
		0.0, 1.0, 0.0, 0.0,
	   -1.0, 0.0, 0.0, 0.0,
		0.0, 0.0, 0.0, 1.0
	)
};