/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.vibrativevoice;

import com.codinglitch.vibrativevoice.CommonVibrativeVoice;
import com.codinglitch.vibrativevoice.VibrativeVoiceApi;
import com.codinglitch.vibrativevoice.VibrativeVoiceLibrary;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class CommonVibrativePlugin {
    public static VoicechatApi api;
    @Nullable
    public static VoicechatServerApi serverApi;
    public static CommonVibrativePlugin INSTANCE;
    private OpusDecoder decoder;

    public String getPluginId() {
        return "vibrativevoice";
    }

    public void initialize(VoicechatApi api) {
        CommonVibrativePlugin.api = api;
        INSTANCE = this;
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicPacket);
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        serverApi = event.getVoicechat();
    }

    private void onMicPacket(MicrophonePacketEvent event) {
        byte[] data;
        VoicechatConnection senderConnection = event.getSenderConnection();
        if (senderConnection == null) {
            return;
        }
        float multiplier = 1.0f;
        if (!CommonVibrativeVoice.API.applyRestriction(VibrativeVoiceApi.RestrictionType.GROUPS, senderConnection.isInGroup())) {
            return;
        }
        if (!CommonVibrativeVoice.API.applyRestriction(VibrativeVoiceApi.RestrictionType.WHISPERING, ((MicrophonePacket)event.getPacket()).isWhispering())) {
            multiplier = (float)((double)multiplier * VibrativeVoiceLibrary.CONFIG.restrictions.whisperFactor);
        }
        if ((data = ((MicrophonePacket)event.getPacket()).getOpusEncodedData()).length == 0) {
            return;
        }
        Object object = senderConnection.getPlayer().getPlayer();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            if (!CommonVibrativeVoice.API.applyRestriction(VibrativeVoiceApi.RestrictionType.SNEAKING, player.m_6047_())) {
                multiplier = (float)((double)multiplier * VibrativeVoiceLibrary.CONFIG.restrictions.whisperFactor);
            }
            if (multiplier <= 0.0f) {
                return;
            }
            double volume = CommonVibrativeVoice.API.getVolume(data) * (double)multiplier;
            CommonVibrativeVoice.API.setPlayerLoudness((Player)player, volume, player.m_9236_().m_46467_());
            VibrativeVoiceApi.VibrationType type = CommonVibrativeVoice.API.getQualifyingType(volume);
            if (type == null) {
                return;
            }
            CommonVibrativeVoice.API.trySendVibration(player.m_20148_(), (Entity)player, player.m_9236_(), type, (int)VibrativeVoiceLibrary.CONFIG.cooldownDuration);
        }
    }

    public OpusDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = api.createDecoder();
        }
        return this.decoder;
    }
}

