/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby.mixin;

import de.johni0702.minecraft.bobby.Bobby;
import de.johni0702.minecraft.bobby.FakeChunk;
import de.johni0702.minecraft.bobby.FakeChunkManager;
import de.johni0702.minecraft.bobby.VisibleChunksTracker;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class})
public abstract class ClientChunkManagerMixin
implements ClientChunkManagerExt {
    @Shadow
    @Final
    private LevelChunk f_104408_;
    protected FakeChunkManager bobbyChunkManager;
    private final VisibleChunksTracker realChunksTracker = new VisibleChunksTracker();
    private final List<Pair<Long, Supplier<LevelChunk>>> bobbyChunkReplacements = new ArrayList<Pair<Long, Supplier<LevelChunk>>>();

    @Shadow
    @Nullable
    public abstract LevelChunk m_7587_(int var1, int var2, ChunkStatus var3, boolean var4);

    @Shadow
    private static int m_104448_(int loadDistance) {
        throw new AssertionError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void bobbyInit(ClientLevel world, int loadDistance, CallbackInfo ci) {
        if (Bobby.getInstance().isEnabled()) {
            this.bobbyChunkManager = new FakeChunkManager(world, (ClientChunkCache)this);
            this.realChunksTracker.update(0, 0, ClientChunkManagerMixin.m_104448_(loadDistance), null, null);
        }
    }

    @Override
    public FakeChunkManager bobby_getFakeChunkManager() {
        return this.bobbyChunkManager;
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/chunk/ChunkStatus;Z)Lnet/minecraft/world/chunk/WorldChunk;"}, at={@At(value="RETURN")}, cancellable=true)
    private void bobbyGetChunk(int x, int z, ChunkStatus chunkStatus, boolean orEmpty, CallbackInfoReturnable<LevelChunk> ci) {
        if (ci.getReturnValue() != (orEmpty ? this.f_104408_ : null)) {
            return;
        }
        if (this.bobbyChunkManager == null) {
            return;
        }
        LevelChunk chunk = this.bobbyChunkManager.getChunk(x, z);
        if (chunk != null) {
            ci.setReturnValue((Object)chunk);
        }
    }

    @Inject(method={"loadChunkFromPacket"}, at={@At(value="HEAD")})
    private void bobbyUnloadFakeChunk(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> cir) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.bobby_pauseChunkStatusListener();
        this.bobbyChunkManager.unload(x, z, true);
    }

    @Inject(method={"loadChunkFromPacket"}, at={@At(value="RETURN")})
    private void bobbyPostLoadRealChunk(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> cir) {
        this.bobby_onFakeChunkAdded(x, z);
        this.bobby_resumeChunkStatusListener();
    }

    @Unique
    private void saveRealChunk(long chunkPos) {
        int chunkZ;
        int chunkX = ChunkPos.m_45592_((long)chunkPos);
        LevelChunk chunk = this.m_7587_(chunkX, chunkZ = ChunkPos.m_45602_((long)chunkPos), ChunkStatus.f_62326_, false);
        if (chunk == null || chunk instanceof FakeChunk) {
            return;
        }
        Supplier<LevelChunk> copy = this.bobbyChunkManager.save(chunk);
        if (this.bobbyChunkManager.shouldBeLoaded(chunkX, chunkZ)) {
            this.bobbyChunkReplacements.add((Pair<Long, Supplier<LevelChunk>>)Pair.of((Object)chunkPos, copy));
            this.bobby_pauseChunkStatusListener();
        }
    }

    @Unique
    private void substituteFakeChunksForUnloadedRealOnes() {
        for (Pair<Long, Supplier<LevelChunk>> entry : this.bobbyChunkReplacements) {
            long chunkPos = (Long)entry.getKey();
            int chunkX = ChunkPos.m_45592_((long)chunkPos);
            int chunkZ = ChunkPos.m_45602_((long)chunkPos);
            this.bobbyChunkManager.load(chunkX, chunkZ, (LevelChunk)((Supplier)entry.getValue()).get());
        }
        this.bobbyChunkReplacements.clear();
        this.bobby_resumeChunkStatusListener();
    }

    @Inject(method={"unload"}, at={@At(value="HEAD")})
    private void bobbySaveChunk(int chunkX, int chunkZ, CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.saveRealChunk(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    @Inject(method={"setChunkMapCenter"}, at={@At(value="HEAD")})
    private void bobbySaveChunksBeforeMove(int x, int z, CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.realChunksTracker.updateCenter(x, z, this::saveRealChunk, null);
    }

    @Inject(method={"updateLoadDistance"}, at={@At(value="HEAD")})
    private void bobbySaveChunksBeforeResize(int loadDistance, CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.realChunksTracker.updateViewDistance(ClientChunkManagerMixin.m_104448_(loadDistance), this::saveRealChunk, null);
    }

    @Inject(method={"unload", "setChunkMapCenter", "updateLoadDistance"}, at={@At(value="RETURN")})
    private void bobbySubstituteFakeChunksForUnloadedRealOnes(CallbackInfo ci) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        this.substituteFakeChunksForUnloadedRealOnes();
    }

    @Inject(method={"getDebugString"}, at={@At(value="RETURN")}, cancellable=true)
    private void bobbyDebugString(CallbackInfoReturnable<String> cir) {
        if (this.bobbyChunkManager == null) {
            return;
        }
        cir.setReturnValue((Object)((String)cir.getReturnValue() + " " + this.bobbyChunkManager.getDebugString()));
    }

    @Override
    public void bobby_onFakeChunkAdded(int x, int z) {
    }

    @Override
    public void bobby_onFakeChunkRemoved(int x, int z) {
    }

    @Override
    public void bobby_pauseChunkStatusListener() {
    }

    @Override
    public void bobby_resumeChunkStatusListener() {
    }
}

