/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.ChunkSerializer;
import de.johni0702.minecraft.bobby.FakeChunkStorage;
import de.johni0702.minecraft.bobby.VisibleChunksTracker;
import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import de.johni0702.minecraft.bobby.ext.ClientChunkManagerExt;
import de.johni0702.minecraft.bobby.ext.LightingProviderExt;
import de.johni0702.minecraft.bobby.mixin.BiomeAccessAccessor;
import de.johni0702.minecraft.bobby.mixin.ClientWorldAccessor;
import io.netty.util.concurrent.DefaultThreadFactory;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.lang3.tuple.Pair;

public class FakeChunkManager {
    private static final String FALLBACK_LEVEL_NAME = "bobby-fallback";
    private static final Minecraft client = Minecraft.m_91087_();
    private final ClientLevel world;
    private final ClientChunkCache clientChunkManager;
    private final ClientChunkManagerExt clientChunkManagerExt;
    private final FakeChunkStorage storage;
    private final List<FakeChunkStorage> storages;
    private int ticksSinceLastSave;
    private final Long2ObjectMap<LevelChunk> fakeChunks = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final VisibleChunksTracker chunkTracker = new VisibleChunksTracker();
    private final Long2LongMap toBeUnloaded = new Long2LongOpenHashMap();
    private final Deque<Pair<Long, Long>> unloadQueue = new ArrayDeque<Pair<Long, Long>>();
    private static final ExecutorService loadExecutor = Executors.newFixedThreadPool(8, (ThreadFactory)new DefaultThreadFactory("bobby-loading", true));
    private final Long2ObjectMap<LoadingJob> loadingJobs = new Long2ObjectLinkedOpenHashMap();
    private static final ExecutorService saveExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("bobby-saving", true));

    public FakeChunkManager(ClientLevel world, ClientChunkCache clientChunkManager) {
        this.world = world;
        this.clientChunkManager = clientChunkManager;
        this.clientChunkManagerExt = (ClientChunkManagerExt)clientChunkManager;
        long seedHash = ((BiomeAccessAccessor)world.m_7062_()).getSeed();
        ResourceKey worldKey = world.m_46472_();
        ResourceLocation worldId = worldKey.m_135782_();
        Path storagePath = FakeChunkManager.client.f_91069_.toPath().resolve(".bobby").resolve(FakeChunkManager.getCurrentWorldOrServerName(((ClientWorldAccessor)world).getNetworkHandler())).resolve("" + seedHash).resolve(worldId.m_135827_()).resolve(worldId.m_135815_());
        this.storage = FakeChunkStorage.getFor(storagePath, true);
        FakeChunkStorage fallbackStorage = null;
        LevelStorageSource levelStorage = client.m_91392_();
        if (levelStorage.m_78255_(FALLBACK_LEVEL_NAME)) {
            try (LevelStorageSource.LevelStorageAccess session = levelStorage.m_289864_(FALLBACK_LEVEL_NAME);){
                Path worldDirectory = session.m_197394_(worldKey);
                Path regionDirectory = worldDirectory.resolve("region");
                fallbackStorage = FakeChunkStorage.getFor(regionDirectory, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.storages = fallbackStorage == null ? List.of(this.storage) : List.of(this.storage, fallbackStorage);
    }

    public LevelChunk getChunk(int x, int z) {
        return (LevelChunk)this.fakeChunks.get(ChunkPos.m_45589_((int)x, (int)z));
    }

    public FakeChunkStorage getStorage() {
        return this.storage;
    }

    public void update(boolean blocking, BooleanSupplier shouldKeepTicking) {
        this.update(blocking, shouldKeepTicking, (Integer)FakeChunkManager.client.f_91066_.m_231984_().m_231551_());
    }

    private void update(boolean blocking, BooleanSupplier shouldKeepTicking, int newViewDistance) {
        Pair<Long, Long> next;
        LocalPlayer player;
        if (++this.ticksSinceLastSave > 1200) {
            Util.m_183992_().execute(() -> ((FakeChunkStorage)this.storage).m_63514_());
            this.ticksSinceLastSave = 0;
        }
        if ((player = FakeChunkManager.client.f_91074_) == null) {
            return;
        }
        long time = Util.m_137550_();
        ArrayList<LoadingJob> newJobs = new ArrayList<LoadingJob>();
        ChunkPos playerChunkPos = player.m_146902_();
        int newCenterX = playerChunkPos.f_45578_;
        int newCenterZ = playerChunkPos.f_45579_;
        this.chunkTracker.update(newCenterX, newCenterZ, newViewDistance, chunkPos -> {
            this.cancelLoad(chunkPos);
            this.toBeUnloaded.put(chunkPos, time);
            this.unloadQueue.add((Pair<Long, Long>)Pair.of((Object)chunkPos, (Object)time));
        }, chunkPos -> {
            int x = ChunkPos.m_45592_((long)chunkPos);
            int z = ChunkPos.m_45602_((long)chunkPos);
            this.toBeUnloaded.remove(chunkPos);
            if (this.clientChunkManager.m_7587_(x, z, ChunkStatus.f_62326_, false) != null) {
                return;
            }
            int distanceX = Math.abs(x - newCenterX);
            int distanceZ = Math.abs(z - newCenterZ);
            int distanceSquared = distanceX * distanceX + distanceZ * distanceZ;
            newJobs.add(new LoadingJob(x, z, distanceSquared));
        });
        if (!newJobs.isEmpty()) {
            newJobs.sort(LoadingJob.BY_DISTANCE);
            newJobs.forEach(job -> {
                this.loadingJobs.put(ChunkPos.m_45589_((int)job.x, (int)job.z), job);
                loadExecutor.execute((Runnable)job);
            });
        }
        long unloadTime = time - (long)BobbyConfig.getUnloadDelaySecs() * 1000L;
        int countSinceLastThrottleCheck = 0;
        while ((next = this.unloadQueue.pollFirst()) != null) {
            long chunkPos2 = (Long)next.getLeft();
            long queuedTime = (Long)next.getRight();
            if (queuedTime > unloadTime) {
                this.unloadQueue.addFirst(next);
                break;
            }
            long actualQueuedTime = this.toBeUnloaded.remove(chunkPos2);
            if (actualQueuedTime != queuedTime) {
                if (actualQueuedTime == 0L) continue;
                this.toBeUnloaded.put(chunkPos2, actualQueuedTime);
                continue;
            }
            this.unload(ChunkPos.m_45592_((long)chunkPos2), ChunkPos.m_45602_((long)chunkPos2), false);
            if (countSinceLastThrottleCheck++ <= 10) continue;
            countSinceLastThrottleCheck = 0;
            if (shouldKeepTicking.getAsBoolean()) continue;
            break;
        }
        ObjectIterator loadingJobsIter = this.loadingJobs.values().iterator();
        block3: while (loadingJobsIter.hasNext()) {
            LoadingJob loadingJob = (LoadingJob)loadingJobsIter.next();
            while (loadingJob.result == null) {
                if (!blocking) continue block3;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            loadingJobsIter.remove();
            client.m_91307_().m_6180_("loadFakeChunk");
            loadingJob.complete();
            client.m_91307_().m_7238_();
            if (shouldKeepTicking.getAsBoolean()) continue;
            break;
        }
    }

    public void loadMissingChunksFromCache() {
        this.update(false, () -> false, 0);
        this.update(false, () -> false);
    }

    public boolean shouldBeLoaded(int x, int z) {
        return this.chunkTracker.isInViewDistance(x, z);
    }

    private CompletableFuture<Optional<Pair<CompoundTag, FakeChunkStorage>>> loadTag(int x, int z) {
        return this.loadTag(new ChunkPos(x, z), 0);
    }

    private CompletableFuture<Optional<Pair<CompoundTag, FakeChunkStorage>>> loadTag(ChunkPos chunkPos, int storageIndex) {
        FakeChunkStorage storage = this.storages.get(storageIndex);
        return storage.loadTag(chunkPos).thenCompose(maybeTag -> {
            if (maybeTag.isPresent()) {
                return CompletableFuture.completedFuture(Optional.of(Pair.of((Object)((CompoundTag)maybeTag.get()), (Object)((Object)storage))));
            }
            if (storageIndex + 1 < this.storages.size()) {
                return this.loadTag(chunkPos, storageIndex + 1);
            }
            return CompletableFuture.completedFuture(Optional.empty());
        });
    }

    public void load(int x, int z, LevelChunk chunk) {
        this.fakeChunks.put(ChunkPos.m_45589_((int)x, (int)z), (Object)chunk);
        this.world.m_171649_(new ChunkPos(x, z));
        for (int i = this.world.m_151560_(); i < this.world.m_151561_(); ++i) {
            this.world.m_104793_(x, i, z);
        }
        this.clientChunkManagerExt.bobby_onFakeChunkAdded(x, z);
    }

    public boolean unload(int x, int z, boolean willBeReplaced) {
        long chunkPos = ChunkPos.m_45589_((int)x, (int)z);
        this.cancelLoad(chunkPos);
        LevelChunk chunk = (LevelChunk)this.fakeChunks.remove(chunkPos);
        if (chunk != null) {
            chunk.m_187957_();
            LevelLightEngine lightingProvider = this.clientChunkManager.m_7827_();
            LightingProviderExt lightingProviderExt = LightingProviderExt.get(lightingProvider);
            ChunkLightProviderExt blockLightProvider = ChunkLightProviderExt.get(lightingProvider.m_75814_(LightLayer.BLOCK));
            ChunkLightProviderExt skyLightProvider = ChunkLightProviderExt.get(lightingProvider.m_75814_(LightLayer.SKY));
            lightingProviderExt.bobby_disableColumn(chunkPos);
            for (int i = 0; i < chunk.m_7103_().length; ++i) {
                int y = this.world.m_151568_(i);
                if (blockLightProvider != null) {
                    blockLightProvider.bobby_removeSectionData(SectionPos.m_123209_((int)x, (int)y, (int)z));
                }
                if (skyLightProvider == null) continue;
                skyLightProvider.bobby_removeSectionData(SectionPos.m_123209_((int)x, (int)y, (int)z));
            }
            this.clientChunkManagerExt.bobby_onFakeChunkRemoved(x, z);
            return true;
        }
        return false;
    }

    private void cancelLoad(long chunkPos) {
        LoadingJob loadingJob = (LoadingJob)this.loadingJobs.remove(chunkPos);
        if (loadingJob != null) {
            loadingJob.cancelled = true;
        }
    }

    public Supplier<LevelChunk> save(LevelChunk chunk) {
        Pair<LevelChunk, Supplier<LevelChunk>> copy = ChunkSerializer.shallowCopy(chunk);
        LevelLightEngine lightingProvider = chunk.m_62953_().m_5518_();
        saveExecutor.execute(() -> {
            CompoundTag nbt = ChunkSerializer.serialize((LevelChunk)copy.getLeft(), lightingProvider);
            this.storage.save(chunk.m_7697_(), nbt);
        });
        return (Supplier)copy.getRight();
    }

    private static String getCurrentWorldOrServerName(ClientPacketListener networkHandler) {
        IntegratedServer integratedServer = client.m_91092_();
        if (integratedServer != null) {
            return integratedServer.m_129910_().m_5462_();
        }
        if (client.m_91294_()) {
            return "realms";
        }
        ServerData serverInfo = networkHandler.m_245416_();
        if (serverInfo != null) {
            return serverInfo.f_105363_.replace(':', '_');
        }
        return "unknown";
    }

    public String getDebugString() {
        return "F: " + this.fakeChunks.size() + " L: " + this.loadingJobs.size() + " U: " + this.toBeUnloaded.size();
    }

    public Collection<LevelChunk> getFakeChunks() {
        return this.fakeChunks.values();
    }

    private class LoadingJob
    implements Runnable {
        private final int x;
        private final int z;
        private final int distanceSquared;
        private volatile boolean cancelled;
        private volatile Optional<Supplier<LevelChunk>> result;
        public static final Comparator<LoadingJob> BY_DISTANCE = Comparator.comparing(it -> it.distanceSquared);

        public LoadingJob(int x, int z, int distanceSquared) {
            this.x = x;
            this.z = z;
            this.distanceSquared = distanceSquared;
        }

        @Override
        public void run() {
            Optional<Object> value;
            if (this.cancelled) {
                return;
            }
            try {
                value = FakeChunkManager.this.loadTag(this.x, this.z).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                value = Optional.empty();
            }
            if (this.cancelled) {
                return;
            }
            this.result = value.map(it -> ChunkSerializer.deserialize(new ChunkPos(this.x, this.z), (CompoundTag)it.getLeft(), (Level)FakeChunkManager.this.world));
        }

        public void complete() {
            this.result.ifPresent(it -> FakeChunkManager.this.load(this.x, this.z, (LevelChunk)it.get()));
        }
    }
}

