/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.FakeChunk;
import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import de.johni0702.minecraft.bobby.ext.LightingProviderExt;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChunkSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataLayer COMPLETELY_DARK = new DataLayer();
    private static final DataLayer COMPLETELY_LIT = new DataLayer();
    private static final Codec<PalettedContainer<BlockState>> BLOCK_CODEC;

    public static CompoundTag serialize(LevelChunk chunk, LevelLightEngine lightingProvider) {
        ListTag blockEntitiesTag;
        Registry biomeRegistry = chunk.m_62953_().m_9598_().m_175515_(Registries.f_256952_);
        Codec biomeCodec = PalettedContainer.m_238418_((IdMap)biomeRegistry.m_206115_(), (Codec)biomeRegistry.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)biomeRegistry.m_246971_(Biomes.f_48202_));
        ChunkPos chunkPos = chunk.m_7697_();
        CompoundTag level = new CompoundTag();
        level.m_128405_("DataVersion", SharedConstants.m_183709_().m_183476_().m_193006_());
        level.m_128405_("xPos", chunkPos.f_45578_);
        level.m_128405_("yPos", chunk.m_151560_());
        level.m_128405_("zPos", chunkPos.f_45579_);
        level.m_128379_("isLightOn", true);
        level.m_128359_("Status", "full");
        LevelChunkSection[] chunkSections = chunk.m_7103_();
        ListTag sectionsTag = new ListTag();
        for (int y = lightingProvider.m_164447_(); y < lightingProvider.m_164448_(); ++y) {
            DataLayer skyLight;
            DataLayer blockLight;
            LevelChunkSection chunkSection;
            boolean empty = true;
            CompoundTag sectionTag = new CompoundTag();
            sectionTag.m_128344_("Y", (byte)y);
            int i = chunk.m_151566_(y);
            LevelChunkSection levelChunkSection = chunkSection = i >= 0 && i < chunkSections.length ? chunkSections[i] : null;
            if (chunkSection != null) {
                sectionTag.m_128365_("block_states", (Tag)BLOCK_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)chunkSection.m_63019_()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                sectionTag.m_128365_("biomes", (Tag)biomeCodec.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)chunkSection.m_187996_()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                empty = false;
            }
            if (chunk instanceof FakeChunk) {
                FakeChunk fakeChunk = (FakeChunk)chunk;
                v1 = fakeChunk.blockLight[i + 1];
            } else {
                v1 = blockLight = lightingProvider.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)y));
            }
            if (blockLight != null && !blockLight.m_62575_()) {
                sectionTag.m_128382_("BlockLight", blockLight.m_7877_());
                empty = false;
            }
            if (chunk instanceof FakeChunk) {
                FakeChunk fakeChunk = (FakeChunk)chunk;
                v2 = fakeChunk.skyLight[i + 1];
            } else {
                v2 = skyLight = lightingProvider.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)y));
            }
            if (skyLight != null && !skyLight.m_62575_()) {
                sectionTag.m_128382_("SkyLight", skyLight.m_7877_());
                empty = false;
            }
            if (empty) continue;
            sectionsTag.add((Object)sectionTag);
        }
        level.m_128365_("sections", (Tag)sectionsTag);
        if (chunk instanceof FakeChunk) {
            FakeChunk fakeChunk = (FakeChunk)chunk;
            blockEntitiesTag = fakeChunk.serializedBlockEntities;
        } else {
            blockEntitiesTag = new ListTag();
            for (BlockPos pos : chunk.m_5928_()) {
                CompoundTag blockEntityTag = chunk.m_8051_(pos);
                if (blockEntityTag == null) continue;
                blockEntitiesTag.add((Object)blockEntityTag);
            }
        }
        level.m_128365_("block_entities", (Tag)blockEntitiesTag);
        CompoundTag hightmapsTag = new CompoundTag();
        for (Map.Entry entry : chunk.m_6890_()) {
            if (!chunk.m_6415_().m_62500_().contains(entry.getKey())) continue;
            hightmapsTag.m_128365_(((Heightmap.Types)entry.getKey()).m_64294_(), (Tag)new LongArrayTag(((Heightmap)entry.getValue()).m_64239_()));
        }
        level.m_128365_("Heightmaps", (Tag)hightmapsTag);
        return level;
    }

    @Nullable
    public static Supplier<LevelChunk> deserialize(ChunkPos pos, CompoundTag level, Level world) {
        int y;
        ChunkPos chunkPos = new ChunkPos(level.m_128451_("xPos"), level.m_128451_("zPos"));
        if (!Objects.equals(pos, chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)pos, (Object)pos, (Object)chunkPos);
        }
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        Codec biomeCodec = PalettedContainer.m_238371_((IdMap)biomeRegistry.m_206115_(), (Codec)biomeRegistry.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)biomeRegistry.m_246971_(Biomes.f_48202_));
        ListTag sectionsTag = level.m_128437_("sections", 10);
        LevelChunkSection[] chunkSections = new LevelChunkSection[world.m_151559_()];
        Object[] blockLight = new DataLayer[chunkSections.length + 2];
        DataLayer[] skyLight = new DataLayer[chunkSections.length + 2];
        Arrays.fill(blockLight, COMPLETELY_DARK);
        for (int i = 0; i < sectionsTag.size(); ++i) {
            CompoundTag sectionTag = sectionsTag.m_128728_(i);
            y = sectionTag.m_128445_("Y");
            int yIndex = world.m_151566_(y);
            if (yIndex < -1 || yIndex > chunkSections.length) continue;
            if (yIndex >= 0 && yIndex < chunkSections.length) {
                PalettedContainer blocks = sectionTag.m_128425_("block_states", 10) ? (PalettedContainer)BLOCK_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)sectionTag.m_128469_("block_states")).promotePartial(errorMessage -> ChunkSerializer.logRecoverableError(chunkPos, y, errorMessage)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
                PalettedContainer biomes = sectionTag.m_128425_("biomes", 10) ? (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)sectionTag.m_128469_("biomes")).promotePartial(errorMessage -> ChunkSerializer.logRecoverableError(chunkPos, y, errorMessage)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new PalettedContainer(biomeRegistry.m_206115_(), (Object)biomeRegistry.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
                LevelChunkSection chunkSection = new LevelChunkSection(blocks, (PalettedContainerRO)biomes);
                chunkSection.m_63018_();
                if (!chunkSection.m_188008_()) {
                    chunkSections[yIndex] = chunkSection;
                }
            }
            if (sectionTag.m_128425_("BlockLight", 7)) {
                blockLight[yIndex + 1] = new DataLayer(sectionTag.m_128463_("BlockLight"));
            }
            if (!sectionTag.m_128425_("SkyLight", 7)) continue;
            skyLight[yIndex + 1] = new DataLayer(sectionTag.m_128463_("SkyLight"));
        }
        DataLayer fullSectionAbove = null;
        DataLayer inferredSection = COMPLETELY_LIT;
        for (y = skyLight.length - 1; y >= 0; --y) {
            DataLayer section = skyLight[y];
            if (section != null) {
                inferredSection = null;
                fullSectionAbove = section;
                continue;
            }
            if (inferredSection == null) {
                assert (fullSectionAbove != null);
                inferredSection = ChunkSerializer.floodSkylightFromAbove(fullSectionAbove);
            }
            skyLight[y] = inferredSection;
        }
        FakeChunk chunk = new FakeChunk(world, pos, chunkSections);
        CompoundTag hightmapsTag = level.m_128469_("Heightmaps");
        EnumSet<Heightmap.Types> missingHightmapTypes = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types type : chunk.m_6415_().m_62500_()) {
            String key = type.m_64294_();
            if (hightmapsTag.m_128425_(key, 12)) {
                chunk.m_6511_(type, hightmapsTag.m_128467_(key));
                continue;
            }
            missingHightmapTypes.add(type);
        }
        Heightmap.m_64256_((ChunkAccess)chunk, missingHightmapTypes);
        if (!BobbyConfig.isNoBlockEntities()) {
            ListTag blockEntitiesTag = level.m_128437_("block_entities", 10);
            for (int i = 0; i < blockEntitiesTag.size(); ++i) {
                chunk.m_5604_(blockEntitiesTag.m_128728_(i));
            }
        }
        return ChunkSerializer.loadChunk(chunk, (DataLayer[])blockLight, skyLight);
    }

    private static Supplier<LevelChunk> loadChunk(FakeChunk chunk, DataLayer[] blockLight, DataLayer[] skyLight) {
        return () -> {
            ChunkPos pos = chunk.m_7697_();
            Level world = chunk.m_62953_();
            LevelChunkSection[] chunkSections = chunk.m_7103_();
            boolean hasSkyLight = world.m_6042_().f_223549_();
            ChunkSource chunkManager = world.m_7726_();
            LevelLightEngine lightingProvider = chunkManager.m_7827_();
            LightingProviderExt lightingProviderExt = LightingProviderExt.get(lightingProvider);
            ChunkLightProviderExt blockLightProvider = ChunkLightProviderExt.get(lightingProvider.m_75814_(LightLayer.BLOCK));
            ChunkLightProviderExt skyLightProvider = ChunkLightProviderExt.get(lightingProvider.m_75814_(LightLayer.SKY));
            lightingProviderExt.bobby_enabledColumn(pos.m_45588_());
            for (int i = -1; i < chunkSections.length + 1; ++i) {
                int y = world.m_151568_(i);
                if (blockLightProvider != null) {
                    blockLightProvider.bobby_addSectionData(SectionPos.m_123196_((ChunkPos)pos, (int)y).m_123252_(), blockLight[i + 1]);
                }
                if (skyLightProvider == null || !hasSkyLight) continue;
                skyLightProvider.bobby_addSectionData(SectionPos.m_123196_((ChunkPos)pos, (int)y).m_123252_(), skyLight[i + 1]);
            }
            chunk.setTainted(BobbyConfig.isTaintFakeChunks());
            for (BlockPos blockPos : chunk.m_5928_()) {
                chunk.m_7702_(blockPos);
            }
            return chunk;
        };
    }

    public static Pair<LevelChunk, Supplier<LevelChunk>> shallowCopy(LevelChunk original) {
        Level world = original.m_62953_();
        ChunkPos chunkPos = original.m_7697_();
        LevelChunkSection[] chunkSections = original.m_7103_();
        DataLayer[] blockLight = new DataLayer[chunkSections.length + 2];
        DataLayer[] skyLight = new DataLayer[chunkSections.length + 2];
        LevelLightEngine lightingProvider = world.m_7726_().m_7827_();
        int y = lightingProvider.m_164447_();
        int i = 0;
        while (y < lightingProvider.m_164448_()) {
            blockLight[i] = lightingProvider.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)y));
            skyLight[i] = lightingProvider.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)y));
            ++y;
            ++i;
        }
        FakeChunk fake = new FakeChunk(world, chunkPos, chunkSections);
        fake.blockLight = blockLight;
        fake.skyLight = skyLight;
        for (Map.Entry entry : original.m_6890_()) {
            fake.setHeightmap((Heightmap.Types)entry.getKey(), (Heightmap)entry.getValue());
        }
        ListTag blockEntitiesTag = new ListTag();
        for (BlockPos pos : original.m_5928_()) {
            CompoundTag blockEntityTag = original.m_8051_(pos);
            if (blockEntityTag == null) continue;
            blockEntitiesTag.add((Object)blockEntityTag);
            if (BobbyConfig.isNoBlockEntities()) continue;
            fake.m_5604_(blockEntityTag);
        }
        fake.serializedBlockEntities = blockEntitiesTag;
        return Pair.of((Object)((Object)fake), ChunkSerializer.loadChunk(fake, blockLight, skyLight));
    }

    private static DataLayer floodSkylightFromAbove(DataLayer above) {
        if (above.m_62575_()) {
            return new DataLayer();
        }
        byte[] aboveBytes = above.m_7877_();
        byte[] belowBytes = new byte[2048];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(aboveBytes, 0, belowBytes, i * 128, 128);
        }
        return new DataLayer(belowBytes);
    }

    private static void logRecoverableError(ChunkPos chunkPos, int y, String message) {
        LOGGER.error("Recoverable errors when loading section [" + chunkPos.f_45578_ + ", " + y + ", " + chunkPos.f_45579_ + "]: " + message);
    }

    static {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    COMPLETELY_LIT.m_62564_(x, y, z, 15);
                }
            }
        }
        BLOCK_CODEC = PalettedContainer.m_238371_((IdMap)Block.f_49791_, (Codec)BlockState.f_61039_, (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188137_, (Object)Blocks.f_50016_.m_49966_());
    }
}

