/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.KiwiGO;
import snownee.snow.CoreModule;
import snownee.snow.SnowRealMagic;
import snownee.snow.client.FallingSnowRenderer;
import snownee.snow.client.SnowClient;
import snownee.snow.client.SnowVariantMetadataSectionSerializer;
import snownee.snow.client.model.ModelDefinition;
import snownee.snow.client.model.SnowCoveredModel;
import snownee.snow.client.model.SnowVariantModel;

public class ClientProxy {
    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(ClientProxy.class);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CoreModule.ENTITY.get(), FallingSnowRenderer::new);
    }

    @SubscribeEvent
    public static void registerExtraModels(ModelEvent.RegisterAdditional event) {
        event.register(SnowClient.OVERLAY_MODEL);
        SnowClient.snowVariantMapping.clear();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        ModelBakery.f_244378_.m_247457_(resourceManager).forEach((key, resource) -> {
            ModelDefinition def;
            try {
                def = resource.m_215509_().m_214059_((MetadataSectionSerializer)SnowVariantMetadataSectionSerializer.SERIALIZER).orElse(null);
            }
            catch (IOException e) {
                return;
            }
            if (def == null || def.model == null) {
                return;
            }
            SnowClient.snowVariantMapping.put(ModelBakery.f_244378_.m_245273_(key), def);
            event.register(def.model);
        });
    }

    @SubscribeEvent
    public static void replaceConnected(ModelEvent.ModifyBakingResult event) {
        SnowClient.overrideBlocks.clear();
        for (ModelDefinition def : SnowClient.snowVariantMapping.values()) {
            if (def.overrideBlocks == null) continue;
            for (ResourceLocation override : def.overrideBlocks) {
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(override);
                if (block == Blocks.f_50016_) {
                    SnowRealMagic.LOGGER.error("Cannot handle snow variant override: {}, {}", (Object)def.model, (Object)override);
                    continue;
                }
                SnowClient.overrideBlocks.add(block);
            }
        }
        List<KiwiGO<Block>> allBlocks = List.of(CoreModule.TILE_BLOCK, CoreModule.FENCE, CoreModule.FENCE2, CoreModule.STAIRS, CoreModule.SLAB, CoreModule.FENCE_GATE, CoreModule.WALL);
        for (KiwiGO<Block> kiwiGO : allBlocks) {
            Block block = (Block)kiwiGO.get();
            for (BlockState state : block.m_49965_().m_61056_()) {
                ModelResourceLocation modelId = BlockModelShaper.m_110889_((ResourceLocation)ForgeRegistries.BLOCKS.getKey((Object)block), (BlockState)state);
                event.getModels().put(modelId, new SnowCoveredModel((BakedModel)event.getModels().get(modelId)));
            }
        }
        SnowClient.cachedOverlayModel = null;
        SnowClient.cachedSnowModel = null;
    }

    public static BakedModel getBlockModel(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    public static BakedModel getBlockModel(ResourceLocation location) {
        return Minecraft.m_91087_().m_91304_().getModel(location);
    }

    public static void renderFallingBlock(Entity entity, BlockState state, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockPos blockpos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20191_().f_82292_, (double)entity.m_20189_());
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BakedModel model = dispatcher.m_110910_(state);
        RandomSource random = RandomSource.m_216335_((long)42L);
        for (RenderType type : model.getRenderTypes(state, random, ModelData.EMPTY)) {
            dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)entity.m_9236_(), model, state, blockpos, poseStack, bufferSource.m_6299_(type), false, random, state.m_60726_(pos), OverlayTexture.f_118083_, ModelData.EMPTY, type);
        }
    }

    public static BakedModel onBakeModel(ResourceLocation resourceLocation, ModelState modelState, Function<Material, TextureAtlasSprite> sprites, ModelBaker modelBaker, BakedModel original) {
        if (modelState.getClass() != Variant.class) {
            return null;
        }
        ModelDefinition def = SnowClient.snowVariantMapping.get(resourceLocation);
        if (def == null) {
            return null;
        }
        Variant variantState = (Variant)modelState;
        variantState = new Variant(def.model, variantState.m_6189_(), variantState.m_7538_(), variantState.m_111886_());
        BakedModel variantModel = modelBaker.bake(def.model, (ModelState)variantState, sprites);
        return new SnowVariantModel(original, variantModel);
    }
}

