/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;

public final class GameEvents {
    public static InteractionResult onItemUse(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof SnowVariant)) {
            return InteractionResult.PASS;
        }
        SnowVariant snowVariant = (SnowVariant)block;
        ItemStack held = player.m_21205_();
        if (held.m_150930_(Items.f_42751_) || held.m_150930_(Items.f_41979_)) {
            return InteractionResult.PASS;
        }
        if (player.m_36298_(Blocks.f_50125_.m_49966_())) {
            if (GameEvents.playerCollectSnowball(level, pos, state, snowVariant) && !player.m_7500_()) {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42452_));
                held.m_41622_(1, (LivingEntity)player, stack -> stack.m_21190_(InteractionHand.MAIN_HAND));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player.m_36341_() && SnowCommonConfig.sneakSnowball) {
            if (GameEvents.playerCollectSnowball(level, pos, state, snowVariant)) {
                ItemStack snowball = new ItemStack((ItemLike)Items.f_42452_);
                if (!(player.m_7500_() && player.m_150109_().m_36063_(snowball) || player.m_36356_(snowball))) {
                    player.m_36176_(snowball, false);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static boolean playerCollectSnowball(Level level, BlockPos pos, BlockState state, SnowVariant snowVariant) {
        if (level.f_46443_) {
            return false;
        }
        BlockState newState = snowVariant.decreaseLayer(state, level, pos, true);
        level.m_46597_(pos, newState);
        int layers = snowVariant.layers(state, (BlockGetter)level, pos);
        BlockState snowState = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Math.max(layers, 1)));
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)snowState));
        return layers > 0 || !state.m_61138_((Property)SnowVariant.OPTIONAL_LAYERS);
    }

    public static boolean onDestroyedByPlayer(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        return state.onDestroyedByPlayer(world, pos, player, false, state.m_60819_());
    }
}

