/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.world.gen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModFeatures;
import top.ribs.scguns.world.NiterPatchConfiguration;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANTHRALITE_ORE_KEY = ModConfiguredFeatures.registerKey("anthralite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_ORE_KEY = ModConfiguredFeatures.registerKey("sulfur_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_SULFUR_ORE_KEY = ModConfiguredFeatures.registerKey("nether_sulfur_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VEHEMENT_COAL_ORE_KEY = ModConfiguredFeatures.registerKey("vehement_coal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RICH_PHOSPHORITE_ORE_KEY = ModConfiguredFeatures.registerKey("rich_phosphorite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PHOSPHORITE_KEY = ModConfiguredFeatures.registerKey("phosphorite");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NITER_CAVE_PATCH_KEY = ModConfiguredFeatures.registerKey("niter_cave_patch");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.f_144267_);
        BlockMatchTest netherrackReplaceables = new BlockMatchTest(Blocks.f_50134_);
        BlockMatchTest phosphoriteReplaceables = new BlockMatchTest((Block)ModBlocks.PHOSPHORITE.get());
        List<OreConfiguration.TargetBlockState> richPhosphoriteOres = List.of(OreConfiguration.m_161021_((RuleTest)phosphoriteReplaceables, (BlockState)((Block)ModBlocks.RICH_PHOSPHORITE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> phosphoriteOres = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.PHOSPHORITE.get()).m_49966_()));
        ModConfiguredFeatures.register(context, PHOSPHORITE_KEY, Feature.f_65731_, new OreConfiguration(phosphoriteOres, 48));
        ModConfiguredFeatures.register(context, RICH_PHOSPHORITE_ORE_KEY, Feature.f_65731_, new OreConfiguration(richPhosphoriteOres, 12));
        List<OreConfiguration.TargetBlockState> overworldAnthraliteOres = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.ANTHRALITE_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_ANTHRALITE_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> overworldSulfurOres = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.SULFUR_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_SULFUR_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> netherSulfurOres = List.of(OreConfiguration.m_161021_((RuleTest)netherrackReplaceables, (BlockState)((Block)ModBlocks.NETHER_SULFUR_ORE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> netherVehementCoalOres = List.of(OreConfiguration.m_161021_((RuleTest)netherrackReplaceables, (BlockState)((Block)ModBlocks.VEHEMENT_COAL_ORE.get()).m_49966_()));
        ModConfiguredFeatures.register(context, ANTHRALITE_ORE_KEY, Feature.f_65731_, new OreConfiguration(overworldAnthraliteOres, 10));
        ModConfiguredFeatures.register(context, SULFUR_ORE_KEY, Feature.f_65731_, new OreConfiguration(overworldSulfurOres, 9));
        ModConfiguredFeatures.register(context, NETHER_SULFUR_ORE_KEY, Feature.f_65731_, new OreConfiguration(netherSulfurOres, 12));
        ModConfiguredFeatures.register(context, VEHEMENT_COAL_ORE_KEY, Feature.f_65731_, new OreConfiguration(netherVehementCoalOres, 6));
        ModConfiguredFeatures.register(context, NITER_CAVE_PATCH_KEY, (Feature)ModFeatures.NITER_PATCH.get(), new NiterPatchConfiguration((Block)ModBlocks.NITER_LAYER.get(), 1, 3, 3, 16));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("scguns", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

