/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import top.ribs.scguns.block.GeothermalVentBlock;
import top.ribs.scguns.block.VentBlock;
import top.ribs.scguns.world.VentFeatureConfiguration;

public class VentFeature
extends Feature<VentFeatureConfiguration> {
    public VentFeature(Codec<VentFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<VentFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        WorldGenLevel world = context.m_159774_();
        VentFeatureConfiguration config = (VentFeatureConfiguration)context.m_159778_();
        int height = Mth.m_216271_((RandomSource)random, (int)config.minHeight(), (int)config.maxHeight());
        BlockPos magmaPos = pos.m_7495_();
        BlockState belowBlockState = world.m_8055_(magmaPos);
        if (config.shouldPlaceBaseBlock()) {
            boolean canPlaceBase = false;
            for (Block requiredBlock : config.requiredBelowBlocks()) {
                if (!belowBlockState.m_60713_(requiredBlock) || !world.m_8055_(magmaPos.m_7495_()).m_60783_((BlockGetter)world, magmaPos.m_7495_(), Direction.UP)) continue;
                canPlaceBase = true;
                break;
            }
            if (canPlaceBase) {
                world.m_7731_(magmaPos, config.baseBlock().m_49966_(), 3);
            } else if (!belowBlockState.m_60713_(config.baseBlock())) {
                return false;
            }
        } else if (!belowBlockState.m_60713_(config.baseBlock())) {
            return false;
        }
        boolean canBeActive = true;
        if (config.shouldCheckActiveLimit()) {
            canBeActive = this.countActiveVentsNearby((LevelAccessor)world, pos, config.checkRadius(), config.maxActiveNearby(), config.getVentBlock()) < config.maxActiveNearby();
        }
        for (int i = 0; i < height; ++i) {
            BlockPos currentPos = pos.m_6630_(i);
            VentBlock.VentType ventType = i == 0 ? VentBlock.VentType.BASE : (i == height - 1 ? VentBlock.VentType.TOP : VentBlock.VentType.MIDDLE);
            BlockState state = (BlockState)((BlockState)config.getVentBlock().m_49966_().m_61124_(VentBlock.VENT_TYPE, (Comparable)((Object)ventType))).m_61124_((Property)VentBlock.ACTIVE, (Comparable)Boolean.valueOf(canBeActive));
            if (config.requiresWaterlogged() && state.m_61138_((Property)GeothermalVentBlock.WATERLOGGED)) {
                state = (BlockState)state.m_61124_((Property)GeothermalVentBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (world.m_8055_(currentPos).m_247087_() && world.m_8055_(currentPos.m_7495_()).m_60734_() != Blocks.f_50016_) {
                world.m_7731_(currentPos, state, 3);
                if (!config.requiresWaterlogged()) continue;
                world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
                continue;
            }
            return false;
        }
        return true;
    }

    private int countActiveVentsNearby(LevelAccessor level, BlockPos pos, int checkRadius, int maxActive, Block ventBlock) {
        int activeCount = 0;
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-checkRadius, -checkRadius, -checkRadius), (BlockPos)pos.m_7918_(checkRadius, checkRadius, checkRadius))) {
            if (checkPos.equals((Object)pos)) continue;
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60713_(ventBlock) && ((Boolean)state.m_61143_((Property)VentBlock.ACTIVE)).booleanValue()) {
                ++activeCount;
            }
            if (activeCount < maxActive) continue;
            return activeCount;
        }
        return activeCount;
    }
}

