/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WaraxeItem
extends AxeItem {
    private final Vec3 slamRadius = new Vec3(5.0, 0.25, 5.0);

    public WaraxeItem(Item.Properties properties) {
        super((Tier)Tiers.IRON, 7.0f, -3.2f, properties);
    }

    public void applyHoldingPose(HumanoidModel<LivingEntity> model, float ageInTicks, LivingEntity entity, ItemStack stack, float delta) {
        boolean leftHanded = entity.m_5737_() == HumanoidArm.LEFT;
        float attackTime = 1.0f - model.f_102608_;
        attackTime *= attackTime;
        attackTime *= attackTime;
        attackTime = 1.0f - attackTime;
        float swingRotation = -Mth.m_14031_((float)(attackTime * (float)Math.PI)) / 1.25f;
        float baseRightArmX = 1.0471976f;
        float baseRightArmY = 0.5235988f;
        float baseLeftArmX = 1.3762634f;
        float baseLeftArmY = 0.2617994f;
        float swingOffset = swingRotation * 0.3490659f;
        model.f_102811_.f_104203_ = leftHanded ? -baseLeftArmX - swingRotation : -baseRightArmX - swingRotation;
        model.f_102811_.f_104204_ = leftHanded ? -baseLeftArmY - swingOffset : -baseRightArmY;
        model.f_102812_.f_104203_ = leftHanded ? -baseRightArmX - swingRotation : -baseLeftArmX - swingRotation;
        model.f_102812_.f_104204_ = leftHanded ? baseRightArmY : baseLeftArmY + swingOffset;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            boolean fullCharge;
            float f;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                f = player.m_36403_(0.5f);
            } else {
                f = 1.0f;
            }
            float attackStrength = f;
            boolean bl = fullCharge = attackStrength > 0.9f;
            if (fullCharge && attacker.f_19789_ > 0.0f) {
                this.performSlamAttack(attacker, target);
            } else {
                this.spawnSweepParticles(attacker);
            }
            attacker.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12316_, attacker.m_5720_(), 1.0f, 0.8f + attacker.m_217043_().m_188501_() * 0.4f);
        }
        return super.m_7579_(stack, target, attacker);
    }

    private void performSlamAttack(LivingEntity attacker, LivingEntity target) {
        AABB aabb = target.m_20191_().m_82377_(this.slamRadius.m_7096_(), this.slamRadius.m_7098_(), this.slamRadius.m_7094_());
        List entities = attacker.m_9236_().m_45976_(LivingEntity.class, aabb);
        attacker.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11913_, attacker.m_5720_(), 1.2f, 0.8f + attacker.m_217043_().m_188501_() * 0.4f);
        this.spawnShockwaveParticles(target);
        for (LivingEntity entity : entities) {
            if (entity == attacker || entity == target) continue;
            float damage = attacker instanceof Player ? 4.0f : 3.0f;
            entity.m_6469_(attacker.m_269291_().m_269333_(attacker), damage);
            this.spawnHitParticles(entity);
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_36335_().m_41524_((Item)this, 40);
        }
    }

    private void spawnSweepParticles(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        double angle = Math.toRadians(-entity.m_146908_());
        double offsetX = -Math.sin(angle) * 0.7;
        double offsetZ = Math.cos(angle) * 0.7;
        for (int i = 0; i < 3; ++i) {
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, entity.m_20185_() + offsetX, entity.m_20227_(0.5), entity.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnShockwaveParticles(LivingEntity target) {
        if (target.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)target.m_9236_();
        for (int i = 0; i < 20; ++i) {
            double angle = Math.PI * 2 * (double)i / 20.0;
            double offsetX = Math.cos(angle) * 1.5;
            double offsetZ = Math.sin(angle) * 1.5;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, target.m_20185_() + offsetX, target.m_20186_() + 0.1, target.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, target.m_20185_(), target.m_20186_() + 0.1, target.m_20189_(), 3, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnHitParticles(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
    }
}

