/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.init.ModEffects;

public class HealingBandageItem
extends Item {
    int healingAmount;
    List<MobEffectInstance> potionEffects;

    public HealingBandageItem(Item.Properties properties, int healingAmount, MobEffectInstance ... potionEffects) {
        super(properties);
        this.potionEffects = Arrays.stream(potionEffects).filter(Objects::nonNull).toList();
        this.healingAmount = healingAmount;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (!world.f_46443_) {
                player.m_5634_((float)this.healingAmount);
                if (player.m_21023_((MobEffect)ModEffects.LACERATED.get())) {
                    player.m_21195_((MobEffect)ModEffects.LACERATED.get());
                }
                for (MobEffectInstance effect : this.potionEffects) {
                    if (effect == null) continue;
                    player.m_7292_(new MobEffectInstance(effect));
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"item.scguns.healing_bandage.heal", (Object[])new Object[]{this.healingAmount}).m_130940_(ChatFormatting.GREEN));
        if (!this.potionEffects.isEmpty()) {
            for (MobEffectInstance effect : this.potionEffects) {
                if (effect == null) continue;
                effect.m_19544_();
                MutableComponent effectName = Component.m_237115_((String)effect.m_19544_().m_19481_()).m_130940_(ChatFormatting.BLUE);
                int durationInSeconds = effect.m_19557_() / 20;
                int minutes = durationInSeconds / 60;
                int seconds = durationInSeconds % 60;
                String formattedDuration = String.format(" (%02d:%02d)", minutes, seconds);
                MutableComponent effectDuration = Component.m_237113_((String)formattedDuration).m_130940_(ChatFormatting.BLUE);
                tooltip.add((Component)Component.m_237119_().m_7220_((Component)effectName).m_7220_((Component)effectDuration));
            }
        }
        super.m_7373_(stack, world, tooltip, flag);
    }
}

