/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.Config;
import top.ribs.scguns.item.ammo_boxes.CreativeAmmoBoxItem;

public abstract class AmmoBoxItem
extends Item {
    public static final String TAG_ITEMS = "Items";
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public AmmoBoxItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (stack.m_41613_() == 1 && action == ClickAction.SECONDARY) {
            ItemStack itemStackInSlot = slot.m_7993_();
            if (itemStackInSlot.m_41619_()) {
                this.playRemoveOneSound((Entity)player);
                AmmoBoxItem.removeOne(stack).ifPresent(removedStack -> AmmoBoxItem.add(stack, slot.m_150659_(removedStack)));
            } else if (itemStackInSlot.m_204117_(ItemTags.create((ResourceLocation)this.getAmmoTag()))) {
                int maxInsertCount = AmmoBoxItem.getMaxItemCount(stack) - AmmoBoxItem.getTotalItemCount(stack);
                int itemsToInsert = Math.min(itemStackInSlot.m_41613_(), maxInsertCount);
                int insertedItems = AmmoBoxItem.add(stack, slot.m_150647_(itemStackInSlot.m_41613_(), itemsToInsert, player));
                if (insertedItems > 0) {
                    this.playInsertSound((Entity)player);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (otherStack.m_41619_()) {
                AmmoBoxItem.removeOne(stack).ifPresent(removedStack -> {
                    this.playRemoveOneSound((Entity)player);
                    slotAccess.m_142104_(removedStack);
                });
            } else if (otherStack.m_204117_(ItemTags.create((ResourceLocation)this.getAmmoTag()))) {
                int maxInsertCount = AmmoBoxItem.getMaxItemCount(stack) - AmmoBoxItem.getTotalItemCount(stack);
                int itemsToInsert = Math.min(otherStack.m_41613_(), maxInsertCount);
                int insertedItems = AmmoBoxItem.add(stack, otherStack.m_255036_(itemsToInsert));
                if (insertedItems > 0) {
                    this.playInsertSound((Entity)player);
                    otherStack.m_41774_(insertedItems);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return AmmoBoxItem.getTotalItemCount(stack) > 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(1 + 12 * AmmoBoxItem.getTotalItemCount(stack) / AmmoBoxItem.getMaxItemCount(stack), 13);
    }

    protected abstract ResourceLocation getAmmoTag();

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public static int add(ItemStack pouchStack, ItemStack insertedStack) {
        if (!insertedStack.m_41619_() && insertedStack.m_204117_(ItemTags.create((ResourceLocation)((AmmoBoxItem)pouchStack.m_41720_()).getAmmoTag()))) {
            CompoundTag compoundTag = pouchStack.m_41784_();
            if (!compoundTag.m_128441_(TAG_ITEMS)) {
                compoundTag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
            }
            int maxItemCount = AmmoBoxItem.getMaxItemCount(pouchStack);
            int itemsToInsert = Math.min(insertedStack.m_41613_(), maxItemCount - AmmoBoxItem.getTotalItemCount(pouchStack));
            if (itemsToInsert == 0) {
                return 0;
            }
            ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag itemTag = listTag.m_128728_(i);
                ItemStack existingStack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (!ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)insertedStack)) continue;
                int remainingSpace = Math.min(existingStack.m_41741_() - existingStack.m_41613_(), itemsToInsert);
                existingStack.m_41769_(remainingSpace);
                existingStack.m_41739_(itemTag);
                listTag.set(i, (Tag)itemTag);
                if ((itemsToInsert -= remainingSpace) <= 0) break;
            }
            while (itemsToInsert > 0) {
                int countToInsert = Math.min(insertedStack.m_41741_(), itemsToInsert);
                ItemStack newItemStack = insertedStack.m_255036_(countToInsert);
                CompoundTag newItemTag = new CompoundTag();
                newItemStack.m_41739_(newItemTag);
                listTag.add((Object)newItemTag);
                itemsToInsert -= countToInsert;
            }
            compoundTag.m_128365_(TAG_ITEMS, (Tag)listTag);
            return insertedStack.m_41613_() - itemsToInsert;
        }
        return 0;
    }

    public static int getTotalItemCount(ItemStack stack) {
        return AmmoBoxItem.getContents(stack).mapToInt(ItemStack::m_41613_).sum();
    }

    private static Optional<ItemStack> removeOne(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        if (listTag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag itemTag = listTag.m_128728_(0);
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
        listTag.remove(0);
        if (listTag.isEmpty()) {
            stack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemStack);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        NonNullList nonNullList = NonNullList.m_122779_();
        AmmoBoxItem.getContents(stack).forEach(arg_0 -> nonNullList.add(arg_0));
        return Optional.of(new BundleTooltip(nonNullList, AmmoBoxItem.getTotalItemCount(stack)));
    }

    public void m_142023_(@NotNull ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, AmmoBoxItem.getContents(itemEntity.m_32055_()));
    }

    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        if (Screen.m_96638_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)this.getDescriptionKey()).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.scguns.hold_shift").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    protected abstract String getDescriptionKey();

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    protected void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public static int getMaxItemCount(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof AmmoBoxItem) {
            double multiplier = (Double)Config.COMMON.gameplay.ammoBoxCapacityMultiplier.get();
            return (int)((double)((AmmoBoxItem)item).getBaseMaxItemCount() * multiplier);
        }
        return 256;
    }

    protected abstract int getBaseMaxItemCount();

    public static Stream<ItemStack> getContents(ItemStack stack) {
        if (stack.m_41720_() instanceof CreativeAmmoBoxItem) {
            TagKey ammoTag = ItemTags.create((ResourceLocation)((CreativeAmmoBoxItem)stack.m_41720_()).getAmmoTag());
            return ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(ammoTag)).map(item -> new ItemStack((ItemLike)item, Integer.MAX_VALUE));
        }
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag == null) {
            return Stream.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        return listTag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }
}

