/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class AirCanisterItem
extends Item {
    private final int capacity;
    private static final int AIR_PER_USE = 50;
    private static final int HUNGER_COST = 1;
    private static final int USE_COOLDOWN = 10;

    public AirCanisterItem(Item.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<IEnergyStorage> airStorage = LazyOptional.of(() -> new AirStorage(stack, AirCanisterItem.this.capacity));

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                return cap == ForgeCapabilities.ENERGY ? this.airStorage.cast() : LazyOptional.empty();
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        int maxAir;
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        FoodData foodData = player.m_36324_();
        int currentAir = this.getAirStored(stack);
        if (currentAir >= (maxAir = this.getMaxAirStored(stack))) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (foodData.m_38702_() < 1 && !player.m_7500_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        IEnergyStorage airStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        int airAdded = airStorage.receiveEnergy(50, false);
        if (airAdded > 0) {
            if (!player.m_7500_() && !level.f_46443_) {
                foodData.m_38703_(0.5f);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12312_, SoundSource.PLAYERS, 0.5f, 1.2f);
            player.m_36335_().m_41524_((Item)this, 10);
            this.updateDurabilityDisplay(stack);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        int airStored = this.getAirStored(stack);
        int maxAir = this.getMaxAirStored(stack);
        if (maxAir == 0) {
            return 0;
        }
        return Math.round(13.0f * (float)airStored / (float)maxAir);
    }

    public int m_142159_(ItemStack stack) {
        int airStored = this.getAirStored(stack);
        int maxAir = this.getMaxAirStored(stack);
        if (maxAir == 0) {
            return 0x808080;
        }
        float ratio = (float)airStored / (float)maxAir;
        if (ratio < 0.25f) {
            return 0xFF4444;
        }
        if (ratio < 0.5f) {
            return 0xFFAA00;
        }
        return 43775;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        int airStored = this.getAirStored(stack);
        int maxAir = this.getMaxAirStored(stack);
        tooltip.add((Component)Component.m_237115_((String)"info.scguns.air_stored").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(airStored + " / " + maxAir)).m_130940_(ChatFormatting.AQUA)));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"info.scguns.air_canister.usage").m_130940_(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.hold_shift").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public int getAirStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxAirStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(this.capacity);
    }

    private void updateDurabilityDisplay(ItemStack stack) {
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public int m_8105_(ItemStack stack) {
        return 10;
    }

    public static class AirStorage
    implements IEnergyStorage {
        private final ItemStack stack;
        private final int capacity;
        private int air;

        public AirStorage(ItemStack stack, int capacity) {
            this.stack = stack;
            this.capacity = capacity;
            this.air = this.loadAirFromNBT();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int airReceived = Math.min(this.capacity - this.air, maxReceive);
            if (!simulate && airReceived > 0) {
                this.air += airReceived;
                this.updateAirTag();
            }
            return airReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int airExtracted = Math.min(this.air, maxExtract);
            if (!simulate && airExtracted > 0) {
                this.air -= airExtracted;
                this.updateAirTag();
            }
            return airExtracted;
        }

        public int getEnergyStored() {
            return this.air;
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        private void updateAirTag() {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128405_("AirStored", this.air);
        }

        private int loadAirFromNBT() {
            CompoundTag tag = this.stack.m_41783_();
            return tag != null && tag.m_128425_("AirStored", 3) ? tag.m_128451_("AirStored") : 0;
        }
    }
}

