/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import com.github.sculkhorde.common.entity.infection.CursorSurfacePurifierEntity;
import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.systems.infestation_systems.block_infestation_system.BlockInfestationSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.ribs.scguns.Config;
import top.ribs.scguns.entity.projectile.FireRoundEntity;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.event.GunProjectileHitEvent;

public class SculkHordeEvents {
    @SubscribeEvent
    public static void onProjectileHit(GunProjectileHitEvent event) {
        if (!((Boolean)Config.COMMON.gameplay.enableSculkPurification.get()).booleanValue()) {
            return;
        }
        if (event.getProjectile().m_9236_().f_46443_) {
            return;
        }
        ProjectileEntity projectile = event.getProjectile();
        if (!(projectile instanceof FireRoundEntity)) {
            return;
        }
        Level level = projectile.m_9236_();
        HitResult result = event.getRayTrace();
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)result;
            SculkHordeEvents.SpawnCursorAndDisinfect(1, blockResult.m_82425_(), level);
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entResult = (EntityHitResult)result;
            Entity entity = entResult.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.PURITY.get(), 200));
            }
            SculkHordeEvents.SpawnCursorAndDisinfect(1, entity.m_20183_(), level);
        }
    }

    private static void SpawnCursorAndDisinfect(int size, BlockPos pos, Level level) {
        for (int y = -size; y < size; ++y) {
            for (int x = -size; x < size; ++x) {
                for (int z = -size; z < size; ++z) {
                    BlockPos new_pos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    BlockInfestationSystem.tryToCureBlock((ServerLevel)((ServerLevel)level), (BlockPos)new_pos);
                }
            }
        }
        if (Math.random() >= 0.33) {
            CursorSurfacePurifierEntity cursorEntity = new CursorSurfacePurifierEntity(level);
            cursorEntity.m_146884_(pos.m_252807_());
            cursorEntity.setMaxTransformations(8);
            cursorEntity.setMaxRange(50);
            cursorEntity.setSearchIterationsPerTick(5);
            cursorEntity.setMaxLifeTimeMillis(5000L);
            cursorEntity.setTickIntervalMilliseconds(150L);
            level.m_7967_((Entity)cursorEntity);
        }
    }
}

