/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.throwable.ThrowableItemEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;

public class ThrowableShotballEntity
extends ThrowableItemEntity {
    private static final int MAX_BOUNCES = 3;
    private static final float BOUNCE_VELOCITY_RETENTION = 0.8f;
    private static final float MIN_BOUNCE_VELOCITY = 0.05f;
    private static final float BASE_DAMAGE = 9.0f;
    private static final float DAMAGE_REDUCTION_PER_BOUNCE = 0.85f;
    private int bouncesLeft;
    private float currentDamageMultiplier = 1.0f;

    public ThrowableShotballEntity(EntityType<? extends ThrowableItemEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.bouncesLeft = 3;
    }

    public ThrowableShotballEntity(Level world, LivingEntity entity) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_SHOTBALL.get()), world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.04f);
        this.setItem(new ItemStack((ItemLike)ModItems.SHOTBALL.get()));
        this.setMaxLife(160);
        this.bouncesLeft = 3;
    }

    protected void m_8097_() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.bouncesLeft <= 0 && this.m_20184_().m_82553_() < (double)0.05f) {
            this.spawnDeathParticles(this.m_20182_());
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void m_6532_(HitResult result) {
        switch (result.m_6662_()) {
            case BLOCK: {
                BlockHitResult blockResult = (BlockHitResult)result;
                if (this.shouldBounce && this.bouncesLeft > 0) {
                    BlockState state = this.m_9236_().m_8055_(blockResult.m_82425_());
                    double speed = this.m_20184_().m_82553_();
                    if (speed > (double)0.05f) {
                        this.m_9236_().m_6263_(null, blockResult.m_82450_().f_82479_, blockResult.m_82450_().f_82480_, blockResult.m_82450_().f_82481_, SoundEvents.f_12446_, SoundSource.NEUTRAL, 0.8f, 1.2f + (this.f_19796_.m_188501_() - 0.5f) * 0.4f);
                        this.spawnBounceParticles(blockResult.m_82450_());
                        this.bounce(blockResult.m_82434_());
                        --this.bouncesLeft;
                        this.currentDamageMultiplier *= 0.85f;
                        this.m_20256_(this.m_20184_().m_82520_((this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.1));
                        break;
                    }
                    this.spawnDeathParticles(this.m_20182_());
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    break;
                }
                this.spawnDeathParticles(blockResult.m_82450_());
                this.m_142687_(Entity.RemovalReason.KILLED);
                break;
            }
            case ENTITY: {
                EntityHitResult entityResult = (EntityHitResult)result;
                Entity entity = entityResult.m_82443_();
                if (this.shouldBounce && this.bouncesLeft > 0) {
                    double speed = this.m_20184_().m_82553_();
                    if (speed > 0.1) {
                        float damage = 9.0f * this.currentDamageMultiplier * Math.min(1.0f, (float)(speed / 1.5));
                        entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), damage);
                        this.m_9236_().m_6263_(null, entityResult.m_82450_().f_82479_, entityResult.m_82450_().f_82480_, entityResult.m_82450_().f_82481_, SoundEvents.f_12391_, SoundSource.NEUTRAL, 0.6f, 1.0f + (this.f_19796_.m_188501_() - 0.5f) * 0.4f);
                        this.spawnEntityHitParticles(entityResult.m_82450_());
                    }
                    this.bounce(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 0.8, 0.6));
                    --this.bouncesLeft;
                    this.currentDamageMultiplier *= 0.85f;
                    break;
                }
                if (this.m_20184_().m_82553_() > 0.1) {
                    float damage = 9.0f * this.currentDamageMultiplier;
                    entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), damage);
                    this.spawnEntityHitParticles(entityResult.m_82450_());
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
                break;
            }
        }
    }

    @Override
    void bounce(Direction direction) {
        switch (direction.m_122434_()) {
            case X: {
                this.m_20256_(this.m_20184_().m_82542_((double)-0.8f, 0.85, 0.85));
                break;
            }
            case Y: {
                this.m_20256_(this.m_20184_().m_82542_(0.85, -0.5600000083446502, 0.85));
                if (!(this.m_20184_().m_7098_() < (double)(this.m_7139_() * 2.0f))) break;
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.1, 1.0));
                break;
            }
            case Z: {
                this.m_20256_(this.m_20184_().m_82542_(0.85, 0.85, (double)-0.8f));
            }
        }
    }

    @Override
    public void onDeath() {
        this.spawnFinalParticles(this.m_20182_());
        this.spawnDeathParticles(this.m_20182_());
    }

    public int getBouncesLeft() {
        return this.bouncesLeft;
    }

    public float getCurrentDamage() {
        return 9.0f * this.currentDamageMultiplier;
    }

    private void spawnBounceParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 4; ++i) {
                double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                double velocityY = this.f_19796_.m_188500_() * 0.4;
                double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, position.f_82479_, position.f_82480_, position.f_82481_, 1, velocityX, velocityY, velocityZ, 0.04);
            }
        }
    }

    private void spawnEntityHitParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 5; ++i) {
                double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double velocityY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, position.f_82479_, position.f_82480_, position.f_82481_, 1, velocityX, velocityY, velocityZ, 0.06);
            }
        }
    }

    private void spawnFinalParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (i = 0; i < 4; ++i) {
                double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double velocityY = this.f_19796_.m_188500_() * 0.2;
                double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, position.f_82479_, position.f_82480_, position.f_82481_, 1, velocityX, velocityY, velocityZ, 0.04);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, position.f_82479_, position.f_82480_, position.f_82481_, 1, velocityX, velocityY, velocityZ, 0.02);
            }
            if (this.m_20184_().m_7098_() <= 0.01) {
                for (i = 0; i < 3; ++i) {
                    double dustX = position.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.4;
                    double dustY = position.f_82480_;
                    double dustZ = position.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.4;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, dustX, dustY, dustZ, 1, 0.0, 0.05, 0.0, 0.01);
                }
            }
        }
    }

    private void spawnDeathParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            double velocityZ;
            double velocityY;
            double velocityX;
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (i = 0; i < 6; ++i) {
                velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                velocityY = this.f_19796_.m_188500_() * 0.4 + 0.1;
                velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, position.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.3, position.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.2, position.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.3, 1, velocityX, velocityY, velocityZ, 0.02);
            }
            for (i = 0; i < 4; ++i) {
                velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                velocityY = this.f_19796_.m_188500_() * 0.3 + 0.05;
                velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, position.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.4, position.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.3, position.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.4, 1, velocityX, velocityY, velocityZ, 0.01);
            }
            this.m_9236_().m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_11937_, SoundSource.NEUTRAL, 0.3f, 1.8f + (this.f_19796_.m_188501_() - 0.5f) * 0.4f);
        }
    }
}

