/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;

public class OsborneSlugProjectileEntity
extends ProjectileEntity {
    private static final float SHIELD_DISABLE_CHANCE = 0.9f;
    private static final float SHIELD_DAMAGE_PENETRATION = 0.75f;
    private static final float MAX_BREAKABLE_HARDNESS = 6.0f;
    private static final float HEADSHOT_EFFECT_DURATION_MULTIPLIER = 1.5f;
    private static final float PENETRATION_EFFECT_REDUCTION = 0.8f;
    private static final List<Block> UNBREAKABLE_BLOCKS = Arrays.asList(Blocks.f_50752_, Blocks.f_50080_, Blocks.f_50723_, Blocks.f_50258_, Blocks.f_50722_, Blocks.f_220863_);
    private int remainingPenetrations;

    public OsborneSlugProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.remainingPenetrations = 3;
        this.setArmorBypassAmount(5.0f);
    }

    public OsborneSlugProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        int collateralLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.COLLATERAL.get()), (ItemStack)weapon);
        this.remainingPenetrations = 3 + collateralLevel;
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult blockResult = OsborneSlugProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            List<ProjectileEntity.EntityResult> hitEntities = this.findEntitiesOnPath(startVec, endVec);
            boolean hitSomething = false;
            while (this.remainingPenetrations > 0) {
                double blockDist = blockResult.m_6662_() != HitResult.Type.MISS ? startVec.m_82557_(blockResult.m_82450_()) : Double.MAX_VALUE;
                ProjectileEntity.EntityResult closestEntity = null;
                double closestEntityDist = Double.MAX_VALUE;
                if (hitEntities != null && !hitEntities.isEmpty()) {
                    for (ProjectileEntity.EntityResult entity : hitEntities) {
                        double dist = startVec.m_82557_(entity.getHitPos());
                        if (!(dist < closestEntityDist)) continue;
                        closestEntityDist = dist;
                        closestEntity = entity;
                    }
                }
                if (blockDist < closestEntityDist && blockResult.m_6662_() != HitResult.Type.MISS) {
                    BlockState state = this.m_9236_().m_8055_(blockResult.m_82425_());
                    if (!this.canBreakBlock(state, blockResult.m_82425_())) {
                        this.m_142687_(Entity.RemovalReason.KILLED);
                        return;
                    }
                    Vec3 hitLoc = blockResult.m_82450_();
                    this.onHitBlock(state, blockResult.m_82425_(), blockResult.m_82434_(), hitLoc.f_82479_, hitLoc.f_82480_, hitLoc.f_82481_);
                    --this.remainingPenetrations;
                    hitSomething = true;
                    startVec = hitLoc.m_82549_(this.m_20184_().m_82490_(0.01));
                    endVec = startVec.m_82549_(this.m_20184_());
                    blockResult = OsborneSlugProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
                    continue;
                }
                if (closestEntity == null) break;
                this.onHitEntity(closestEntity.getEntity(), closestEntity.getHitPos(), startVec, endVec, closestEntity.isHeadshot());
                --this.remainingPenetrations;
                hitSomething = true;
                hitEntities.remove(closestEntity);
            }
            if (hitSomething && this.remainingPenetrations <= 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        this.updateHeading();
        if (this.f_19797_ >= this.life) {
            this.onExpired();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        boolean canBreak = this.canBreakBlock(state, pos);
        if (!this.m_9236_().f_46443_) {
            if (canBreak) {
                this.m_9236_().m_46961_(pos, true);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), x, y, z, 30, 0.0, 0.0, 0.0, 0.15);
                this.m_9236_().m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_20256_(this.m_20184_().m_82542_(0.8, 0.8, 0.8));
            } else {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, 10, 0.0, 0.0, 0.0, 0.1);
                PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
                if (!((Boolean)Config.COMMON.gameplay.griefing.enableBlockBreaking.get()).booleanValue()) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        }
    }

    private boolean canBreakBlock(BlockState state, BlockPos pos) {
        if (!((Boolean)Config.COMMON.gameplay.griefing.enableBlockBreaking.get()).booleanValue()) {
            return false;
        }
        if (UNBREAKABLE_BLOCKS.contains(state.m_60734_())) {
            return false;
        }
        float hardness = state.m_60800_((BlockGetter)this.m_9236_(), pos);
        if (hardness < 0.0f || hardness > 6.0f) {
            return false;
        }
        if (state.m_155947_()) {
            return false;
        }
        return state.m_60819_().m_76178_();
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingTarget;
        if (entity.m_19879_() == this.shooterId) {
            return;
        }
        float damage = this.getDamage();
        damage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage);
        damage *= this.advantageMultiplier(entity);
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        if (entity instanceof LivingEntity) {
            livingTarget = (LivingEntity)entity;
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner());
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage, 0.9f);
        if (blocked) {
            float penetratingDamage = damage * 0.75f;
            entity.m_6469_(source, penetratingDamage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.applyEffect(livingEntity, 0.75f, headshot);
            }
        } else {
            entity.m_6469_(source, damage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                float effectPower = (float)Math.pow(0.8f, 3 - this.remainingPenetrations);
                this.applyEffect(livingEntity, effectPower, headshot);
            }
        }
        if (this.shooter instanceof Player) {
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 0, entity instanceof Player));
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
        if (this.remainingPenetrations > 0) {
            --this.remainingPenetrations;
            entity.f_19802_ = 0;
            Vec3 motion = this.m_20184_();
            this.m_6034_(this.m_20185_() + motion.f_82479_ * 0.2, this.m_20186_() + motion.f_82480_ * 0.2, this.m_20189_() + motion.f_82481_ * 0.2);
            this.m_20256_(motion.m_82542_(0.8, 0.8, 0.8));
        }
    }

    private void applyEffect(LivingEntity target, float powerMultiplier, boolean headshot) {
        ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
        if (effectLocation != null) {
            MobEffect effect;
            double distanceToShooter;
            float effectChance = this.getProjectile().getImpactEffectChance() * powerMultiplier;
            if (headshot) {
                effectChance = Math.min(1.0f, effectChance * 1.25f);
            }
            if ((distanceToShooter = (double)target.m_20270_(this.getOwner())) < 10.0) {
                effectChance = Math.min(1.0f, effectChance * (1.0f + 0.2f * (1.0f - (float)(distanceToShooter / 10.0))));
            }
            if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                int duration = this.getProjectile().getImpactEffectDuration();
                if (headshot) {
                    duration = (int)((float)duration * 1.5f);
                }
                duration = (int)((float)duration * powerMultiplier);
                int baseAmplifier = this.getProjectile().getImpactEffectAmplifier();
                int reducedAmplifier = Math.max(0, (int)((float)baseAmplifier * powerMultiplier));
                target.m_7292_(new MobEffectInstance(effect, duration, reducedAmplifier));
            }
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED && this.remainingPenetrations > 0 && this.f_19797_ < this.life) {
            return;
        }
        super.m_142687_(reason);
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1 && this.f_19797_ < this.life && this.f_19797_ % 2 == 0) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double velocityY = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            if (this.remainingPenetrations < 3) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123808_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, velocityX * 2.0, velocityY * 2.0, velocityZ * 2.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, velocityX, velocityY, velocityZ);
            } else {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123808_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, velocityX, velocityY, velocityZ);
            }
        }
    }

    @Override
    public void onExpired() {
        this.spawnExplosionParticles(new Vec3(this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_()));
    }

    private void spawnExplosionParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            int particleCount = this.remainingPenetrations < 3 ? 8 : 5;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.RAMROD_IMPACT.get()), position.f_82479_, position.f_82480_, position.f_82481_, particleCount, 0.0, 0.0, 0.0, 0.1);
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double speedY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
            }
        }
    }
}

