/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.player;

import java.util.ArrayList;
import java.util.List;
import top.ribs.scguns.entity.player.GunTierRegistry;

public class GunTier {
    private final String id;
    private final int level;
    private final String tagName;
    private final int raidLevel;
    private final List<String> previousTierIds;

    public GunTier(String id, int level, String tagName, int raidLevel) {
        this.id = id;
        this.level = level;
        this.tagName = tagName;
        this.raidLevel = raidLevel;
        this.previousTierIds = new ArrayList<String>();
    }

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getRaidLevel() {
        return this.raidLevel;
    }

    public List<String> getPreviousTierIds() {
        return new ArrayList<String>(this.previousTierIds);
    }

    public GunTier addPreviousTier(String tierId) {
        if (!this.previousTierIds.contains(tierId)) {
            this.previousTierIds.add(tierId);
        }
        return this;
    }

    public List<GunTier> getAvailableMobTiers() {
        ArrayList<GunTier> tiers = new ArrayList<GunTier>();
        for (String id : this.previousTierIds) {
            GunTier tier = GunTierRegistry.getTier(id);
            if (tier == null) continue;
            tiers.add(tier);
        }
        return tiers;
    }

    public String toString() {
        return "GunTier{id='" + this.id + "', level=" + this.level + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GunTier)) {
            return false;
        }
        GunTier other = (GunTier)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

