/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.entity.projectile.SulfurGasCloudEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.init.ModSounds;

public class SulfurheadEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(SulfurheadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(SulfurheadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PRIMED = SynchedEntityData.m_135353_(SulfurheadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float LOW_HEALTH_THRESHOLD = 0.3f;
    private static final float GAS_CLOUD_RADIUS = 6.0f;
    private static final int GAS_CLOUD_DURATION = 200;
    private static final int MAX_SWELL = 43;
    private int oldSwell;
    private int swell;
    private boolean hasTriggeredGasCloud = false;

    public SulfurheadEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(PRIMED, (Object)false);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.isAttacking() && this.getAttackTimeout() > 0) {
                this.setAttackTimeout(this.getAttackTimeout() - 1);
                if (this.getAttackTimeout() <= 0) {
                    this.setAttacking(false);
                }
            }
            if (this.m_6084_() && this.isLowHealth() && !this.hasTriggeredGasCloud && !this.isPrimed()) {
                this.setPrimed(true);
                this.m_9236_().m_7605_((Entity)this, (byte)5);
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.8f);
            }
            if (this.isPrimed() && this.swell >= 43) {
                this.swell = 43;
                this.spawnGasCloudAndDie();
            }
        }
        if (this.m_6084_()) {
            this.oldSwell = this.swell++;
            if (!this.isPrimed() && this.swell > 0) {
                --this.swell;
            }
            if (this.swell < 0) {
                this.swell = 0;
            }
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(12);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setPrimed(boolean primed) {
        this.f_19804_.m_135381_(PRIMED, (Object)primed);
    }

    public boolean isPrimed() {
        return (Boolean)this.f_19804_.m_135370_(PRIMED);
    }

    public boolean isLowHealth() {
        return this.m_21223_() / this.m_21233_() <= 0.3f;
    }

    public float getSwelling(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oldSwell, (float)this.swell) / 41.0f;
    }

    private void spawnGasCloudAndDie() {
        if (!this.m_9236_().f_46443_ && !this.hasTriggeredGasCloud) {
            this.hasTriggeredGasCloud = true;
            Vec3 center = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
            SulfurGasCloudEntity gasCloud = new SulfurGasCloudEntity((EntityType)ModEntities.SULFUR_GAS_CLOUD.get(), this.m_9236_(), center, 6.0f, 200, 300, 2);
            this.m_9236_().m_7967_((Entity)gasCloud);
            this.spawnDeathParticleBurst(center);
            this.m_5496_(SoundEvents.f_11789_, 1.5f, 0.8f);
            this.m_146870_();
        }
    }

    private void spawnDeathParticleBurst(Vec3 center) {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        double speed;
        double angle;
        int i;
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        int smokeParticles = 40;
        int dustParticles = 30;
        for (i = 0; i < smokeParticles; ++i) {
            angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double verticalAngle = (this.f_19796_.m_188500_() - 0.5) * Math.PI;
            speed = 0.15 + this.f_19796_.m_188500_() * 0.25;
            xSpeed = Math.cos(angle) * Math.cos(verticalAngle) * speed;
            ySpeed = Math.sin(verticalAngle) * speed + 0.1;
            zSpeed = Math.sin(angle) * Math.cos(verticalAngle) * speed;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SULFUR_SMOKE.get()), center.f_82479_, center.f_82480_, center.f_82481_, 3, xSpeed, ySpeed, zSpeed, 0.2);
        }
        for (i = 0; i < dustParticles; ++i) {
            angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double radius = this.f_19796_.m_188500_() * 1.5;
            speed = 0.1 + this.f_19796_.m_188500_() * 0.15;
            xSpeed = Math.cos(angle) * speed;
            ySpeed = 0.05 + this.f_19796_.m_188500_() * 0.1;
            zSpeed = Math.sin(angle) * speed;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SULFUR_DUST.get()), center.f_82479_ + Math.cos(angle) * radius, center.f_82480_, center.f_82481_ + Math.sin(angle) * radius, 2, xSpeed, ySpeed, zSpeed, 0.15);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_9236_().f_46443_ && pSource.m_7639_() instanceof Player) {
            return super.m_6469_(pSource, pAmount);
        }
        if (!this.m_9236_().f_46443_ && !(pSource.m_7639_() instanceof Player)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false){

            protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !SulfurheadEntity.this.isAttacking()) {
                    SulfurheadEntity.this.setAttacking(true);
                    this.m_25563_();
                    this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                    this.f_25540_.m_7327_((Entity)pEnemy);
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> !((Player)player).m_7500_() && !((Player)player).m_5833_()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.33).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SULFURHEAD_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SULFURHEAD_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SULFURHEAD_DIE.get();
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128376_("Swell", (short)this.swell);
        tag.m_128379_("HasTriggeredGasCloud", this.hasTriggeredGasCloud);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.oldSwell = this.swell = (int)tag.m_128448_("Swell");
        this.hasTriggeredGasCloud = tag.m_128471_("HasTriggeredGasCloud");
    }
}

