/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import top.ribs.scguns.entity.projectile.TraumaHookEntity;

public class TraumaHookRenderer
extends EntityRenderer<TraumaHookEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/fishing_hook.png");

    public TraumaHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TraumaHookEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity owner = entity.m_19749_();
        if (owner != null) {
            this.renderFishingLine(entity, owner, partialTicks, poseStack, buffer, packedLight);
        }
        this.renderHook(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderHook(TraumaHookEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        TraumaHookRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1);
        TraumaHookRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1);
        TraumaHookRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0);
        TraumaHookRenderer.vertex(vertexConsumer, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
    }

    private void renderFishingLine(TraumaHookEntity hook, Entity owner, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        double ownerX = Mth.m_14139_((double)partialTicks, (double)owner.f_19854_, (double)owner.m_20185_());
        double ownerY = Mth.m_14139_((double)partialTicks, (double)owner.f_19855_, (double)owner.m_20186_()) + (double)owner.m_20192_() * 0.8;
        double ownerZ = Mth.m_14139_((double)partialTicks, (double)owner.f_19856_, (double)owner.m_20189_());
        double hookX = Mth.m_14139_((double)partialTicks, (double)hook.f_19854_, (double)hook.m_20185_());
        double hookY = Mth.m_14139_((double)partialTicks, (double)hook.f_19855_, (double)hook.m_20186_()) + 0.25;
        double hookZ = Mth.m_14139_((double)partialTicks, (double)hook.f_19856_, (double)hook.m_20189_());
        float deltaX = (float)(ownerX - hookX);
        float deltaY = (float)(ownerY - hookY);
        float deltaZ = (float)(ownerZ - hookZ);
        VertexConsumer lineConsumer = buffer.m_6299_(RenderType.m_173247_());
        PoseStack.Pose pose = poseStack.m_85850_();
        int segments = 16;
        for (int i = 0; i <= segments; ++i) {
            TraumaHookRenderer.renderLineSegment(deltaX, deltaY, deltaZ, lineConsumer, pose, TraumaHookRenderer.fraction(i, segments), TraumaHookRenderer.fraction(i + 1, segments));
        }
        poseStack.m_85849_();
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private static void renderLineSegment(float deltaX, float deltaY, float deltaZ, VertexConsumer consumer, PoseStack.Pose pose, float start, float end) {
        float x = deltaX * start;
        float y = deltaY * (start * start + start) * 0.5f + 0.25f;
        float z = deltaZ * start;
        float nextX = deltaX * end - x;
        float nextY = deltaY * (end * end + end) * 0.5f + 0.25f - y;
        float nextZ = deltaZ * end - z;
        float length = Mth.m_14116_((float)(nextX * nextX + nextY * nextY + nextZ * nextZ));
        consumer.m_252986_(pose.m_252922_(), x, y, z).m_6122_(32, 32, 32, 255).m_252939_(pose.m_252943_(), nextX /= length, nextY /= length, nextZ /= length).m_5752_();
    }

    private static void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, int light, float x, int y, int u, int v) {
        consumer.m_252986_(pose, x - 0.5f, (float)y - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(TraumaHookEntity entity) {
        return TEXTURE;
    }
}

