/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.CogMinionEntity;

public class CogMinionModel<T extends Entity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart main;
    final ModelPart head;
    private final ModelPart body;
    private final ModelPart tread;
    private final ModelPart cog;
    private final ModelPart hand;
    private final PartPose headDefault;
    private final PartPose bodyDefault;
    private final PartPose treadDefault;
    private final PartPose cogDefault;
    private final PartPose handDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 12.0f;

    public CogMinionModel(ModelPart root) {
        this.main = root;
        this.body = root.m_171324_("body");
        this.tread = root.m_171324_("tread");
        this.head = root.m_171324_("head");
        this.cog = root.m_171324_("cog");
        this.hand = root.m_171324_("hand");
        this.headDefault = this.head.m_171308_();
        this.bodyDefault = this.body.m_171308_();
        this.treadDefault = this.tread.m_171308_();
        this.cogDefault = this.cog.m_171308_();
        this.handDefault = this.hand.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.5625f, (float)3.25f));
        PartDefinition hand_r1 = body.m_171599_("hand_r1", CubeListBuilder.m_171558_().m_171514_(67, 65).m_171488_(-0.75f, -3.25f, -2.5f, 7.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171488_(-5.5f, -7.75f, -5.0f, 5.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(32, 54).m_171488_(-3.5f, -9.75f, -3.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(62, 22).m_171488_(-5.5f, 1.25f, -4.0f, 5.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(8, 35).m_171488_(0.5f, 10.25f, -3.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 31).m_171488_(-1.5f, 7.25f, -5.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(-0.5f, 4.25f, -4.0f, 7.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(60, 39).m_171488_(-0.5f, -2.75f, -3.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(70, 65).m_171488_(0.5f, -8.75f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 57).m_171488_(-0.5f, -7.75f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.1875f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition tread = partdefinition.m_171599_("tread", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.0455f, (float)15.2273f, (float)0.6364f));
        PartDefinition tread_r1 = tread.m_171599_("tread_r1", CubeListBuilder.m_171558_().m_171514_(62, 11).m_171488_(-0.5f, -3.5f, -5.5f, 2.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(39, 4).m_171488_(-3.5f, -3.5f, -6.5f, 3.0f, 1.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(25, 40).m_171488_(1.5f, -3.5f, -6.5f, 3.0f, 1.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171488_(1.5f, -2.5f, -6.5f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(1, 18).m_171488_(-4.5f, -2.5f, -5.5f, 10.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(47, 43).m_171488_(7.0f, 1.5f, -5.5f, 1.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(2, 1).m_171488_(-6.0f, 0.5f, -5.5f, 13.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(44, 39).m_171488_(-3.5f, -2.5f, 5.5f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 0).m_171488_(1.5f, -2.5f, 5.5f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(62, 22).m_171488_(-3.5f, -2.5f, -6.5f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0455f, (float)3.2727f, (float)0.3636f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition tread_r2 = tread.m_171599_("tread_r2", CubeListBuilder.m_171558_().m_171514_(19, 55).m_171488_(-8.0f, 1.5f, -5.5f, 1.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0455f, (float)3.2727f, (float)-0.6364f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)1.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(36, 23).m_171488_(-4.5f, -4.0f, -4.0f, 9.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cog = partdefinition.m_171599_("cog", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.75f, (float)9.7525f));
        PartDefinition cog_r1 = cog.m_171599_("cog_r1", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-1.2625f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 17).m_171488_(-0.7375f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.1475f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cog_r2 = cog.m_171599_("cog_r2", CubeListBuilder.m_171558_().m_171514_(32, 17).m_171488_(-0.7625f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.1475f, (float)0.0f, (float)1.5708f, (float)0.7854f));
        PartDefinition cog_r3 = cog.m_171599_("cog_r3", CubeListBuilder.m_171558_().m_171514_(28, 31).m_171488_(-0.7625f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.1475f, (float)0.0f, (float)1.5708f, (float)-0.7854f));
        PartDefinition cog_r4 = cog.m_171599_("cog_r4", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-0.7375f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.1475f, (float)0.0f, (float)1.5708f, (float)1.5708f));
        PartDefinition hand = partdefinition.m_171599_("hand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.25f, (float)-2.5f));
        PartDefinition hand_r2 = hand.m_171599_("hand_r2", CubeListBuilder.m_171558_().m_171514_(62, 57).m_171488_(-7.75f, -1.0f, -2.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 63).m_171488_(-1.75f, -2.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(3.25f, -2.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(40, 0).m_171488_(3.25f, -2.0f, 0.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.25f, (float)-1.75f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.m_171322_(this.headDefault);
        this.body.m_171322_(this.bodyDefault);
        this.tread.m_171322_(this.treadDefault);
        this.cog.m_171322_(this.cogDefault);
        this.hand.m_171322_(this.handDefault);
        if (entity instanceof CogMinionEntity) {
            CogMinionEntity cogMinion = (CogMinionEntity)((Object)entity);
            this.cog.f_104205_ = ageInTicks * 0.15f % ((float)Math.PI * 2);
            if (limbSwingAmount > 0.01f) {
                float treadBob = Mth.m_14154_((float)Mth.m_14031_((float)(limbSwing * 0.6662f))) * limbSwingAmount * 0.5f;
                this.tread.f_104201_ += treadBob;
            }
            if (cogMinion.isAttacking() && cogMinion.getAttackTimeout() > 0) {
                this.animateAttackSmooth(cogMinion.getAttackTimeout(), ageInTicks);
            } else {
                this.attackStartTime = -1.0f;
                this.lastAttackTimeout = 0;
            }
            float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-45.0f, (float)45.0f);
            float clampedPitch = Mth.m_14036_((float)headPitch, (float)-20.0f, (float)20.0f);
            this.head.f_104204_ = clampedYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = clampedPitch * ((float)Math.PI / 180);
        }
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        if (attackTimeout <= 0) {
            this.hand.f_104202_ = 0.0f;
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTimeout > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTimeout;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 12.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.hand.f_104202_ = -swingCurve * 7.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tread.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.cog.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.hand.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.main;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.hand.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.05f, 0.15f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
    }
}

