/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import top.ribs.scguns.client.ClientHandler;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.debug.IDebugWidget;
import top.ribs.scguns.debug.IEditorMenu;
import top.ribs.scguns.debug.client.screen.widget.DebugButton;
import top.ribs.scguns.debug.client.screen.widget.DebugToggle;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.ScopeItem;
import top.ribs.scguns.item.attachment.impl.Scope;

@Mod.EventBusSubscriber(modid="scguns")
public class Debug {
    private static final Map<Item, Gun> GUNS = new HashMap<Item, Gun>();
    private static final Map<Item, Scope> SCOPES = new HashMap<Item, Scope>();
    private static boolean forceAim = false;

    @SubscribeEvent
    public static void onServerStarting(ServerStartedEvent event) {
        event.getServer().execute(() -> {
            GUNS.clear();
            SCOPES.clear();
        });
    }

    public static Gun getGun(GunItem item) {
        return GUNS.computeIfAbsent(item, item1 -> item.getGun().copy());
    }

    public static Scope getScope(ScopeItem item) {
        return SCOPES.computeIfAbsent(item, item1 -> item.getProperties().copy());
    }

    public static boolean isForceAim() {
        return forceAim;
    }

    public static void setForceAim(boolean forceAim) {
        Debug.forceAim = forceAim;
    }

    public static class Settings
    implements IEditorMenu {
        @Override
        public Component getEditorLabel() {
            return Component.m_237113_((String)"Settings");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> widgets.add(Pair.of((Object)Component.m_237113_((String)"Force Aim"), () -> new DebugToggle(forceAim, value -> {
                forceAim = value;
            }))));
        }
    }

    public static class Menu
    implements IEditorMenu {
        @Override
        public Component getEditorLabel() {
            return Component.m_237113_((String)"Editor Menu");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
                Item patt2526$temp = heldItem.m_41720_();
                if (patt2526$temp instanceof GunItem) {
                    GunItem gunItem = (GunItem)patt2526$temp;
                    widgets.add(Pair.of((Object)Component.m_237115_((String)gunItem.m_5524_()), () -> new DebugButton((Component)Component.m_237113_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getGun(gunItem))))));
                }
                widgets.add(Pair.of((Object)Component.m_237113_((String)"Settings"), () -> new DebugButton((Component)Component.m_237113_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(new Settings())))));
            });
        }
    }
}

