/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.network;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.screen.AttachmentContainer;
import top.ribs.scguns.common.BeamWeaponHandler;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.GunEffectsHandler;
import top.ribs.scguns.common.ProjectileManager;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.common.ShootTracker;
import top.ribs.scguns.common.SpreadTracker;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.event.GunEventBus;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.interfaces.IProjectileFactory;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.ammo_boxes.CreativeAmmoBoxItem;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageShoot;
import top.ribs.scguns.network.message.S2CMessageBulletTrail;
import top.ribs.scguns.network.message.S2CMessageGunSound;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;
import top.theillusivec4.curios.api.CuriosApi;

public class ServerPlayHandler {
    public static void handleShoot(C2SMessageShoot message, ServerPlayer player) {
        if (player.m_5833_() || player.m_21211_().m_41720_() == Items.f_42740_) {
            return;
        }
        Level world = player.m_9236_();
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem item2 = (GunItem)item;
        if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
            return;
        }
        Gun modifiedGun = item2.getModifiedGun(heldItem);
        if (modifiedGun == null) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((Player)player, heldItem))) {
            return;
        }
        player.m_146922_(Mth.m_14177_((float)message.getRotationYaw()));
        player.m_146926_(Mth.m_14036_((float)message.getRotationPitch(), (float)-90.0f, (float)90.0f));
        ShootTracker tracker = ShootTracker.getShootTracker((Player)player);
        if (tracker.hasCooldown(item2) && tracker.getRemaining(item2) > (long)((Integer)Config.SERVER.cooldownThreshold.get()).intValue()) {
            return;
        }
        tracker.putCooldown(heldItem, item2, modifiedGun);
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
            ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
        }
        if (!modifiedGun.getProjectile().isAlwaysSpread() && modifiedGun.getProjectile().getSpread() > 0.0f) {
            SpreadTracker.get((Player)player).update((Player)player, item2);
        }
        if (FireMode.BEAM.equals(modifiedGun.getGeneral().getFireMode()) || FireMode.SEMI_BEAM.equals(modifiedGun.getGeneral().getFireMode())) {
            BeamWeaponHandler.handleBeamWeapon(player, heldItem, modifiedGun);
        } else if (modifiedGun.getProjectile(heldItem).firesArrows()) {
            int count = modifiedGun.getProjectile().getProjectileAmount();
            for (int i = 0; i < count; ++i) {
                Arrow arrow = ServerPlayHandler.getArrow(player, world, heldItem, modifiedGun);
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                world.m_7967_((Entity)arrow);
            }
        } else {
            ServerPlayHandler.fireProjectiles(world, player, heldItem, item2, modifiedGun);
        }
        if (!FireMode.BEAM.equals(modifiedGun.getGeneral().getFireMode()) && !FireMode.SEMI_BEAM.equals(modifiedGun.getGeneral().getFireMode())) {
            ServerPlayHandler.consumeAmmo(player, heldItem);
        }
        ServerPlayHandler.handleCasingEjection(player, heldItem, modifiedGun, world);
        ServerPlayHandler.handleWeaponDamage(player, heldItem, world);
        ResourceLocation fireSound = ServerPlayHandler.getFireSound(heldItem, modifiedGun);
        if (fireSound != null) {
            ServerPlayHandler.playFireSound(player, world, heldItem, modifiedGun, fireSound);
        }
        GunEffectsHandler.handleGunEffects(player, heldItem, modifiedGun);
        MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((Player)player, heldItem));
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item2));
    }

    private static void consumeAmmo(ServerPlayer player, ItemStack heldItem) {
        int level;
        CompoundTag tag;
        if (!(player.m_7500_() || (tag = heldItem.m_41784_()).m_128471_("IgnoreAmmo") || (level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.m_9236_().f_46441_.m_188503_(4 - Mth.m_14045_((int)level, (int)1, (int)2)) == 0)) {
            int currentAmmo = tag.m_128451_("AmmoCount");
            tag.m_128405_("AmmoCount", Math.max(0, currentAmmo - 1));
        }
    }

    private static void handleCasingEjection(ServerPlayer player, ItemStack heldItem, Gun modifiedGun, Level world) {
        if (((Boolean)Config.COMMON.gameplay.spawnCasings.get()).booleanValue() && modifiedGun.getProjectile((ItemStack)heldItem).casingType != null && !player.m_150110_().f_35937_ && !modifiedGun.getProjectile(heldItem).ejectDuringReload()) {
            ItemStack casingStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile((ItemStack)heldItem).casingType)));
            double baseChance = 0.4;
            int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.SHELL_CATCHER.get()), (ItemStack)heldItem);
            double finalChance = baseChance + (double)enchantmentLevel * 0.15;
            if (Math.random() < finalChance) {
                if (enchantmentLevel > 0) {
                    if (!GunEventBus.addCasingDirectly((Player)player, casingStack)) {
                        GunEventBus.spawnCasingInWorld(world, (Player)player, casingStack);
                    }
                } else if (!GunEventBus.addCasingToPouch((Player)player, casingStack)) {
                    GunEventBus.spawnCasingInWorld(world, (Player)player, casingStack);
                }
            }
        }
    }

    private static void handleWeaponDamage(ServerPlayer player, ItemStack heldItem, Level world) {
        if (!player.m_7500_()) {
            if (((Boolean)Config.COMMON.gameplay.enableGunDamage.get()).booleanValue()) {
                GunEventBus.damageGun(heldItem, world, (Player)player);
            }
            if (((Boolean)Config.COMMON.gameplay.enableAttachmentDamage.get()).booleanValue()) {
                GunEventBus.damageAttachments(heldItem, world, (Player)player);
            }
        }
    }

    @NotNull
    private static Arrow getArrow(ServerPlayer player, Level world, ItemStack heldItem, Gun modifiedGun) {
        Arrow arrow = new Arrow(world, (LivingEntity)player);
        float speed = (float)modifiedGun.getProjectile(heldItem).getSpeed() * 0.35f;
        float pitch = player.m_146909_();
        float yaw = player.m_146908_();
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        Vec3 motion = new Vec3((double)f, (double)f1, (double)f2);
        Vec3 spawnPos = player.m_146892_().m_82520_(motion.f_82479_ * 0.5, -0.1, motion.f_82481_ * 0.5);
        arrow.m_146884_(spawnPos);
        arrow.m_20334_(motion.f_82479_ * (double)speed, motion.f_82480_ * (double)speed, motion.f_82481_ * (double)speed);
        float horizontalDistance = Mth.m_14116_((float)((float)(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)));
        arrow.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.29577951308232));
        arrow.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)horizontalDistance) * 57.29577951308232));
        arrow.f_19859_ = arrow.m_146908_();
        arrow.f_19860_ = arrow.m_146909_();
        arrow.m_36781_((double)modifiedGun.getProjectile(heldItem).getDamage() * 0.15);
        return arrow;
    }

    private static void fireProjectiles(Level world, ServerPlayer player, ItemStack heldItem, GunItem item, Gun modifiedGun) {
        int count = modifiedGun.getProjectile().getProjectileAmount();
        Gun.Projectile projectileProps = modifiedGun.getProjectile(heldItem);
        ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
        for (int i = 0; i < count; ++i) {
            IProjectileFactory factory = ProjectileManager.getInstance().getFactory(ForgeRegistries.ITEMS.getKey((Object)projectileProps.getItem()));
            ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item, modifiedGun);
            projectileEntity.setWeapon(heldItem);
            projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
            world.m_7967_((Entity)projectileEntity);
            spawnedProjectiles[i] = projectileEntity;
            projectileEntity.m_8119_();
        }
        if (!projectileProps.shouldHideProjectile()) {
            ServerPlayHandler.sendProjectileTrail(player, spawnedProjectiles, projectileProps, false);
        }
    }

    private static void sendProjectileTrail(ServerPlayer player, ProjectileEntity[] projectiles, Gun.Projectile projectileProps, boolean b) {
        if (projectileProps.shouldHideTrail()) {
            return;
        }
        double spawnX = player.m_20185_();
        double spawnY = player.m_20186_() + 1.0;
        double spawnZ = player.m_20189_();
        double radius = (Double)Config.COMMON.network.projectileTrackingRange.get();
        ParticleOptions data = GunEnchantmentHelper.getParticle(player.m_21205_());
        S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(projectiles, projectileProps, player.m_19879_(), data, true);
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)spawnX, (double)spawnY, (double)spawnZ, (double)radius), (IMessage)messageBulletTrail);
    }

    private static void playFireSound(ServerPlayer player, Level world, ItemStack heldItem, Gun modifiedGun, ResourceLocation fireSound) {
        double posX = player.m_20185_();
        double posY = player.m_20186_() + (double)player.m_20192_();
        double posZ = player.m_20189_();
        float volume = GunModifierHelper.getFireSoundVolume(heldItem);
        float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
        double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
        boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
        S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), muzzle, false);
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
    }

    public static void handleStopBeam(ServerPlayer player) {
        BeamWeaponHandler.stopBeam(player);
    }

    public static EntityHitResult rayTraceEntities(Level world, Entity shooter, Vec3 startVec, Vec3 endVec) {
        endVec.m_82546_(startVec).m_82541_();
        double maxDistance = startVec.m_82554_(endVec);
        AABB searchArea = new AABB(startVec, endVec).m_82400_(1.0);
        Entity closestEntity = null;
        Vec3 hitVec = null;
        double minDistance = maxDistance;
        List entities = world.m_6249_(shooter, searchArea, entity -> !entity.m_5833_() && entity.m_6087_() && entity.m_6084_());
        for (Entity entity2 : entities) {
            double distance;
            AABB entityBB = entity2.m_20191_().m_82400_(0.3);
            Optional optionalHit = entityBB.m_82371_(startVec, endVec);
            if (!optionalHit.isPresent() || !((distance = startVec.m_82554_((Vec3)optionalHit.get())) < minDistance)) continue;
            minDistance = distance;
            closestEntity = entity2;
            hitVec = (Vec3)optionalHit.get();
        }
        if (closestEntity != null) {
            return new EntityHitResult(closestEntity, hitVec);
        }
        return null;
    }

    public static void handlePreFireSound(ServerPlayer player) {
        Level world = player.m_9236_();
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            Gun modifiedGun;
            ResourceLocation fireSound;
            GunItem item2 = (GunItem)item;
            if ((Gun.hasAmmo(heldItem) || player.m_7500_()) && (fireSound = ServerPlayHandler.getPreFireSound(heldItem, modifiedGun = item2.getModifiedGun(heldItem))) != null) {
                double posX = player.m_20185_();
                double posY = player.m_20186_() + (double)player.m_20192_();
                double posZ = player.m_20189_();
                float volume = GunModifierHelper.getFireSoundVolume(heldItem);
                float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
                double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), false, false);
                PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
            }
        }
    }

    private static ResourceLocation getFireSound(ItemStack stack, Gun modifiedGun) {
        ResourceLocation fireSound = null;
        if (GunModifierHelper.isSilencedFire(stack)) {
            fireSound = modifiedGun.getSounds().getSilencedFire();
        } else if (stack.m_41793_()) {
            fireSound = modifiedGun.getSounds().getEnchantedFire();
        }
        if (fireSound != null) {
            return fireSound;
        }
        return modifiedGun.getSounds().getFire();
    }

    private static ResourceLocation getPreFireSound(ItemStack stack, Gun modifiedGun) {
        return modifiedGun.getSounds().getPreFire();
    }

    public static void handleUnload(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun gun = gunItem.getModifiedGun(stack);
            CompoundTag tag = stack.m_41783_();
            if (player.m_150109_().f_35974_.stream().anyMatch(i -> i.m_41720_() instanceof CreativeAmmoBoxItem) || ServerPlayHandler.hasCreativeAmmoBoxInCurios(player)) {
                return;
            }
            if (gun.getReloads().getReloadType() != ReloadType.SINGLE_ITEM && tag != null && tag.m_128425_("AmmoCount", 3)) {
                int count = tag.m_128451_("AmmoCount");
                tag.m_128405_("AmmoCount", 0);
                ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)gun.getCurrentAmmoItem(stack));
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item2 == null) {
                    return;
                }
                int maxStackSize = item2.m_41459_();
                int stacks = count / maxStackSize;
                for (int i2 = 0; i2 < stacks; ++i2) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, maxStackSize));
                }
                int remaining = count % maxStackSize;
                if (remaining > 0) {
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, remaining));
                }
            }
        }
    }

    public static boolean hasCreativeAmmoBoxInCurios(ServerPlayer player) {
        AtomicBoolean found = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                if (!(curios.getStackInSlot(i).m_41720_() instanceof CreativeAmmoBoxItem)) continue;
                found.set(true);
                return;
            }
        });
        return found.get();
    }

    public static void handleExtraAmmo(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            int modifiedCapacity;
            int currentAmmo;
            GunItem gunItem = (GunItem)item;
            boolean hasCreativeBox = player.m_150109_().f_35974_.stream().anyMatch(i -> i.m_41720_() instanceof CreativeAmmoBoxItem) || ServerPlayHandler.hasCreativeAmmoBoxInCurios(player);
            Gun gun = gunItem.getModifiedGun(stack);
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_("AmmoCount", 3) && (currentAmmo = tag.m_128451_("AmmoCount")) > (modifiedCapacity = GunModifierHelper.getModifiedAmmoCapacity(stack, gun))) {
                ResourceLocation id;
                Item item2;
                tag.m_128405_("AmmoCount", modifiedCapacity);
                if (!hasCreativeBox && (item2 = (Item)ForgeRegistries.ITEMS.getValue(id = ForgeRegistries.ITEMS.getKey((Object)gun.getCurrentAmmoItem(stack)))) != null) {
                    int residue = currentAmmo - modifiedCapacity;
                    ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item2, residue));
                }
            }
        }
    }

    private static void spawnAmmo(ServerPlayer player, ItemStack stack) {
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41777_()));
        }
    }

    public static void handleAttachments(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (Component)Component.m_237115_((String)"container.scguns.attachments")));
        } else if (heldItem.m_41720_() instanceof ExoSuitItem) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new ExoSuitItem.ExoSuitMenuProvider(InteractionHand.MAIN_HAND), buf -> buf.m_130068_((Enum)InteractionHand.MAIN_HAND));
        }
    }

    public static class RatKingAndQueenModel {

        public static class GunFireEventRatHandler {
            private static int shotCount = 0;

            public static int getShotCount() {
                return shotCount;
            }

            public static void incrementShotCount() {
                ++shotCount;
            }

            public static boolean shouldUseAlternateAnimation() {
                return shotCount % 2 == 1;
            }
        }
    }
}

