/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.annotation.Optional;

public class Vent
implements INBTSerializable<CompoundTag> {
    protected Activation activation = new Activation();
    protected Power power = new Power();
    protected Production production = new Production();
    protected Placement placement = new Placement();
    protected Particles particles = new Particles();

    public Activation getActivation() {
        return this.activation;
    }

    public Power getPower() {
        return this.power;
    }

    public Production getProduction() {
        return this.production;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public Particles getParticles() {
        return this.particles;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Activation", (Tag)this.activation.serializeNBT());
        tag.m_128365_("Power", (Tag)this.power.serializeNBT());
        tag.m_128365_("Production", (Tag)this.production.serializeNBT());
        tag.m_128365_("Placement", (Tag)this.placement.serializeNBT());
        tag.m_128365_("Particles", (Tag)this.particles.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Activation", 10)) {
            this.activation.deserializeNBT(tag.m_128469_("Activation"));
        }
        if (tag.m_128425_("Power", 10)) {
            this.power.deserializeNBT(tag.m_128469_("Power"));
        }
        if (tag.m_128425_("Production", 10)) {
            this.production.deserializeNBT(tag.m_128469_("Production"));
        }
        if (tag.m_128425_("Placement", 10)) {
            this.placement.deserializeNBT(tag.m_128469_("Placement"));
        }
        if (tag.m_128425_("Particles", 10)) {
            this.particles.deserializeNBT(tag.m_128469_("Particles"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.add("activation", (JsonElement)this.activation.toJsonObject());
        object.add("power", (JsonElement)this.power.toJsonObject());
        object.add("production", (JsonElement)this.production.toJsonObject());
        object.add("placement", (JsonElement)this.placement.toJsonObject());
        object.add("particles", (JsonElement)this.particles.toJsonObject());
        return object;
    }

    public static Vent create(CompoundTag tag) {
        Vent vent = new Vent();
        vent.deserializeNBT(tag);
        return vent;
    }

    public Vent copy() {
        Vent vent = new Vent();
        vent.activation = this.activation.copy();
        vent.power = this.power.copy();
        vent.production = this.production.copy();
        vent.placement = this.placement.copy();
        vent.particles = this.particles.copy();
        return vent;
    }

    public static class Activation
    implements INBTSerializable<CompoundTag> {
        private ResourceLocation baseBlock = new ResourceLocation("minecraft:magma_block");
        private boolean requiresWaterlogged = false;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("BaseBlock", this.baseBlock.toString());
            tag.m_128379_("RequiresWaterlogged", this.requiresWaterlogged);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("BaseBlock", 8)) {
                this.baseBlock = new ResourceLocation(tag.m_128461_("BaseBlock"));
            }
            if (tag.m_128425_("RequiresWaterlogged", 99)) {
                this.requiresWaterlogged = tag.m_128471_("RequiresWaterlogged");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (!this.baseBlock.equals((Object)new ResourceLocation("minecraft:magma_block"))) {
                object.addProperty("baseBlock", this.baseBlock.toString());
            }
            if (this.requiresWaterlogged) {
                object.addProperty("requiresWaterlogged", Boolean.valueOf(true));
            }
            return object;
        }

        public Activation copy() {
            Activation activation = new Activation();
            activation.baseBlock = this.baseBlock;
            activation.requiresWaterlogged = this.requiresWaterlogged;
            return activation;
        }

        public ResourceLocation getBaseBlock() {
            return this.baseBlock;
        }

        public boolean requiresWaterlogged() {
            return this.requiresWaterlogged;
        }

        public void setBaseBlock(ResourceLocation baseBlock) {
            this.baseBlock = baseBlock;
        }

        public void setRequiresWaterlogged(boolean requiresWaterlogged) {
            this.requiresWaterlogged = requiresWaterlogged;
        }
    }

    public static class Power
    implements INBTSerializable<CompoundTag> {
        private int maxPower = 5;
        private int baseTickInterval = 100;
        private int tickWiggleRoom = 60;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("MaxPower", this.maxPower);
            tag.m_128405_("BaseTickInterval", this.baseTickInterval);
            tag.m_128405_("TickWiggleRoom", this.tickWiggleRoom);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("MaxPower", 99)) {
                this.maxPower = tag.m_128451_("MaxPower");
            }
            if (tag.m_128425_("BaseTickInterval", 99)) {
                this.baseTickInterval = tag.m_128451_("BaseTickInterval");
            }
            if (tag.m_128425_("TickWiggleRoom", 99)) {
                this.tickWiggleRoom = tag.m_128451_("TickWiggleRoom");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.maxPower != 5) {
                object.addProperty("maxPower", (Number)this.maxPower);
            }
            if (this.baseTickInterval != 100) {
                object.addProperty("baseTickInterval", (Number)this.baseTickInterval);
            }
            if (this.tickWiggleRoom != 60) {
                object.addProperty("tickWiggleRoom", (Number)this.tickWiggleRoom);
            }
            return object;
        }

        public Power copy() {
            Power power = new Power();
            power.maxPower = this.maxPower;
            power.baseTickInterval = this.baseTickInterval;
            power.tickWiggleRoom = this.tickWiggleRoom;
            return power;
        }

        public int getMaxPower() {
            return this.maxPower;
        }

        public int getBaseTickInterval() {
            return this.baseTickInterval;
        }

        public int getTickWiggleRoom() {
            return this.tickWiggleRoom;
        }

        public void setMaxPower(int maxPower) {
            this.maxPower = maxPower;
        }

        public void setBaseTickInterval(int baseTickInterval) {
            this.baseTickInterval = baseTickInterval;
        }

        public void setTickWiggleRoom(int tickWiggleRoom) {
            this.tickWiggleRoom = tickWiggleRoom;
        }
    }

    public static class Production
    implements INBTSerializable<CompoundTag> {
        private List<OutputItem> outputs = new ArrayList<OutputItem>();
        private float productionChance = 0.4f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            CompoundTag outputsTag = new CompoundTag();
            for (int i = 0; i < this.outputs.size(); ++i) {
                outputsTag.m_128365_("Output" + i, (Tag)this.outputs.get(i).serializeNBT());
            }
            tag.m_128365_("Outputs", (Tag)outputsTag);
            tag.m_128350_("ProductionChance", this.productionChance);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Outputs", 10)) {
                CompoundTag outputsTag = tag.m_128469_("Outputs");
                this.outputs.clear();
                int i = 0;
                while (outputsTag.m_128441_("Output" + i)) {
                    OutputItem output = new OutputItem();
                    output.deserializeNBT(outputsTag.m_128469_("Output" + i));
                    this.outputs.add(output);
                    ++i;
                }
            }
            if (tag.m_128425_("ProductionChance", 99)) {
                this.productionChance = tag.m_128457_("ProductionChance");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (!this.outputs.isEmpty()) {
                JsonArray outputsArray = new JsonArray();
                for (OutputItem output : this.outputs) {
                    outputsArray.add((JsonElement)output.toJsonObject());
                }
                object.add("outputs", (JsonElement)outputsArray);
            }
            if (this.productionChance != 0.4f) {
                object.addProperty("productionChance", (Number)Float.valueOf(this.productionChance));
            }
            return object;
        }

        public Production copy() {
            Production production = new Production();
            for (OutputItem output : this.outputs) {
                production.outputs.add(output.copy());
            }
            production.productionChance = this.productionChance;
            return production;
        }

        public List<OutputItem> getOutputs() {
            return this.outputs;
        }

        public float getProductionChance() {
            return this.productionChance;
        }

        public void clearOutputs() {
            this.outputs.clear();
        }

        public void addOutput(OutputItem output) {
            this.outputs.add(output);
        }

        public void setProductionChance(float productionChance) {
            this.productionChance = productionChance;
        }

        public static class OutputItem
        implements INBTSerializable<CompoundTag> {
            private ResourceLocation item;
            private int weight = 1;

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Item", this.item.toString());
                tag.m_128405_("Weight", this.weight);
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                if (tag.m_128425_("Item", 8)) {
                    this.item = new ResourceLocation(tag.m_128461_("Item"));
                }
                if (tag.m_128425_("Weight", 99)) {
                    this.weight = tag.m_128451_("Weight");
                }
            }

            public JsonObject toJsonObject() {
                JsonObject object = new JsonObject();
                object.addProperty("item", this.item.toString());
                if (this.weight != 1) {
                    object.addProperty("weight", (Number)this.weight);
                }
                return object;
            }

            public OutputItem copy() {
                OutputItem output = new OutputItem();
                output.item = this.item;
                output.weight = this.weight;
                return output;
            }

            @Nullable
            public Item getItem() {
                return (Item)ForgeRegistries.ITEMS.getValue(this.item);
            }

            public int getWeight() {
                return this.weight;
            }

            public void setItem(ResourceLocation item) {
                this.item = item;
            }

            public void setWeight(int weight) {
                this.weight = weight;
            }
        }
    }

    public static class Placement
    implements INBTSerializable<CompoundTag> {
        private boolean enabled = false;
        @Optional
        private ResourceLocation blockToPlace;
        private int radius = 8;
        private float placementChance = 0.35f;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Enabled", this.enabled);
            if (this.blockToPlace != null) {
                tag.m_128359_("BlockToPlace", this.blockToPlace.toString());
            }
            tag.m_128405_("Radius", this.radius);
            tag.m_128350_("PlacementChance", this.placementChance);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Enabled", 99)) {
                this.enabled = tag.m_128471_("Enabled");
            }
            if (tag.m_128425_("BlockToPlace", 8)) {
                this.blockToPlace = new ResourceLocation(tag.m_128461_("BlockToPlace"));
            }
            if (tag.m_128425_("Radius", 99)) {
                this.radius = tag.m_128451_("Radius");
            }
            if (tag.m_128425_("PlacementChance", 99)) {
                this.placementChance = tag.m_128457_("PlacementChance");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.enabled) {
                object.addProperty("enabled", Boolean.valueOf(true));
            }
            if (this.blockToPlace != null) {
                object.addProperty("blockToPlace", this.blockToPlace.toString());
            }
            if (this.radius != 8) {
                object.addProperty("radius", (Number)this.radius);
            }
            if (this.placementChance != 0.35f) {
                object.addProperty("placementChance", (Number)Float.valueOf(this.placementChance));
            }
            return object;
        }

        public Placement copy() {
            Placement placement = new Placement();
            placement.enabled = this.enabled;
            placement.blockToPlace = this.blockToPlace;
            placement.radius = this.radius;
            placement.placementChance = this.placementChance;
            return placement;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Nullable
        public ResourceLocation getBlockToPlace() {
            return this.blockToPlace;
        }

        public int getRadius() {
            return this.radius;
        }

        public float getPlacementChance() {
            return this.placementChance;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setBlockToPlace(ResourceLocation blockToPlace) {
            this.blockToPlace = blockToPlace;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public void setPlacementChance(float placementChance) {
            this.placementChance = placementChance;
        }
    }

    public static class Particles
    implements INBTSerializable<CompoundTag> {
        private boolean showActive = true;
        @Optional
        private ResourceLocation activeSound;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("ShowActive", this.showActive);
            if (this.activeSound != null) {
                tag.m_128359_("ActiveSound", this.activeSound.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("ShowActive", 99)) {
                this.showActive = tag.m_128471_("ShowActive");
            }
            if (tag.m_128425_("ActiveSound", 8)) {
                this.activeSound = new ResourceLocation(tag.m_128461_("ActiveSound"));
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (!this.showActive) {
                object.addProperty("showActive", Boolean.valueOf(false));
            }
            if (this.activeSound != null) {
                object.addProperty("activeSound", this.activeSound.toString());
            }
            return object;
        }

        public Particles copy() {
            Particles particles = new Particles();
            particles.showActive = this.showActive;
            particles.activeSound = this.activeSound;
            return particles;
        }

        public boolean showActive() {
            return this.showActive;
        }

        @Nullable
        public ResourceLocation getActiveSound() {
            return this.activeSound;
        }

        public void setShowActive(boolean showActive) {
            this.showActive = showActive;
        }

        public void setActiveSound(ResourceLocation activeSound) {
            this.activeSound = activeSound;
        }
    }
}

