/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import top.ribs.scguns.client.GunRenderType;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.client.util.PropertyHelper;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.util.GunModifierHelper;

public class EntityMuzzleFlashHandler {
    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        ItemStack heldItem = entity.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (!GunRenderingHandler.entityIdForMuzzleFlash.contains(entity.m_19879_())) {
            return;
        }
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        Gun.Display.Flash flash = modifiedGun.getDisplay().getFlash();
        if (flash == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        poseStack.m_85836_();
        float randomValue = GunRenderingHandler.entityIdToRandomValue.getOrDefault(entity.m_19879_(), Float.valueOf(0.0f)).floatValue();
        ResourceLocation flashTexture = new ResourceLocation("scguns", "textures/effect/" + flash.getTextureLocation() + ".png");
        this.renderEntityMuzzleFlash(heldItem, modifiedGun, randomValue, poseStack, buffer, event.getPackedLight(), flashTexture, entity);
        poseStack.m_85849_();
    }

    private void renderEntityMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, PoseStack poseStack, MultiBufferSource buffer, int packedLight, ResourceLocation flashTexture, LivingEntity entity) {
        if (!PropertyHelper.hasMuzzleFlash(weapon, modifiedGun)) {
            return;
        }
        Gun.Display.Flash flash = modifiedGun.getDisplay().getFlash();
        if (flash == null) {
            return;
        }
        poseStack.m_85836_();
        double eyeHeight = entity.m_20192_();
        float entityScale = entity.m_20206_() / 1.8f;
        poseStack.m_85837_(0.0, eyeHeight - 0.2, 0.0);
        float bodyYaw = entity.f_20883_;
        float headPitch = entity.m_146909_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-bodyYaw + 180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-headPitch));
        float baseForwardOffset = -1.0f * entityScale;
        float baseSideOffset = 0.8f * entityScale;
        float baseVerticalOffset = -0.1f * entityScale;
        poseStack.m_252880_(baseSideOffset, baseVerticalOffset, baseForwardOffset);
        Vec3 weaponOrigin = PropertyHelper.getModelOrigin(weapon, PropertyHelper.GUN_DEFAULT_ORIGIN);
        Vec3 flashPosition = PropertyHelper.getMuzzleFlashPosition(weapon, modifiedGun).m_82546_(weaponOrigin);
        poseStack.m_85837_(flashPosition.f_82479_ * 0.0625, flashPosition.f_82480_ * 0.0625, flashPosition.f_82481_ * 0.0625);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(360.0f * random));
        Vec3 flashScale = PropertyHelper.getMuzzleFlashScale(weapon, modifiedGun);
        float scaleX = (float)flashScale.f_82479_;
        float scaleY = (float)flashScale.f_82480_;
        poseStack.m_85841_(scaleX, scaleY, 1.0f);
        float scaleModifier = (float)GunModifierHelper.getMuzzleFlashScale(weapon, 1.0);
        poseStack.m_85841_(scaleModifier, scaleModifier, 1.0f);
        poseStack.m_85837_(-0.5, -0.5, 0.0);
        float minU = weapon.m_41793_() ? 0.5f : 0.0f;
        float maxU = weapon.m_41793_() ? 1.0f : 0.5f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer builder = buffer.m_6299_(GunRenderType.getMuzzleFlash(flashTexture));
        builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, 0.0f).m_85969_(0xF000F0).m_5752_();
        poseStack.m_85849_();
    }
}

