/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.entity.throwable.ThrowableBeaconGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableChokeBombEntity;
import top.ribs.scguns.entity.throwable.ThrowableGasGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableHellfireBombEntity;
import top.ribs.scguns.entity.throwable.ThrowableMolotovCocktailEntity;
import top.ribs.scguns.entity.throwable.ThrowableNailBombEntity;
import top.ribs.scguns.entity.throwable.ThrowableStunGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableSwarmBombEntity;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.BeaconGrenadeItem;
import top.ribs.scguns.item.ChokeBombItem;
import top.ribs.scguns.item.GasGrenadeItem;
import top.ribs.scguns.item.GrenadeItem;
import top.ribs.scguns.item.HellfireBombItem;
import top.ribs.scguns.item.MolotovCocktailItem;
import top.ribs.scguns.item.NailBombItem;
import top.ribs.scguns.item.StunGrenadeItem;
import top.ribs.scguns.item.SwarmBombItem;

public class MineUnitBlockEntity
extends BlockEntity {
    private ItemStack storedGrenade = ItemStack.f_41583_;
    private UUID placerUUID = null;
    private boolean primed = false;
    private static final double DETECTION_RADIUS = 1.25;

    public MineUnitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MINE_UNIT.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (!(blockEntity instanceof MineUnitBlockEntity)) {
            return;
        }
        MineUnitBlockEntity mineUnit = (MineUnitBlockEntity)blockEntity;
        if (level.m_5776_() || !mineUnit.hasGrenade() || !mineUnit.isPrimed()) {
            return;
        }
        AABB detectionBox = new AABB(pos).m_82400_(1.25);
        List nearbyEntities = level.m_45933_(null, detectionBox);
        UUID placerUUID = mineUnit.getPlacerUUID();
        for (Entity entity : nearbyEntities) {
            if (entity.m_20148_().equals(placerUUID) || entity.m_6095_().m_204039_(ModTags.Entities.IGNORES_MINE_UNITS)) continue;
            mineUnit.triggerGrenade(level, pos);
            break;
        }
    }

    private void triggerGrenade(Level level, BlockPos pos) {
        ServerLevel serverLevel;
        Entity entity;
        if (this.storedGrenade.m_41619_()) {
            return;
        }
        LivingEntity placer = null;
        if (this.placerUUID != null && level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(this.placerUUID)) instanceof LivingEntity) {
            LivingEntity living;
            placer = living = (LivingEntity)entity;
        }
        LivingEntity effectivePlacer = placer != null ? placer : new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, ItemStack.f_41583_).m_6688_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        this.spawnTriggerEffects(level, x, y, z);
        Item grenadeItem = this.storedGrenade.m_41720_();
        if (grenadeItem instanceof StunGrenadeItem) {
            ThrowableStunGrenadeEntity grenade = new ThrowableStunGrenadeEntity(level, effectivePlacer, 2);
            grenade.m_6027_(x, y, z);
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof GasGrenadeItem) {
            ThrowableGasGrenadeEntity grenade = new ThrowableGasGrenadeEntity(level, effectivePlacer, 2, 6.0f);
            grenade.m_6027_(x, y, z);
            grenade.setItem(this.storedGrenade.m_41777_());
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof MolotovCocktailItem) {
            ThrowableMolotovCocktailEntity grenade = new ThrowableMolotovCocktailEntity(level, effectivePlacer, 2);
            grenade.m_6027_(x, y, z);
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof HellfireBombItem) {
            ThrowableHellfireBombEntity grenade = new ThrowableHellfireBombEntity(level, effectivePlacer, 2);
            grenade.m_6027_(x, y, z);
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof ChokeBombItem) {
            ThrowableChokeBombEntity grenade = new ThrowableChokeBombEntity(level, effectivePlacer, 2, 4.0f);
            grenade.m_6027_(x, y, z);
            grenade.setItem(this.storedGrenade.m_41777_());
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof BeaconGrenadeItem) {
            ThrowableBeaconGrenadeEntity grenade = new ThrowableBeaconGrenadeEntity(level, effectivePlacer, 2);
            grenade.m_6027_(x, y, z);
            grenade.setItem(this.storedGrenade.m_41777_());
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof NailBombItem) {
            ThrowableNailBombEntity grenade = new ThrowableNailBombEntity(level, effectivePlacer, 2);
            grenade.m_6027_(x, y, z);
            grenade.setItem(this.storedGrenade.m_41777_());
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof SwarmBombItem) {
            ThrowableSwarmBombEntity grenade = new ThrowableSwarmBombEntity(level, effectivePlacer, 2);
            grenade.m_6027_(x, y, z);
            grenade.setItem(this.storedGrenade.m_41777_());
            level.m_7967_((Entity)grenade);
        } else if (grenadeItem instanceof GrenadeItem) {
            ThrowableGrenadeEntity grenade = new ThrowableGrenadeEntity(level, effectivePlacer, 2);
            grenade.m_6027_(x, y, z);
            grenade.setItem(this.storedGrenade.m_41777_());
            level.m_7967_((Entity)grenade);
        }
        this.storedGrenade = ItemStack.f_41583_;
        this.m_6596_();
        level.m_7471_(this.f_58858_, false);
    }

    private void spawnTriggerEffects(Level level, double x, double y, double z) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_6263_(null, x, y, z, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.8f, 1.5f);
            level.m_6263_(null, x, y, z, SoundEvents.f_12524_, SoundSource.BLOCKS, 0.6f, 1.2f);
            for (i = 0; i < 8; ++i) {
                offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.4;
                offsetY = level.f_46441_.m_188500_() * 0.3;
                offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.4;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.02);
            }
            for (i = 0; i < 5; ++i) {
                offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                offsetY = level.f_46441_.m_188500_() * 0.2;
                offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.03, 0.0, 0.01);
            }
        }
    }

    public boolean hasGrenade() {
        return !this.storedGrenade.m_41619_();
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public void setPrimed(boolean primed) {
        this.primed = primed;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public UUID getPlacerUUID() {
        return this.placerUUID;
    }

    public void setGrenade(ItemStack stack, LivingEntity placer) {
        this.storedGrenade = stack.m_41777_();
        if (placer != null) {
            this.placerUUID = placer.m_20148_();
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void dropGrenade() {
        if (this.f_58857_ != null && !this.storedGrenade.m_41619_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.storedGrenade);
            this.storedGrenade = ItemStack.f_41583_;
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.storedGrenade.m_41619_()) {
            tag.m_128365_("StoredGrenade", (Tag)this.storedGrenade.m_41739_(new CompoundTag()));
        }
        if (this.placerUUID != null) {
            tag.m_128362_("PlacerUUID", this.placerUUID);
        }
        tag.m_128379_("Primed", this.primed);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("StoredGrenade")) {
            this.storedGrenade = ItemStack.m_41712_((CompoundTag)tag.m_128469_("StoredGrenade"));
        }
        if (tag.m_128403_("PlacerUUID")) {
            this.placerUUID = tag.m_128342_("PlacerUUID");
        }
        this.primed = tag.m_128471_("Primed");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

