/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.blockentity.MobTrapBlockEntity;
import top.ribs.scguns.init.ModBlockEntities;

public class MobTrapBlock
extends BaseEntityBlock {
    public MobTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MobTrapBlockEntity) {
            MobTrapBlockEntity mobTrap = (MobTrapBlockEntity)blockEntity;
            if (heldItem.m_41619_()) {
                List<EntityType<?>> storedMobs = mobTrap.getStoredMobs();
                if (storedMobs.isEmpty()) {
                    player.m_213846_((Component)Component.m_237115_((String)"mobtrap.empty").m_130940_(ChatFormatting.GRAY));
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"mobtrap.stored_mobs").m_130940_(ChatFormatting.GRAY));
                    HashMap mobCounts = new HashMap();
                    for (EntityType<?> entityType : storedMobs) {
                        mobCounts.put(entityType, mobCounts.getOrDefault(entityType, 0) + 1);
                    }
                    for (Map.Entry entry : mobCounts.entrySet()) {
                        player.m_213846_((Component)Component.m_237113_((String)("- " + ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)entry.getKey())).toString() + " x" + entry.getValue())).m_130940_(ChatFormatting.GREEN));
                    }
                }
            } else {
                Item storedMobs = heldItem.m_41720_();
                if (storedMobs instanceof SpawnEggItem) {
                    SpawnEggItem eggItem = (SpawnEggItem)storedMobs;
                    EntityType entityType = eggItem.m_43228_(null);
                    if (mobTrap.addMob(entityType)) {
                        if (!player.m_7500_()) {
                            heldItem.m_41774_(1);
                        }
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"mobtrap.too_many_mobs").m_130940_(ChatFormatting.RED));
                    }
                } else {
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && entity instanceof Player && (blockEntity = level.m_7702_(pos)) instanceof MobTrapBlockEntity) {
            MobTrapBlockEntity mobTrap = (MobTrapBlockEntity)blockEntity;
            mobTrap.releaseMobs((ServerLevel)level, pos);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MobTrapBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.MOB_TRAP.get()), (lvl, pos, blockState, blockEntity) -> {
            if (blockEntity instanceof MobTrapBlockEntity) {
                blockEntity.serverTick(lvl, pos);
            }
        });
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MobTrapBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

