/*
 * Decompiled with CFR 0.152.
 */
package krelox.compat_o_plenty.core.registry.helper;

import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.item.BEWLRBlockItem;
import com.teamabnormals.blueprint.common.item.BEWLRFuelBlockItem;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.function.Supplier;
import krelox.compat_o_plenty.core.CompatOPlenty;
import krelox.compat_o_plenty.integrations.farmersdelight.COPFarmersDelight;
import krelox.compat_o_plenty.integrations.quark.COPQuark;
import krelox.compat_o_plenty.integrations.twigs.COPTwigs;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class COPBlockSubRegistryHelper
extends BlockSubRegistryHelper {
    public COPBlockSubRegistryHelper(RegistryHelper parent) {
        super(parent);
    }

    public RegistryObject<Block> createCabinetBlock(String materialName, int burnTime) {
        return this.createFuelBlock(materialName + "_cabinet", COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"farmersdelight"}) ? COPFarmersDelight.cabinet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_)) : () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_)), burnTime);
    }

    public RegistryObject<Block> createTableBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createBlock(materialName + "_table", COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"twigs"}) ? COPTwigs.table(properties) : () -> new Block(properties));
    }

    public RegistryObject<Block> createHollowLogBlock(String materialName, Supplier<Block> log, BlockBehaviour.Properties properties) {
        return this.createFuelBlock("hollow_" + materialName + "_log", COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"quark"}) ? COPQuark.hollowLog(log, true) : () -> new Block(properties), properties.f_278123_ ? 300 : -1);
    }

    public RegistryObject<Block> createVerticalSlabBlock(String name, Supplier<Block> slab, BlockBehaviour.Properties properties) {
        return this.createBlock(name, COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"quark"}) ? COPQuark.verticalSlab(slab, properties) : () -> new Block(properties));
    }

    public RegistryObject<Block> createWoodVerticalSlabBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createFuelBlock(materialName + "_vertical_slab", COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"quark"}) ? COPQuark.verticalSlab(CompatOPlenty.bopBlock(materialName + "_slab"), properties) : () -> new Block(properties), properties.f_278123_ ? 150 : -1);
    }

    public RegistryObject<Block> createWoodPostBlock(String prefix, String materialName, Block fence, SoundType sound, int burnTime) {
        return this.createFuelBlock(prefix + materialName + "_post", COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"quark"}) ? COPQuark.woodPost(fence, sound) : () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)fence)), burnTime);
    }

    public RegistryObject<Block> createHedgeBlock(String name, Supplier<Block> fence, Supplier<Block> leaves, int burnTime) {
        return this.createFuelBlock(name, COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"quark"}) ? COPQuark.hedge(fence, leaves) : () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)), burnTime);
    }

    public RegistryObject<Block> createLeafCarpetBlock(String name, Supplier<Block> leaves) {
        return this.createBlock(name, COPBlockSubRegistryHelper.areModsLoaded((String[])new String[]{"quark"}) ? COPQuark.leafCarpet(leaves) : () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
    }

    public RegistryObject<Block> createLeafCarpetBlock(String materialName) {
        return this.createLeafCarpetBlock(materialName + "_leaf_carpet", CompatOPlenty.bopBlock(materialName + "_leaves"));
    }

    public RegistryObject<BlueprintChestBlock> createChestBlock(String materialName, BlockBehaviour.Properties properties) {
        String name = materialName + "_chest";
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)materialName, (boolean)false);
        RegistryObject block = this.deferredRegister.register(name, () -> new BlueprintChestBlock(chestMaterialsName, properties));
        this.itemRegister.register(name, () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> COPBlockSubRegistryHelper.chestBEWLR(false), properties.f_278123_ ? 300 : -1));
        return block;
    }

    public RegistryObject<BlueprintTrappedChestBlock> createTrappedChestBlockNamed(String materialName, BlockBehaviour.Properties properties) {
        String name = "trapped_" + materialName + "_chest";
        String modId = this.parent.getModId();
        BlueprintChestMaterials.registerMaterials((String)modId, (String)materialName, (boolean)true);
        RegistryObject block = this.deferredRegister.register(name, () -> new BlueprintTrappedChestBlock(modId + ":" + materialName + "_trapped", properties));
        this.itemRegister.register(name, () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> COPBlockSubRegistryHelper.chestBEWLR(true), properties.f_278123_ ? 300 : -1));
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }
}

