/*
 * Decompiled with CFR 0.152.
 */
package krelox.compat_o_plenty.core.registry;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BOPWoodTypes;
import com.teamabnormals.blueprint.common.block.BlueprintBeehiveBlock;
import com.teamabnormals.blueprint.common.block.LeafPileBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.core.util.PropertyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import krelox.compat_o_plenty.common.blocks.RoseQuartzSlabBlock;
import krelox.compat_o_plenty.common.blocks.RoseQuartzStairBlock;
import krelox.compat_o_plenty.common.blocks.RoseQuartzWallBlock;
import krelox.compat_o_plenty.core.CompatOPlenty;
import krelox.compat_o_plenty.core.registry.helper.COPBlockSubRegistryHelper;
import krelox.compat_o_plenty.integrations.quark.COPQuark;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="compat_o_plenty")
public class COPBlocks {
    public static final COPBlockSubRegistryHelper HELPER = (COPBlockSubRegistryHelper)CompatOPlenty.REGISTRY_HELPER.getBlockSubHelper();
    public static final HashMap<WoodType, PropertyUtil.WoodSetProperties> WOOD_PROPERTIES = (HashMap)Util.m_137469_(new HashMap(), map -> {
        map.put(BOPWoodTypes.FIR, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283919_).build());
        map.put(BOPWoodTypes.REDWOOD, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283798_).build());
        map.put(BOPWoodTypes.MAHOGANY, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283870_).build());
        map.put(BOPWoodTypes.JACARANDA, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283919_).build());
        map.put(BOPWoodTypes.PALM, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283843_).build());
        map.put(BOPWoodTypes.WILLOW, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283778_).build());
        map.put(BOPWoodTypes.DEAD, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283947_).build());
        map.put(BOPWoodTypes.MAGIC, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283743_).build());
        map.put(BOPWoodTypes.UMBRAN, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283908_).build());
        map.put(BOPWoodTypes.HELLBARK, PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283861_).fireproof().build());
    });
    public static final HashMap<WoodType, RegistryObject<Block>> BOARDS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> LEAF_PILES = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> LADDERS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> BEEHIVES = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> BOOKSHELVES = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> CHISELED_BOOKSHELVES = new HashMap();
    public static final HashMap<WoodType, RegistryObject<BlueprintChestBlock>> CHESTS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<BlueprintTrappedChestBlock>> TRAPPED_CHESTS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> CABINETS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> TABLES = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> HOLLOW_LOGS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> VERTICAL_PLANKS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> VERTICAL_SLABS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> POSTS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> STRIPPED_POSTS = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> HEDGES = new HashMap();
    public static final HashMap<WoodType, RegistryObject<Block>> LEAF_CARPETS = new HashMap();
    public static final BlockBehaviour.Properties WHITE_SANDSTONE_PROPERTIES;
    public static RegistryObject<Block> WHITE_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> CUT_WHITE_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> SMOOTH_WHITE_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> WHITE_SANDSTONE_BRICKS;
    public static RegistryObject<Block> WHITE_SANDSTONE_BRICK_STAIRS;
    public static RegistryObject<Block> WHITE_SANDSTONE_BRICK_SLAB;
    public static RegistryObject<Block> WHITE_SANDSTONE_BRICK_VERTICAL_SLAB;
    public static RegistryObject<Block> WHITE_SANDSTONE_BRICK_WALL;
    public static final BlockBehaviour.Properties ORANGE_SANDSTONE_PROPERTIES;
    public static RegistryObject<Block> ORANGE_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> CUT_ORANGE_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> SMOOTH_ORANGE_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> ORANGE_SANDSTONE_BRICKS;
    public static RegistryObject<Block> ORANGE_SANDSTONE_BRICK_STAIRS;
    public static RegistryObject<Block> ORANGE_SANDSTONE_BRICK_SLAB;
    public static RegistryObject<Block> ORANGE_SANDSTONE_BRICK_VERTICAL_SLAB;
    public static RegistryObject<Block> ORANGE_SANDSTONE_BRICK_WALL;
    public static final BlockBehaviour.Properties BLACK_SANDSTONE_PROPERTIES;
    public static RegistryObject<Block> BLACK_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> CUT_BLACK_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> SMOOTH_BLACK_SANDSTONE_VERTICAL_SLAB;
    public static RegistryObject<Block> BLACK_SANDSTONE_BRICKS;
    public static RegistryObject<Block> BLACK_SANDSTONE_BRICK_STAIRS;
    public static RegistryObject<Block> BLACK_SANDSTONE_BRICK_SLAB;
    public static RegistryObject<Block> BLACK_SANDSTONE_BRICK_VERTICAL_SLAB;
    public static RegistryObject<Block> BLACK_SANDSTONE_BRICK_WALL;
    public static final BlockBehaviour.Properties GALANOS_PROPERTIES;
    public static RegistryObject<Block> GALANOS_BLOCK;
    public static RegistryObject<Block> GALANOS_PILLAR;
    public static RegistryObject<Block> GALANOS_STAIRS;
    public static RegistryObject<Block> GALANOS_SLAB;
    public static RegistryObject<Block> GALANOS_VERTICAL_SLAB;
    public static final BlockBehaviour.Properties POLISHED_ROSE_QUARTZ_PROPERTIES;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ;
    public static RegistryObject<Block> CHISELED_POLISHED_ROSE_QUARTZ;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_STAIRS;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_SLAB;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_VERTICAL_SLAB;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_BRICKS;
    public static RegistryObject<Block> CRACKED_POLISHED_ROSE_QUARTZ_BRICKS;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_BRICK_STAIRS;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_BRICK_SLAB;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB;
    public static RegistryObject<Block> POLISHED_ROSE_QUARTZ_BRICK_WALL;
    public static RegistryObject<Block> ORIGIN_LEAF_PILE;
    public static RegistryObject<Block> ORIGIN_LEAF_CARPET;
    public static RegistryObject<Block> ORIGIN_HEDGE;
    public static RegistryObject<Block> FLOWERING_OAK_LEAF_PILE;
    public static RegistryObject<Block> FLOWERING_OAK_LEAF_CARPET;
    public static RegistryObject<Block> FLOWERING_OAK_HEDGE;
    public static RegistryObject<Block> RAINBOW_BIRCH_LEAF_PILE;
    public static RegistryObject<Block> RAINBOW_BIRCH_LEAF_CARPET;
    public static RegistryObject<Block> RAINBOW_BIRCH_HEDGE;
    public static RegistryObject<Block> CYPRESS_LEAF_PILE;
    public static RegistryObject<Block> CYPRESS_LEAF_CARPET;
    public static RegistryObject<Block> CYPRESS_HEDGE;
    public static RegistryObject<Block> SNOWBLOSSOM_LEAF_PILE;
    public static RegistryObject<Block> SNOWBLOSSOM_LEAF_CARPET;
    public static RegistryObject<Block> SNOWBLOSSOM_HEDGE;
    public static RegistryObject<Block> RED_MAPLE_LEAF_PILE;
    public static RegistryObject<Block> RED_MAPLE_LEAF_CARPET;
    public static RegistryObject<Block> RED_MAPLE_HEDGE;
    public static RegistryObject<Block> ORANGE_MAPLE_LEAF_PILE;
    public static RegistryObject<Block> ORANGE_MAPLE_LEAF_CARPET;
    public static RegistryObject<Block> ORANGE_MAPLE_HEDGE;
    public static RegistryObject<Block> YELLOW_MAPLE_LEAF_PILE;
    public static RegistryObject<Block> YELLOW_MAPLE_LEAF_CARPET;
    public static RegistryObject<Block> YELLOW_MAPLE_HEDGE;

    private COPBlocks() {
    }

    static {
        for (Map.Entry<WoodType, PropertyUtil.WoodSetProperties> entry : WOOD_PROPERTIES.entrySet()) {
            WoodType woodType = entry.getKey();
            PropertyUtil.WoodSetProperties properties = entry.getValue();
            String materialName = woodType.f_61839_().replace("biomesoplenty:", "");
            int burnTime = properties.planks().f_278123_ ? 300 : -1;
            BOARDS.put(woodType, (RegistryObject<Block>)HELPER.createFuelBlock(materialName + "_boards", () -> new RotatedPillarBlock(properties.planks()), burnTime));
            LADDERS.put(woodType, (RegistryObject<Block>)HELPER.createFuelBlock(materialName + "_ladder", () -> new LadderBlock(properties.ladder()), burnTime));
            BEEHIVES.put(woodType, (RegistryObject<Block>)HELPER.createFuelBlock(materialName + "_beehive", () -> new BlueprintBeehiveBlock(properties.beehive()), burnTime));
            BOOKSHELVES.put(woodType, (RegistryObject<Block>)HELPER.createFuelBlock(materialName + "_bookshelf", () -> new Block(properties.bookshelf()), burnTime));
            CHESTS.put(woodType, HELPER.createChestBlock(materialName, properties.chest()));
            TRAPPED_CHESTS.put(woodType, HELPER.createTrappedChestBlockNamed(materialName, properties.chest()));
            LEAF_PILES.put(woodType, (RegistryObject<Block>)HELPER.createBlock(materialName + "_leaf_pile", () -> new LeafPileBlock(properties.leafPile())));
            CABINETS.put(woodType, HELPER.createCabinetBlock(materialName, burnTime));
            TABLES.put(woodType, HELPER.createTableBlock(materialName, properties.planks()));
            HOLLOW_LOGS.put(woodType, HELPER.createHollowLogBlock(materialName, CompatOPlenty.bopBlock(materialName + "_log"), properties.log()));
            VERTICAL_PLANKS.put(woodType, (RegistryObject<Block>)HELPER.createFuelBlock("vertical_" + materialName + "_planks", () -> new Block(properties.planks()), burnTime));
            VERTICAL_SLABS.put(woodType, HELPER.createWoodVerticalSlabBlock(materialName, properties.planks()));
            Block fence = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(woodType.f_61839_() + "_fence"));
            POSTS.put(woodType, HELPER.createWoodPostBlock("", materialName, fence, properties.sound(), burnTime));
            STRIPPED_POSTS.put(woodType, HELPER.createWoodPostBlock("stripped_", materialName, fence, properties.sound(), burnTime));
            HEDGES.put(woodType, HELPER.createHedgeBlock(materialName + "_hedge", CompatOPlenty.bopBlock(materialName + "_fence"), CompatOPlenty.bopBlock(materialName + "_leaves"), burnTime));
            LEAF_CARPETS.put(woodType, HELPER.createLeafCarpetBlock(materialName));
        }
        WHITE_SANDSTONE_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283942_).m_60999_().m_60978_(0.8f);
        WHITE_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("white_sandstone_vertical_slab", () -> BOPBlocks.WHITE_SANDSTONE_SLAB, WHITE_SANDSTONE_PROPERTIES);
        CUT_WHITE_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("cut_white_sandstone_vertical_slab", () -> BOPBlocks.CUT_WHITE_SANDSTONE_SLAB, WHITE_SANDSTONE_PROPERTIES);
        SMOOTH_WHITE_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("smooth_white_sandstone_vertical_slab", () -> BOPBlocks.SMOOTH_WHITE_SANDSTONE_SLAB, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283942_).m_60999_().m_60913_(2.0f, 6.0f));
        WHITE_SANDSTONE_BRICKS = HELPER.createBlock("white_sandstone_bricks", () -> new Block(WHITE_SANDSTONE_PROPERTIES));
        WHITE_SANDSTONE_BRICK_STAIRS = HELPER.createBlock("white_sandstone_brick_stairs", () -> new StairBlock(((Block)WHITE_SANDSTONE_BRICKS.get()).m_49966_(), WHITE_SANDSTONE_PROPERTIES));
        WHITE_SANDSTONE_BRICK_SLAB = HELPER.createBlock("white_sandstone_brick_slab", () -> new SlabBlock(WHITE_SANDSTONE_PROPERTIES));
        WHITE_SANDSTONE_BRICK_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("white_sandstone_brick_vertical_slab", (Supplier<Block>)WHITE_SANDSTONE_BRICK_SLAB, WHITE_SANDSTONE_PROPERTIES);
        WHITE_SANDSTONE_BRICK_WALL = HELPER.createBlock("white_sandstone_brick_wall", () -> new WallBlock(WHITE_SANDSTONE_PROPERTIES));
        ORANGE_SANDSTONE_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283750_).m_60999_().m_60978_(0.8f);
        ORANGE_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("orange_sandstone_vertical_slab", () -> BOPBlocks.ORANGE_SANDSTONE_SLAB, ORANGE_SANDSTONE_PROPERTIES);
        CUT_ORANGE_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("cut_orange_sandstone_vertical_slab", () -> BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB, ORANGE_SANDSTONE_PROPERTIES);
        SMOOTH_ORANGE_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("smooth_orange_sandstone_vertical_slab", () -> BOPBlocks.SMOOTH_ORANGE_SANDSTONE_SLAB, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283750_).m_60999_().m_60913_(2.0f, 6.0f));
        ORANGE_SANDSTONE_BRICKS = HELPER.createBlock("orange_sandstone_bricks", () -> new Block(ORANGE_SANDSTONE_PROPERTIES));
        ORANGE_SANDSTONE_BRICK_STAIRS = HELPER.createBlock("orange_sandstone_brick_stairs", () -> new StairBlock(((Block)ORANGE_SANDSTONE_BRICKS.get()).m_49966_(), ORANGE_SANDSTONE_PROPERTIES));
        ORANGE_SANDSTONE_BRICK_SLAB = HELPER.createBlock("orange_sandstone_brick_slab", () -> new SlabBlock(ORANGE_SANDSTONE_PROPERTIES));
        ORANGE_SANDSTONE_BRICK_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("orange_sandstone_brick_vertical_slab", (Supplier<Block>)ORANGE_SANDSTONE_BRICK_SLAB, ORANGE_SANDSTONE_PROPERTIES);
        ORANGE_SANDSTONE_BRICK_WALL = HELPER.createBlock("orange_sandstone_brick_wall", () -> new WallBlock(ORANGE_SANDSTONE_PROPERTIES));
        BLACK_SANDSTONE_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283927_).m_60999_().m_60978_(0.8f);
        BLACK_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("black_sandstone_vertical_slab", () -> BOPBlocks.BLACK_SANDSTONE_SLAB, BLACK_SANDSTONE_PROPERTIES);
        CUT_BLACK_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("cut_black_sandstone_vertical_slab", () -> BOPBlocks.CUT_BLACK_SANDSTONE_SLAB, BLACK_SANDSTONE_PROPERTIES);
        SMOOTH_BLACK_SANDSTONE_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("smooth_black_sandstone_vertical_slab", () -> BOPBlocks.SMOOTH_BLACK_SANDSTONE_SLAB, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283927_).m_60999_().m_60913_(2.0f, 6.0f));
        BLACK_SANDSTONE_BRICKS = HELPER.createBlock("black_sandstone_bricks", () -> new Block(BLACK_SANDSTONE_PROPERTIES));
        BLACK_SANDSTONE_BRICK_STAIRS = HELPER.createBlock("black_sandstone_brick_stairs", () -> new StairBlock(((Block)BLACK_SANDSTONE_BRICKS.get()).m_49966_(), BLACK_SANDSTONE_PROPERTIES));
        BLACK_SANDSTONE_BRICK_SLAB = HELPER.createBlock("black_sandstone_brick_slab", () -> new SlabBlock(BLACK_SANDSTONE_PROPERTIES));
        BLACK_SANDSTONE_BRICK_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("black_sandstone_brick_vertical_slab", (Supplier<Block>)BLACK_SANDSTONE_BRICK_SLAB, BLACK_SANDSTONE_PROPERTIES);
        BLACK_SANDSTONE_BRICK_WALL = HELPER.createBlock("black_sandstone_brick_wall", () -> new WallBlock(BLACK_SANDSTONE_PROPERTIES));
        GALANOS_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283821_).m_60999_().m_60913_(1.5f, 6.0f).m_60953_(state -> 6).m_60918_(SoundType.f_56742_);
        GALANOS_BLOCK = HELPER.createBlock("galanos_block", () -> new Block(GALANOS_PROPERTIES));
        GALANOS_PILLAR = HELPER.createBlock("galanos_pillar", () -> new RotatedPillarBlock(GALANOS_PROPERTIES));
        GALANOS_STAIRS = HELPER.createBlock("galanos_stairs", () -> new StairBlock(() -> ((Block)GALANOS_BLOCK.get()).m_49966_(), GALANOS_PROPERTIES));
        GALANOS_SLAB = HELPER.createBlock("galanos_slab", () -> new SlabBlock(GALANOS_PROPERTIES));
        GALANOS_VERTICAL_SLAB = HELPER.createVerticalSlabBlock("galanos_vertical_slab", (Supplier<Block>)GALANOS_SLAB, GALANOS_PROPERTIES);
        POLISHED_ROSE_QUARTZ_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283927_).m_60999_().m_60978_(0.8f);
        POLISHED_ROSE_QUARTZ = HELPER.createBlock("polished_rose_quartz", () -> new AmethystBlock(POLISHED_ROSE_QUARTZ_PROPERTIES));
        CHISELED_POLISHED_ROSE_QUARTZ = HELPER.createBlock("chiseled_polished_rose_quartz", () -> new AmethystBlock(POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_STAIRS = HELPER.createBlock("polished_rose_quartz_stairs", () -> new RoseQuartzStairBlock(((Block)POLISHED_ROSE_QUARTZ.get()).m_49966_(), POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_SLAB = HELPER.createBlock("polished_rose_quartz_slab", () -> new RoseQuartzSlabBlock(POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_VERTICAL_SLAB = HELPER.createBlock("polished_rose_quartz_vertical_slab", ModList.get().isLoaded("quark") ? COPQuark.roseQuartzVerticalSlab(POLISHED_ROSE_QUARTZ_SLAB, POLISHED_ROSE_QUARTZ_PROPERTIES) : () -> new Block(POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_BRICKS = HELPER.createBlock("polished_rose_quartz_bricks", () -> new AmethystBlock(POLISHED_ROSE_QUARTZ_PROPERTIES));
        CRACKED_POLISHED_ROSE_QUARTZ_BRICKS = HELPER.createBlock("cracked_polished_rose_quartz_bricks", () -> new AmethystBlock(POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_BRICK_STAIRS = HELPER.createBlock("polished_rose_quartz_brick_stairs", () -> new RoseQuartzStairBlock(((Block)POLISHED_ROSE_QUARTZ_BRICKS.get()).m_49966_(), POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_BRICK_SLAB = HELPER.createBlock("polished_rose_quartz_brick_slab", () -> new RoseQuartzSlabBlock(POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB = HELPER.createBlock("polished_rose_quartz_brick_vertical_slab", ModList.get().isLoaded("quark") ? COPQuark.roseQuartzVerticalSlab(POLISHED_ROSE_QUARTZ_SLAB, POLISHED_ROSE_QUARTZ_PROPERTIES) : () -> new Block(POLISHED_ROSE_QUARTZ_PROPERTIES));
        POLISHED_ROSE_QUARTZ_BRICK_WALL = HELPER.createBlock("polished_rose_quartz_brick_wall", () -> new RoseQuartzWallBlock(POLISHED_ROSE_QUARTZ_PROPERTIES));
        ORIGIN_LEAF_PILE = HELPER.createBlock("origin_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        ORIGIN_LEAF_CARPET = HELPER.createLeafCarpetBlock("origin_leaf_carpet", () -> BOPBlocks.ORIGIN_LEAVES);
        ORIGIN_HEDGE = HELPER.createHedgeBlock("origin_hedge", () -> Blocks.f_50132_, () -> BOPBlocks.ORIGIN_LEAVES, 300);
        FLOWERING_OAK_LEAF_PILE = HELPER.createBlock("flowering_oak_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        FLOWERING_OAK_LEAF_CARPET = HELPER.createLeafCarpetBlock("flowering_oak_leaf_carpet", () -> BOPBlocks.FLOWERING_OAK_LEAVES);
        FLOWERING_OAK_HEDGE = HELPER.createHedgeBlock("flowering_oak_hedge", () -> Blocks.f_50132_, () -> BOPBlocks.FLOWERING_OAK_LEAVES, 300);
        RAINBOW_BIRCH_LEAF_PILE = HELPER.createBlock("rainbow_birch_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        RAINBOW_BIRCH_LEAF_CARPET = HELPER.createLeafCarpetBlock("rainbow_birch_leaf_carpet", () -> BOPBlocks.RAINBOW_BIRCH_LEAVES);
        RAINBOW_BIRCH_HEDGE = HELPER.createHedgeBlock("rainbow_birch_hedge", () -> Blocks.f_50480_, () -> BOPBlocks.RAINBOW_BIRCH_LEAVES, 300);
        CYPRESS_LEAF_PILE = HELPER.createBlock("cypress_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        CYPRESS_LEAF_CARPET = HELPER.createLeafCarpetBlock("cypress_leaf_carpet", () -> BOPBlocks.CYPRESS_LEAVES);
        CYPRESS_HEDGE = HELPER.createHedgeBlock("cypress_hedge", () -> Blocks.f_50479_, () -> BOPBlocks.CYPRESS_LEAVES, 300);
        SNOWBLOSSOM_LEAF_PILE = HELPER.createBlock("snowblossom_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        SNOWBLOSSOM_LEAF_CARPET = HELPER.createLeafCarpetBlock("snowblossom_leaf_carpet", () -> BOPBlocks.SNOWBLOSSOM_LEAVES);
        SNOWBLOSSOM_HEDGE = HELPER.createHedgeBlock("snowblossom_hedge", () -> Blocks.f_271219_, () -> BOPBlocks.SNOWBLOSSOM_LEAVES, 300);
        RED_MAPLE_LEAF_PILE = HELPER.createBlock("red_maple_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        RED_MAPLE_LEAF_CARPET = HELPER.createLeafCarpetBlock("red_maple_leaf_carpet", () -> BOPBlocks.RED_MAPLE_LEAVES);
        RED_MAPLE_HEDGE = HELPER.createHedgeBlock("red_maple_hedge", () -> BOPBlocks.MAPLE_FENCE, () -> BOPBlocks.RED_MAPLE_LEAVES, 300);
        ORANGE_MAPLE_LEAF_PILE = HELPER.createBlock("orange_maple_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        ORANGE_MAPLE_LEAF_CARPET = HELPER.createLeafCarpetBlock("orange_maple_leaf_carpet", () -> BOPBlocks.ORANGE_MAPLE_LEAVES);
        ORANGE_MAPLE_HEDGE = HELPER.createHedgeBlock("orange_maple_hedge", () -> BOPBlocks.MAPLE_FENCE, () -> BOPBlocks.ORANGE_MAPLE_LEAVES, 300);
        YELLOW_MAPLE_LEAF_PILE = HELPER.createBlock("yellow_maple_leaf_pile", () -> new LeafPileBlock(WOOD_PROPERTIES.get(BOPWoodTypes.WILLOW).leafPile()));
        YELLOW_MAPLE_LEAF_CARPET = HELPER.createLeafCarpetBlock("yellow_maple_leaf_carpet", () -> BOPBlocks.YELLOW_MAPLE_LEAVES);
        YELLOW_MAPLE_HEDGE = HELPER.createHedgeBlock("yellow_maple_hedge", () -> BOPBlocks.MAPLE_FENCE, () -> BOPBlocks.YELLOW_MAPLE_LEAVES, 300);
    }
}

