/*
 * Decompiled with CFR 0.152.
 */
package krelox.compat_o_plenty.core.data.server;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.init.ModTags;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.util.TagUtil;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.data.server.BoatloadRecipeProvider;
import com.teamabnormals.woodworks.core.WoodworksConfig;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import krelox.compat_o_plenty.core.CompatOPlenty;
import krelox.compat_o_plenty.core.registry.COPBlocks;
import krelox.compat_o_plenty.core.registry.COPItems;
import krelox.compat_o_plenty.integrations.boatload.COPBoatTypes;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.config.FlagCondition;
import org.violetmoon.zeta.recipe.IZetaCondition;
import org.violetmoon.zetaimplforge.registry.ForgeCraftingExtensionsRegistry;
import vectorwing.farmersdelight.common.crafting.ingredient.ToolActionIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class COPRecipeProvider
extends RecipeProvider {
    public static final ResourceLocation QUARK_FLAG = new ResourceLocation("quark", "flag");
    public static final String VERTICAL_SLABS_FLAG = "vertical_slabs";
    public static final String SANDSTONE_BRICKS_FLAG = "sandstone_bricks";
    public static final String MIDORI_FLAG = "midori";
    public static final String VARIANT_CHESTS_FLAG = "variant_chests";
    public static final String WOOD_TO_CHEST_RECIPES_FLAG = "wood_to_chest_recipes";
    public static final String VERTICAL_PLANKS_FLAG = "vertical_planks";
    public static final String VARIANT_BOOKSHELVES_FLAG = "variant_bookshelves";
    public static final String VARIANT_LADDERS_FLAG = "variant_ladders";
    public static final String WOODEN_POSTS_FLAG = "wooden_posts";
    public static final String HEDGES_FLAG = "hedges";
    public static final String LEAF_CARPET_FLAG = "leaf_carpet";

    public COPRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> consumer) {
        for (WoodType woodType : COPBlocks.WOOD_PROPERTIES.keySet()) {
            String materialName = woodType.f_61839_().replace("biomesoplenty:", "");
            Function<String, Item> getItem = name -> (Item)ForgeRegistries.ITEMS.getValue(CompatOPlenty.bopLoc(name));
            Item slab = getItem.apply(materialName + "_slab");
            Item planks = getItem.apply(materialName + "_planks");
            Item leaves = getItem.apply(materialName + "_leaves");
            COPRecipeProvider.verticalSlabRecipe((ItemLike)slab, (ItemLike)COPBlocks.VERTICAL_SLABS.get(woodType).get(), consumer);
            COPRecipeProvider.bookshelfRecipe((ItemLike)planks, (ItemLike)COPBlocks.BOOKSHELVES.get(woodType).get(), consumer);
            COPRecipeProvider.ladderRecipe((ItemLike)getItem.apply(materialName + "_ladder"), (ItemLike)COPBlocks.LADDERS.get(woodType).get(), consumer);
            COPRecipeProvider.postRecipe((ItemLike)getItem.apply(materialName + "_wood"), (ItemLike)COPBlocks.POSTS.get(woodType).get(), consumer);
            COPRecipeProvider.postRecipe((ItemLike)getItem.apply("stripped_" + materialName + "_wood"), (ItemLike)COPBlocks.STRIPPED_POSTS.get(woodType).get(), consumer);
            COPRecipeProvider.hedgeRecipe(COPRecipeProvider.logTag(materialName), (ItemLike)leaves, (ItemLike)COPBlocks.HEDGES.get(woodType).get(), consumer);
            COPRecipeProvider.leafCarpetRecipe((ItemLike)leaves, (ItemLike)COPBlocks.LEAF_CARPETS.get(woodType).get(), consumer);
            COPRecipeProvider.leafPileRecipe((ItemLike)leaves, (ItemLike)COPBlocks.LEAF_PILES.get(woodType).get(), consumer);
            COPRecipeProvider.chestRecipes((ItemLike)planks, COPRecipeProvider.logTag(materialName), COPBlocks.CHESTS.get(woodType), COPBlocks.TRAPPED_CHESTS.get(woodType), consumer);
            COPRecipeProvider.beehiveRecipe((ItemLike)planks, (ItemLike)COPBlocks.BEEHIVES.get(woodType).get(), consumer);
            COPRecipeProvider.verticalPlankRecipe((ItemLike)planks, (ItemLike)COPBlocks.VERTICAL_PLANKS.get(woodType).get(), consumer);
            COPRecipeProvider.cabinetRecipe((ItemLike)slab, (ItemLike)getItem.apply(materialName + "_trapdoor"), (ItemLike)COPBlocks.CABINETS.get(woodType).get(), consumer);
            COPRecipeProvider.tableRecipe((ItemLike)slab, (ItemLike)getItem.apply(materialName + "_fence"), (ItemLike)COPBlocks.TABLES.get(woodType).get(), consumer);
            COPRecipeProvider.boardsRecipe((ItemLike)planks, (ItemLike)COPBlocks.BOARDS.get(woodType).get(), consumer);
            BoatloadRecipeProvider.boatRecipes(consumer, (BoatloadBoatType)COPBoatTypes.BOAT_TYPES.get(woodType));
        }
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.BLACK_SANDSTONE_SLAB, (ItemLike)COPBlocks.BLACK_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE_SLAB, (ItemLike)COPBlocks.CUT_BLACK_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE_SLAB, (ItemLike)COPBlocks.SMOOTH_BLACK_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_SLAB.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.ORANGE_SANDSTONE_SLAB, (ItemLike)COPBlocks.ORANGE_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB, (ItemLike)COPBlocks.CUT_ORANGE_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE_SLAB, (ItemLike)COPBlocks.SMOOTH_ORANGE_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_SLAB.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.WHITE_SANDSTONE_SLAB, (ItemLike)COPBlocks.WHITE_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE_SLAB, (ItemLike)COPBlocks.CUT_WHITE_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE_SLAB, (ItemLike)COPBlocks.SMOOTH_WHITE_SANDSTONE_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_SLAB.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_SLAB.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_SLAB.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.verticalSlabRecipe((ItemLike)COPBlocks.GALANOS_SLAB.get(), (ItemLike)COPBlocks.GALANOS_VERTICAL_SLAB.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ItemTags.f_13184_, (ItemLike)BOPBlocks.ORIGIN_LEAVES, (ItemLike)COPBlocks.ORIGIN_HEDGE.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ItemTags.f_13184_, (ItemLike)BOPBlocks.FLOWERING_OAK_LEAVES, (ItemLike)COPBlocks.FLOWERING_OAK_HEDGE.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ItemTags.f_13185_, (ItemLike)BOPBlocks.RAINBOW_BIRCH_LEAVES, (ItemLike)COPBlocks.RAINBOW_BIRCH_HEDGE.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ItemTags.f_13188_, (ItemLike)BOPBlocks.CYPRESS_LEAVES, (ItemLike)COPBlocks.CYPRESS_HEDGE.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ItemTags.f_271202_, (ItemLike)BOPBlocks.SNOWBLOSSOM_LEAVES, (ItemLike)COPBlocks.SNOWBLOSSOM_HEDGE.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ModTags.Items.MAPLE_LOGS, (ItemLike)BOPBlocks.RED_MAPLE_LEAVES, (ItemLike)COPBlocks.RED_MAPLE_HEDGE.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ModTags.Items.MAPLE_LOGS, (ItemLike)BOPBlocks.ORANGE_MAPLE_LEAVES, (ItemLike)COPBlocks.ORANGE_MAPLE_HEDGE.get(), consumer);
        COPRecipeProvider.hedgeRecipe((TagKey<Item>)ModTags.Items.MAPLE_LOGS, (ItemLike)BOPBlocks.YELLOW_MAPLE_LEAVES, (ItemLike)COPBlocks.YELLOW_MAPLE_HEDGE.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.ORIGIN_LEAVES, (ItemLike)COPBlocks.ORIGIN_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.FLOWERING_OAK_LEAVES, (ItemLike)COPBlocks.FLOWERING_OAK_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.RAINBOW_BIRCH_LEAVES, (ItemLike)COPBlocks.RAINBOW_BIRCH_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.CYPRESS_LEAVES, (ItemLike)COPBlocks.CYPRESS_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.SNOWBLOSSOM_LEAVES, (ItemLike)COPBlocks.SNOWBLOSSOM_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.RED_MAPLE_LEAVES, (ItemLike)COPBlocks.RED_MAPLE_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.ORANGE_MAPLE_LEAVES, (ItemLike)COPBlocks.ORANGE_MAPLE_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafCarpetRecipe((ItemLike)BOPBlocks.YELLOW_MAPLE_LEAVES, (ItemLike)COPBlocks.YELLOW_MAPLE_LEAF_CARPET.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.ORIGIN_LEAVES, (ItemLike)COPBlocks.ORIGIN_LEAF_PILE.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.FLOWERING_OAK_LEAVES, (ItemLike)COPBlocks.FLOWERING_OAK_LEAF_PILE.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.RAINBOW_BIRCH_LEAVES, (ItemLike)COPBlocks.RAINBOW_BIRCH_LEAF_PILE.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.CYPRESS_LEAVES, (ItemLike)COPBlocks.CYPRESS_LEAF_PILE.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.SNOWBLOSSOM_LEAVES, (ItemLike)COPBlocks.SNOWBLOSSOM_LEAF_PILE.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.RED_MAPLE_LEAVES, (ItemLike)COPBlocks.RED_MAPLE_LEAF_PILE.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.ORANGE_MAPLE_LEAVES, (ItemLike)COPBlocks.ORANGE_MAPLE_LEAF_PILE.get(), consumer);
        COPRecipeProvider.leafPileRecipe((ItemLike)BOPBlocks.YELLOW_MAPLE_LEAVES, (ItemLike)COPBlocks.YELLOW_MAPLE_LEAF_PILE.get(), consumer);
        COPRecipeProvider.sandstoneStairsRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_STAIRS.get(), consumer);
        COPRecipeProvider.sandstoneStairsRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_STAIRS.get(), consumer);
        COPRecipeProvider.sandstoneStairsRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_STAIRS.get(), consumer);
        COPRecipeProvider.galanosStairsRecipe((ItemLike)COPBlocks.GALANOS_BLOCK.get(), (ItemLike)COPBlocks.GALANOS_STAIRS.get(), consumer);
        COPRecipeProvider.polishedRoseStairsRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_STAIRS.get(), consumer);
        COPRecipeProvider.polishedRoseStairsRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_STAIRS.get(), consumer);
        COPRecipeProvider.sandstoneSlabRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_SLAB.get(), consumer);
        COPRecipeProvider.sandstoneSlabRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_SLAB.get(), consumer);
        COPRecipeProvider.sandstoneSlabRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_SLAB.get(), consumer);
        COPRecipeProvider.galanosSlabRecipe((ItemLike)COPBlocks.GALANOS_BLOCK.get(), (ItemLike)COPBlocks.GALANOS_SLAB.get(), consumer);
        COPRecipeProvider.polishedRoseSlabRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_SLAB.get(), consumer);
        COPRecipeProvider.polishedRoseSlabRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_SLAB.get(), consumer);
        COPRecipeProvider.sandstoneWallRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_WALL.get(), consumer);
        COPRecipeProvider.sandstoneWallRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_WALL.get(), consumer);
        COPRecipeProvider.sandstoneWallRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_WALL.get(), consumer);
        COPRecipeProvider.polishedRoseWallRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_WALL.get(), consumer);
        COPRecipeProvider.polishedRoseRecipe(consumer);
        COPRecipeProvider.galanosRecipe(consumer);
        COPRecipeProvider.chiseledBlockRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_SLAB.get(), (ItemLike)COPBlocks.CHISELED_POLISHED_ROSE_QUARTZ.get(), "twigs", consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.BLACK_SANDSTONE, (ItemLike)COPBlocks.BLACK_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.SMOOTH_BLACK_SANDSTONE, (ItemLike)COPBlocks.SMOOTH_BLACK_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, (ItemLike)COPBlocks.CUT_BLACK_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.BLACK_SANDSTONE, (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.CUT_BLACK_SANDSTONE, (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_STAIRS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_SLAB.get(), 2, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_VERTICAL_SLAB.get(), 2, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.BLACK_SANDSTONE_BRICK_WALL.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.ORANGE_SANDSTONE, (ItemLike)COPBlocks.ORANGE_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.SMOOTH_ORANGE_SANDSTONE, (ItemLike)COPBlocks.SMOOTH_ORANGE_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, (ItemLike)COPBlocks.CUT_ORANGE_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.ORANGE_SANDSTONE, (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.CUT_ORANGE_SANDSTONE, (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_STAIRS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_SLAB.get(), 2, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_VERTICAL_SLAB.get(), 2, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.ORANGE_SANDSTONE_BRICK_WALL.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.WHITE_SANDSTONE, (ItemLike)COPBlocks.WHITE_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.SMOOTH_WHITE_SANDSTONE, (ItemLike)COPBlocks.SMOOTH_WHITE_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, (ItemLike)COPBlocks.CUT_WHITE_SANDSTONE_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.WHITE_SANDSTONE, (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)BOPBlocks.CUT_WHITE_SANDSTONE, (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_STAIRS.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_SLAB.get(), 2, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_VERTICAL_SLAB.get(), 2, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (ItemLike)COPBlocks.WHITE_SANDSTONE_BRICK_WALL.get(), 1, SANDSTONE_BRICKS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.GALANOS_BLOCK.get(), (ItemLike)COPBlocks.GALANOS_STAIRS.get(), 1, MIDORI_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.GALANOS_BLOCK.get(), (ItemLike)COPBlocks.GALANOS_SLAB.get(), 2, MIDORI_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.GALANOS_BLOCK.get(), (ItemLike)COPBlocks.GALANOS_VERTICAL_SLAB.get(), 2, VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.quarkFlagStoneCutterRecipe((ItemLike)COPBlocks.GALANOS_BLOCK.get(), (ItemLike)COPBlocks.GALANOS_PILLAR.get(), 1, MIDORI_FLAG, consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_STAIRS.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_SLAB.get(), 2, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.CHISELED_POLISHED_ROSE_QUARTZ.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_SLAB.get(), 2, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_WALL.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_STAIRS.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_SLAB.get(), 2, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.CHISELED_POLISHED_ROSE_QUARTZ.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_STAIRS.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_SLAB.get(), 2, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_WALL.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_STAIRS.get(), 1, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_SLAB.get(), 2, "twigs", consumer);
        COPRecipeProvider.modLoadedStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_WALL.get(), 1, "twigs", consumer);
        COPRecipeProvider.multiModStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_VERTICAL_SLAB.get(), 2, "twigs", VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.multiModStoneCutterRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB.get(), 2, "twigs", VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.multiModStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_VERTICAL_SLAB.get(), 2, "twigs", VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.multiModStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB.get(), 2, "twigs", VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.multiModStoneCutterRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB.get(), 2, "twigs", VERTICAL_SLABS_FLAG, consumer);
        COPRecipeProvider.flaggedFurnaceRecipe((ItemLike)BOPBlocks.GLOWING_MOSS_BLOCK, (ItemLike)COPItems.GLOWING_MOSS_PASTE.get(), 1.0f, MIDORI_FLAG, consumer);
        COPRecipeProvider.modLoadedFurnaceRecipe((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (ItemLike)COPBlocks.CRACKED_POLISHED_ROSE_QUARTZ_BRICKS.get(), 0.1f, "twigs", consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.JACARANDA_LOG, (ItemLike)BOPBlocks.STRIPPED_JACARANDA_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.FIR_LOG, (ItemLike)BOPBlocks.STRIPPED_FIR_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.REDWOOD_LOG, (ItemLike)BOPBlocks.STRIPPED_REDWOOD_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.MAHOGANY_LOG, (ItemLike)BOPBlocks.STRIPPED_MAHOGANY_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.WILLOW_LOG, (ItemLike)BOPBlocks.STRIPPED_WILLOW_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.MAGIC_LOG, (ItemLike)BOPBlocks.STRIPPED_MAGIC_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.DEAD_LOG, (ItemLike)BOPBlocks.STRIPPED_DEAD_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.UMBRAN_LOG, (ItemLike)BOPBlocks.STRIPPED_UMBRAN_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.PALM_LOG, (ItemLike)BOPBlocks.STRIPPED_PALM_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.HELLBARK_LOG, (ItemLike)BOPBlocks.STRIPPED_HELLBARK_LOG, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.JACARANDA_WOOD, (ItemLike)BOPBlocks.STRIPPED_JACARANDA_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.FIR_WOOD, (ItemLike)BOPBlocks.STRIPPED_FIR_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.REDWOOD_WOOD, (ItemLike)BOPBlocks.STRIPPED_REDWOOD_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.MAHOGANY_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAHOGANY_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.WILLOW_WOOD, (ItemLike)BOPBlocks.STRIPPED_WILLOW_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.MAGIC_WOOD, (ItemLike)BOPBlocks.STRIPPED_MAGIC_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.DEAD_WOOD, (ItemLike)BOPBlocks.STRIPPED_DEAD_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.UMBRAN_WOOD, (ItemLike)BOPBlocks.STRIPPED_UMBRAN_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.PALM_WOOD, (ItemLike)BOPBlocks.STRIPPED_PALM_WOOD, consumer);
        COPRecipeProvider.stripLogCuttingRecipe((ItemLike)BOPBlocks.HELLBARK_WOOD, (ItemLike)BOPBlocks.STRIPPED_HELLBARK_WOOD, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.BLUE_HYDRANGEA, (ItemLike)Items.f_42538_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.BURNING_BLOSSOM, (ItemLike)Items.f_42536_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.GLOWFLOWER, (ItemLike)Items.f_42492_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.GOLDENROD, (ItemLike)Items.f_42539_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.LAVENDER, (ItemLike)Items.f_42493_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.ORANGE_COSMOS, (ItemLike)Items.f_42536_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.PINK_DAFFODIL, (ItemLike)Items.f_42489_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.PINK_HIBISCUS, (ItemLike)Items.f_42489_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.ROSE, (ItemLike)Items.f_42497_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.VIOLET, (ItemLike)Items.f_42493_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.WILDFLOWER, (ItemLike)Items.f_42537_, consumer);
        COPRecipeProvider.dyeCuttingRecipe((ItemLike)BOPBlocks.WILTED_LILY, (ItemLike)Items.f_42490_, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.JACARANDA_PLANKS, (ItemLike)BOPBlocks.JACARANDA_DOOR, (ItemLike)BOPBlocks.JACARANDA_TRAPDOOR, (ItemLike)BOPBlocks.JACARANDA_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.FIR_PLANKS, (ItemLike)BOPBlocks.FIR_DOOR, (ItemLike)BOPBlocks.FIR_TRAPDOOR, (ItemLike)BOPBlocks.FIR_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.REDWOOD_PLANKS, (ItemLike)BOPBlocks.REDWOOD_DOOR, (ItemLike)BOPBlocks.REDWOOD_TRAPDOOR, (ItemLike)BOPBlocks.REDWOOD_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.MAHOGANY_PLANKS, (ItemLike)BOPBlocks.MAHOGANY_DOOR, (ItemLike)BOPBlocks.MAHOGANY_TRAPDOOR, (ItemLike)BOPBlocks.MAHOGANY_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.WILLOW_PLANKS, (ItemLike)BOPBlocks.WILLOW_DOOR, (ItemLike)BOPBlocks.WILLOW_TRAPDOOR, (ItemLike)BOPBlocks.WILLOW_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.MAGIC_PLANKS, (ItemLike)BOPBlocks.MAGIC_DOOR, (ItemLike)BOPBlocks.MAGIC_TRAPDOOR, (ItemLike)BOPBlocks.MAGIC_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.DEAD_PLANKS, (ItemLike)BOPBlocks.DEAD_DOOR, (ItemLike)BOPBlocks.DEAD_TRAPDOOR, (ItemLike)BOPBlocks.DEAD_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.UMBRAN_PLANKS, (ItemLike)BOPBlocks.UMBRAN_DOOR, (ItemLike)BOPBlocks.UMBRAN_TRAPDOOR, (ItemLike)BOPBlocks.UMBRAN_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.PALM_PLANKS, (ItemLike)BOPBlocks.PALM_DOOR, (ItemLike)BOPBlocks.PALM_TRAPDOOR, (ItemLike)BOPBlocks.PALM_SIGN, consumer);
        COPRecipeProvider.furnitureSalvageCuttingRecipes((ItemLike)BOPBlocks.HELLBARK_PLANKS, (ItemLike)BOPBlocks.HELLBARK_DOOR, (ItemLike)BOPBlocks.HELLBARK_TRAPDOOR, (ItemLike)BOPBlocks.HELLBARK_SIGN, consumer);
        COPRecipeProvider.genericCuttingRecipe((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK, (Ingredient)new ToolActionIngredient(ToolActions.PICKAXE_DIG), (ItemLike)BOPItems.ROSE_QUARTZ_CHUNK, 4, ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_144242_).toString(), consumer);
    }

    public static TagKey<Item> logTag(String woodType) {
        return TagUtil.itemTag((String)"biomesoplenty", (String)(woodType + "_logs"));
    }

    private static ForgeCraftingExtensionsRegistry.Zeta2ForgeCondition<FlagCondition> quarkCondition(String flag) {
        return new ForgeCraftingExtensionsRegistry.Zeta2ForgeCondition((IZetaCondition)new FlagCondition(Quark.ZETA.configManager.getConfigFlagManager(), flag, QUARK_FLAG, () -> false));
    }

    public static void verticalSlabRecipe(ItemLike slab, ItemLike verticalSlab, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VERTICAL_SLABS_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)verticalSlab, (int)3).m_126127_(Character.valueOf('S'), slab).m_126130_("S").m_126130_("S").m_126130_("S").m_126132_(COPRecipeProvider.m_176602_((ItemLike)slab), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)slab)).m_126140_(consumer1, CompatOPlenty.modLoc(COPRecipeProvider.m_176632_((ItemLike)verticalSlab)))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)verticalSlab)));
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VERTICAL_SLABS_FLAG)).addRecipe(consumer1 -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab).m_126209_(verticalSlab).m_126132_(COPRecipeProvider.m_176602_((ItemLike)verticalSlab), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)verticalSlab)).m_126140_(consumer1, CompatOPlenty.modLoc(COPRecipeProvider.m_176632_((ItemLike)verticalSlab) + "_revert"))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)verticalSlab) + "_revert"));
    }

    public static void verticalPlankRecipe(ItemLike plank, ItemLike verticalPlank, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VERTICAL_PLANKS_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)verticalPlank, (int)3).m_126127_(Character.valueOf('S'), plank).m_126130_("S").m_126130_("S").m_126130_("S").m_126132_(COPRecipeProvider.m_176602_((ItemLike)plank), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)plank)).m_126140_(consumer1, CompatOPlenty.modLoc(COPRecipeProvider.m_176632_((ItemLike)verticalPlank)))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)verticalPlank)));
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VERTICAL_PLANKS_FLAG)).addRecipe(consumer1 -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)plank).m_126209_(verticalPlank).m_126132_(COPRecipeProvider.m_176602_((ItemLike)verticalPlank), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)verticalPlank)).m_126140_(consumer1, CompatOPlenty.modLoc(COPRecipeProvider.m_176632_((ItemLike)verticalPlank) + "_revert"))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)verticalPlank) + "_revert"));
    }

    public static void boardsRecipe(ItemLike plank, ItemLike board, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenBoards, "wooden_boards", new HashMap(), false)))).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)board, (int)3).m_126127_(Character.valueOf('S'), plank).m_126130_("S").m_126130_("S").m_126130_("S").m_126132_(COPRecipeProvider.m_176602_((ItemLike)plank), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)plank)).m_126140_(consumer1, CompatOPlenty.modLoc(COPRecipeProvider.m_176632_((ItemLike)board)))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)board)));
    }

    public static void bookshelfRecipe(ItemLike plank, ItemLike bookshelf, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenBookshelves, "wooden_bookshelves", new HashMap(), false)))).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)bookshelf).m_126127_(Character.valueOf('#'), plank).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126130_("###").m_126130_("BBB").m_126130_("###").m_126132_(COPRecipeProvider.m_176602_((ItemLike)plank), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)plank)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)bookshelf) + "_woodworks"));
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VARIANT_BOOKSHELVES_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)bookshelf).m_126127_(Character.valueOf('#'), plank).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126130_("###").m_126130_("BBB").m_126130_("###").m_126132_(COPRecipeProvider.m_176602_((ItemLike)plank), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)plank)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)bookshelf) + "_quark"));
    }

    public static void ladderRecipe(ItemLike plank, ItemLike ladder, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenLadders, "wooden_ladders", new HashMap(), false)))).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladder, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('P'), plank).m_126130_("# #").m_126130_("#P#").m_126130_("# #").m_126132_(COPRecipeProvider.m_176602_((ItemLike)plank), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)plank)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)ladder) + "_woodworks"));
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VARIANT_LADDERS_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladder, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('P'), plank).m_126130_("# #").m_126130_("#P#").m_126130_("# #").m_126132_(COPRecipeProvider.m_176602_((ItemLike)plank), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)plank)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)ladder) + "_quark"));
    }

    public static void postRecipe(ItemLike wood, ItemLike post, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(WOODEN_POSTS_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)post, (int)8).m_126127_(Character.valueOf('#'), wood).m_126130_("#").m_126130_("#").m_126130_("#").m_126132_(COPRecipeProvider.m_176602_((ItemLike)wood), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)wood)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)post)));
    }

    public static void hedgeRecipe(TagKey<Item> log, ItemLike leaves, ItemLike hedge, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(HEDGES_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)hedge, (int)2).m_206416_(Character.valueOf('#'), log).m_126127_(Character.valueOf('L'), leaves).m_126130_("L").m_126130_("#").m_126132_(COPRecipeProvider.m_176602_((ItemLike)leaves), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)leaves)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)hedge)));
    }

    public static void leafCarpetRecipe(ItemLike leaves, ItemLike carpet, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(LEAF_CARPET_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)carpet, (int)3).m_126127_(Character.valueOf('#'), leaves).m_126130_("##").m_126132_(COPRecipeProvider.m_176602_((ItemLike)leaves), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)leaves)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)carpet)));
    }

    public static void leafPileRecipe(ItemLike leaves, ItemLike pile, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.leafPiles, "leaf_piles", new HashMap(), false)))).addRecipe(consumer1 -> ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)pile, (int)4).m_126209_(leaves).m_126145_("leaf_pile").m_126132_(COPRecipeProvider.m_176602_((ItemLike)leaves), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)leaves)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)pile)));
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.leafPiles, "leaf_piles", new HashMap(), false)))).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leaves, (int)1).m_126127_(Character.valueOf('#'), pile).m_126130_("##").m_126130_("##").m_126145_("leaves").m_126132_(COPRecipeProvider.m_176602_((ItemLike)pile), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)pile)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)leaves) + "_from_leaf_piles"));
    }

    public static void chestRecipes(ItemLike planks, TagKey<Item> log, RegistryObject<BlueprintChestBlock> chest, RegistryObject<BlueprintTrappedChestBlock> trappedChest, Consumer<FinishedRecipe> consumer) {
        Block normal = (Block)chest.get();
        Block trapped = (Block)trappedChest.get();
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenChests, "wooden_chests", new HashMap(), false)))).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)normal).m_126127_(Character.valueOf('#'), planks).m_126130_("###").m_126130_("# #").m_126130_("###").m_126132_(COPRecipeProvider.m_176602_((ItemLike)planks), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)planks)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)normal) + "_woodworks"));
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenChests, "wooden_chests", new HashMap(), false)))).addRecipe(consumer1 -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)trapped).m_126209_((ItemLike)normal).m_126209_((ItemLike)Items.f_42109_).m_126132_(COPRecipeProvider.m_176602_((ItemLike)normal), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)normal)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)trapped) + "_woodworks"));
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VARIANT_CHESTS_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)normal).m_126127_(Character.valueOf('#'), planks).m_126130_("###").m_126130_("# #").m_126130_("###").m_126132_(COPRecipeProvider.m_176602_((ItemLike)planks), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)planks)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)normal) + "_quark"));
        ConditionalRecipe.builder().addCondition((ICondition)new AndCondition(new ICondition[]{COPRecipeProvider.quarkCondition(WOOD_TO_CHEST_RECIPES_FLAG), COPRecipeProvider.quarkCondition(VARIANT_CHESTS_FLAG)})).addRecipe(consumer1 -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)normal, (int)4).m_206416_(Character.valueOf('#'), log).m_126130_("###").m_126130_("# #").m_126130_("###").m_126132_(COPRecipeProvider.m_176602_((ItemLike)normal), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)normal)).m_126140_(consumer1, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)normal) + "_bulk"))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)normal) + "_quark_bulk"));
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(VARIANT_CHESTS_FLAG)).addRecipe(consumer1 -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)trapped).m_126209_((ItemLike)normal).m_126209_((ItemLike)Items.f_42109_).m_126132_(COPRecipeProvider.m_176602_((ItemLike)normal), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)normal)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)trapped) + "_quark"));
    }

    public static void beehiveRecipe(ItemLike planks, ItemLike beehive, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new BlueprintAndCondition(List.of(new ModLoadedCondition("woodworks"), new ConfigValueCondition(new ResourceLocation("woodworks", "config"), (ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenBeehives, "wooden_beehives", new HashMap(), false)))).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)beehive).m_126127_(Character.valueOf('#'), planks).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42784_).m_126130_("###").m_126130_("HHH").m_126130_("###").m_126132_(COPRecipeProvider.m_176602_((ItemLike)planks), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)planks)).m_126140_(consumer1, new ResourceLocation("compat_o_plenty"))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)beehive)));
    }

    public static void cabinetRecipe(ItemLike slab, ItemLike trapdoor, ItemLike cabinet, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("farmersdelight")).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)cabinet).m_126127_(Character.valueOf('#'), slab).m_126127_(Character.valueOf('T'), trapdoor).m_126130_("###").m_126130_("T T").m_126130_("###").m_126132_(COPRecipeProvider.m_176602_((ItemLike)slab), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)slab)).m_126140_(consumer1, new ResourceLocation("compat_o_plenty"))).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)cabinet)));
    }

    public static void sandstoneStairsRecipe(ItemLike material, ItemLike stairs, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(SANDSTONE_BRICKS_FLAG)).addRecipe(consumer1 -> COPRecipeProvider.m_176710_((ItemLike)stairs, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)stairs)));
    }

    public static void galanosStairsRecipe(ItemLike material, ItemLike stairs, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(MIDORI_FLAG)).addRecipe(consumer1 -> COPRecipeProvider.m_176710_((ItemLike)stairs, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)stairs)));
    }

    public static void polishedRoseStairsRecipe(ItemLike material, ItemLike stairs, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("twigs")).addRecipe(consumer1 -> COPRecipeProvider.m_176710_((ItemLike)stairs, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)stairs)));
    }

    public static void sandstoneSlabRecipe(ItemLike material, ItemLike slab, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(SANDSTONE_BRICKS_FLAG)).addRecipe(consumer1 -> COPRecipeProvider.m_247552_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)slab)));
    }

    public static void galanosSlabRecipe(ItemLike material, ItemLike slab, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(MIDORI_FLAG)).addRecipe(consumer1 -> COPRecipeProvider.m_247552_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)slab)));
    }

    public static void polishedRoseSlabRecipe(ItemLike material, ItemLike slab, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("twigs")).addRecipe(consumer1 -> COPRecipeProvider.m_247552_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)slab)));
    }

    public static void sandstoneWallRecipe(ItemLike material, ItemLike wall, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(SANDSTONE_BRICKS_FLAG)).addRecipe(consumer1 -> COPRecipeProvider.m_245864_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wall, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)wall)));
    }

    public static void polishedRoseWallRecipe(ItemLike material, ItemLike wall, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("twigs")).addRecipe(consumer1 -> COPRecipeProvider.m_245864_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wall, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material})).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)wall)));
    }

    public static void polishedRoseRecipe(Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("twigs")).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get())).m_126127_(Character.valueOf('#'), (ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK).m_126130_("##").m_126130_("##").m_126132_(COPRecipeProvider.m_176602_((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)BOPBlocks.ROSE_QUARTZ_BLOCK)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)((ItemLike)COPBlocks.POLISHED_ROSE_QUARTZ.get()))));
    }

    public static void galanosRecipe(Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(MIDORI_FLAG)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)COPBlocks.GALANOS_BLOCK.get())).m_126127_(Character.valueOf('#'), (ItemLike)COPItems.GLOWING_MOSS_PASTE.get()).m_126130_("##").m_126130_("##").m_126132_(COPRecipeProvider.m_176602_((ItemLike)((ItemLike)COPItems.GLOWING_MOSS_PASTE.get())), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)((ItemLike)COPItems.GLOWING_MOSS_PASTE.get()))).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)((ItemLike)COPBlocks.GALANOS_BLOCK.get()))));
    }

    public static void tableRecipe(ItemLike slab, ItemLike fence, ItemLike table, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("twigs")).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)table).m_126127_(Character.valueOf('#'), slab).m_126127_(Character.valueOf('I'), fence).m_126130_("###").m_126130_("I I").m_126130_("I I").m_126132_(COPRecipeProvider.m_176602_((ItemLike)slab), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)slab)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)table)));
    }

    public static void chiseledBlockRecipe(ItemLike slab, ItemLike result, String modId, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(modId)).addRecipe(consumer1 -> ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).m_126127_(Character.valueOf('#'), slab).m_126130_("#").m_126130_("#").m_126132_(COPRecipeProvider.m_176602_((ItemLike)slab), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)slab)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("crafting/" + COPRecipeProvider.m_176632_((ItemLike)result)));
    }

    public static void quarkFlagStoneCutterRecipe(ItemLike material, ItemLike result, int amount, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(flag)).addRecipe(consumer1 -> SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)amount).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("stonecutting/" + COPRecipeProvider.m_176517_((ItemLike)result, (ItemLike)material)));
    }

    public static void modLoadedStoneCutterRecipe(ItemLike material, ItemLike result, int amount, String modId, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(modId)).addRecipe(consumer1 -> SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)amount).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("stonecutting/" + COPRecipeProvider.m_176517_((ItemLike)result, (ItemLike)material)));
    }

    public static void multiModStoneCutterRecipe(ItemLike material, ItemLike result, int amount, String modId, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(modId)).addCondition(COPRecipeProvider.quarkCondition(flag)).addRecipe(consumer1 -> SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)amount).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("stonecutting/" + COPRecipeProvider.m_176517_((ItemLike)result, (ItemLike)material)));
    }

    public static void flaggedFurnaceRecipe(ItemLike material, ItemLike result, float exp, String flag, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition(COPRecipeProvider.quarkCondition(flag)).addRecipe(consumer1 -> SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)exp, (int)200).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("smelting/" + COPRecipeProvider.m_176632_((ItemLike)result)));
    }

    public static void modLoadedFurnaceRecipe(ItemLike material, ItemLike result, float exp, String modId, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(modId)).addRecipe(consumer1 -> SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (float)exp, (int)200).m_126132_(COPRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)COPRecipeProvider.m_125977_((ItemLike)material)).m_176498_(consumer1)).build(consumer, CompatOPlenty.modLoc("smelting/" + COPRecipeProvider.m_176632_((ItemLike)result)));
    }

    public static void genericCuttingRecipe(ItemLike material, Ingredient tool, ItemLike result, int count, String soundId, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("farmersdelight")).addRecipe(consumer1 -> CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (Ingredient)tool, (ItemLike)result, (int)count).addSound(soundId).build(consumer1)).build(consumer, CompatOPlenty.modLoc("cutting/" + COPRecipeProvider.m_176632_((ItemLike)material)));
    }

    public static void stripLogCuttingRecipe(ItemLike log, ItemLike strippedLog, Consumer<FinishedRecipe> consumer) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition("farmersdelight")).addRecipe(consumer1 -> CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_STRIP), (ItemLike)strippedLog).addResult((ItemLike)ModItems.TREE_BARK.get()).addSound(ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_11688_).toString()).build(consumer1)).build(consumer, CompatOPlenty.modLoc("cutting/" + COPRecipeProvider.m_176632_((ItemLike)log)));
    }

    public static void dyeCuttingRecipe(ItemLike flower, ItemLike dye, Consumer<FinishedRecipe> consumer) {
        COPRecipeProvider.genericCuttingRecipe(flower, Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), dye, 2, ForgeRegistries.SOUND_EVENTS.getKey((Object)((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get())).toString(), consumer);
    }

    public static void furnitureSalvageCuttingRecipes(ItemLike plank, ItemLike door, ItemLike trapdoor, ItemLike sign, Consumer<FinishedRecipe> consumer) {
        COPRecipeProvider.genericCuttingRecipe(door, (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), plank, 1, ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_12630_).toString(), consumer);
        COPRecipeProvider.genericCuttingRecipe(sign, (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), plank, 1, ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_12630_).toString(), consumer);
        COPRecipeProvider.genericCuttingRecipe(trapdoor, (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), plank, 1, ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_12630_).toString(), consumer);
    }
}

