/*
 * Decompiled with CFR 0.152.
 */
package krelox.compat_o_plenty.core.data.client;

import biomesoplenty.api.block.BOPBlocks;
import com.ninni.twigs.TwigsProperties;
import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import java.util.function.Function;
import java.util.function.Supplier;
import krelox.compat_o_plenty.core.CompatOPlenty;
import krelox.compat_o_plenty.core.registry.COPBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.violetmoon.quark.content.building.block.HedgeBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import org.violetmoon.quark.content.building.block.WoodPostBlock;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class COPBlockStateProvider
extends BlueprintBlockStateProvider {
    public COPBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "compat_o_plenty", helper);
    }

    protected void registerStatesAndModels() {
        for (WoodType woodType : COPBlocks.WOOD_PROPERTIES.keySet()) {
            String materialName = woodType.f_61839_().replace("biomesoplenty:", "");
            Block leaves = CompatOPlenty.bopBlock(materialName + "_leaves").get();
            Block planks = CompatOPlenty.bopBlock(materialName + "_planks").get();
            Block log = CompatOPlenty.bopBlock(materialName + "_log").get();
            this.boardsBlock(COPBlocks.BOARDS.get(woodType));
            this.leafPileBlock(leaves, COPBlocks.LEAF_PILES.get(woodType));
            this.ladderBlock(COPBlocks.LADDERS.get(woodType));
            this.beehiveBlock(COPBlocks.BEEHIVES.get(woodType));
            this.bookshelfBlock(planks, COPBlocks.BOOKSHELVES.get(woodType));
            this.chestBlocks(planks, COPBlocks.CHESTS.get(woodType), COPBlocks.TRAPPED_CHESTS.get(woodType));
            this.cabinetBlock((Supplier)COPBlocks.CABINETS.get(woodType));
            this.tableBlock(planks, (Supplier)COPBlocks.TABLES.get(woodType));
            this.hollowLogBlock(log, (Supplier)COPBlocks.HOLLOW_LOGS.get(woodType));
            this.verticalPlanksBlock(planks, (Supplier)COPBlocks.VERTICAL_PLANKS.get(woodType));
            this.leafCarpetBlock(leaves, (Supplier)COPBlocks.LEAF_CARPETS.get(woodType));
            this.hedgeBlock(leaves, log, (Supplier)COPBlocks.HEDGES.get(woodType));
            this.verticalSlabBlock(planks, (Supplier)COPBlocks.VERTICAL_SLABS.get(woodType));
            this.woodPostBlock(log, (Supplier)COPBlocks.POSTS.get(woodType));
            this.woodPostBlock(CompatOPlenty.bopBlock("stripped_" + materialName + "_log").get(), (Supplier)COPBlocks.STRIPPED_POSTS.get(woodType));
        }
        this.verticalSlabBlock(BOPBlocks.WHITE_SANDSTONE, (Supplier<Block>)COPBlocks.WHITE_SANDSTONE_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.CUT_WHITE_SANDSTONE, (Supplier<Block>)COPBlocks.CUT_WHITE_SANDSTONE_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.SMOOTH_WHITE_SANDSTONE, (Supplier<Block>)COPBlocks.SMOOTH_WHITE_SANDSTONE_VERTICAL_SLAB);
        this.baseBlocks(COPBlocks.WHITE_SANDSTONE_BRICKS, COPBlocks.WHITE_SANDSTONE_BRICK_STAIRS, COPBlocks.WHITE_SANDSTONE_BRICK_SLAB, COPBlocks.WHITE_SANDSTONE_BRICK_WALL);
        this.verticalSlabBlock((Block)COPBlocks.WHITE_SANDSTONE_BRICKS.get(), (Supplier<Block>)COPBlocks.WHITE_SANDSTONE_BRICK_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.ORANGE_SANDSTONE, (Supplier<Block>)COPBlocks.ORANGE_SANDSTONE_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.CUT_ORANGE_SANDSTONE, (Supplier<Block>)COPBlocks.CUT_ORANGE_SANDSTONE_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.SMOOTH_ORANGE_SANDSTONE, (Supplier<Block>)COPBlocks.SMOOTH_ORANGE_SANDSTONE_VERTICAL_SLAB);
        this.baseBlocks(COPBlocks.ORANGE_SANDSTONE_BRICKS, COPBlocks.ORANGE_SANDSTONE_BRICK_STAIRS, COPBlocks.ORANGE_SANDSTONE_BRICK_SLAB, COPBlocks.ORANGE_SANDSTONE_BRICK_WALL);
        this.verticalSlabBlock((Block)COPBlocks.ORANGE_SANDSTONE_BRICKS.get(), (Supplier<Block>)COPBlocks.ORANGE_SANDSTONE_BRICK_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.BLACK_SANDSTONE, (Supplier<Block>)COPBlocks.BLACK_SANDSTONE_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.CUT_BLACK_SANDSTONE, (Supplier<Block>)COPBlocks.CUT_BLACK_SANDSTONE_VERTICAL_SLAB);
        this.verticalSlabBlock(BOPBlocks.SMOOTH_BLACK_SANDSTONE, (Supplier<Block>)COPBlocks.SMOOTH_BLACK_SANDSTONE_VERTICAL_SLAB);
        this.baseBlocks(COPBlocks.BLACK_SANDSTONE_BRICKS, COPBlocks.BLACK_SANDSTONE_BRICK_STAIRS, COPBlocks.BLACK_SANDSTONE_BRICK_SLAB, COPBlocks.BLACK_SANDSTONE_BRICK_WALL);
        this.verticalSlabBlock((Block)COPBlocks.BLACK_SANDSTONE_BRICKS.get(), (Supplier<Block>)COPBlocks.BLACK_SANDSTONE_BRICK_VERTICAL_SLAB);
        this.block((Block)COPBlocks.GALANOS_BLOCK.get());
        this.logBlock((RotatedPillarBlock)COPBlocks.GALANOS_PILLAR.get());
        this.blockItem(COPBlocks.GALANOS_PILLAR);
        this.stairsBlock((Block)COPBlocks.GALANOS_BLOCK.get(), (Block)COPBlocks.GALANOS_STAIRS.get());
        this.slabBlock((Block)COPBlocks.GALANOS_BLOCK.get(), (Block)COPBlocks.GALANOS_SLAB.get());
        this.verticalSlabBlock((Block)COPBlocks.GALANOS_BLOCK.get(), (Supplier<Block>)COPBlocks.GALANOS_VERTICAL_SLAB);
        this.baseBlocks(COPBlocks.POLISHED_ROSE_QUARTZ, COPBlocks.POLISHED_ROSE_QUARTZ_STAIRS, COPBlocks.POLISHED_ROSE_QUARTZ_SLAB);
        this.verticalSlabBlock((Block)COPBlocks.POLISHED_ROSE_QUARTZ.get(), (Supplier<Block>)COPBlocks.POLISHED_ROSE_QUARTZ_VERTICAL_SLAB);
        this.baseBlocks(COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS, COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_STAIRS, COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_SLAB, COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_WALL);
        this.verticalSlabBlock((Block)COPBlocks.POLISHED_ROSE_QUARTZ_BRICKS.get(), (Supplier<Block>)COPBlocks.POLISHED_ROSE_QUARTZ_BRICK_VERTICAL_SLAB);
        this.block(COPBlocks.CRACKED_POLISHED_ROSE_QUARTZ_BRICKS);
        this.block(COPBlocks.CHISELED_POLISHED_ROSE_QUARTZ);
        this.leafPileBlock(BOPBlocks.ORIGIN_LEAVES, COPBlocks.ORIGIN_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.ORIGIN_LEAVES, (Supplier<Block>)COPBlocks.ORIGIN_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.ORIGIN_LEAVES, Blocks.f_49999_, (Supplier<Block>)COPBlocks.ORIGIN_HEDGE);
        this.leafPileBlock(BOPBlocks.FLOWERING_OAK_LEAVES, COPBlocks.FLOWERING_OAK_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.FLOWERING_OAK_LEAVES, (Supplier<Block>)COPBlocks.FLOWERING_OAK_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.FLOWERING_OAK_LEAVES, Blocks.f_49999_, (Supplier<Block>)COPBlocks.FLOWERING_OAK_HEDGE);
        this.leafPileBlock(BOPBlocks.RAINBOW_BIRCH_LEAVES, COPBlocks.RAINBOW_BIRCH_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.RAINBOW_BIRCH_LEAVES, (Supplier<Block>)COPBlocks.RAINBOW_BIRCH_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.RAINBOW_BIRCH_LEAVES, Blocks.f_50001_, (Supplier<Block>)COPBlocks.RAINBOW_BIRCH_HEDGE);
        this.leafPileBlock(BOPBlocks.CYPRESS_LEAVES, COPBlocks.CYPRESS_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.CYPRESS_LEAVES, (Supplier<Block>)COPBlocks.CYPRESS_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.CYPRESS_LEAVES, Blocks.f_49999_, (Supplier<Block>)COPBlocks.CYPRESS_HEDGE);
        this.leafPileBlock(BOPBlocks.SNOWBLOSSOM_LEAVES, COPBlocks.SNOWBLOSSOM_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.SNOWBLOSSOM_LEAVES, (Supplier<Block>)COPBlocks.SNOWBLOSSOM_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.SNOWBLOSSOM_LEAVES, Blocks.f_49999_, (Supplier<Block>)COPBlocks.SNOWBLOSSOM_HEDGE);
        this.leafPileBlock(BOPBlocks.RED_MAPLE_LEAVES, COPBlocks.RED_MAPLE_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.RED_MAPLE_LEAVES, (Supplier<Block>)COPBlocks.RED_MAPLE_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.RED_MAPLE_LEAVES, Blocks.f_49999_, (Supplier<Block>)COPBlocks.RED_MAPLE_HEDGE);
        this.leafPileBlock(BOPBlocks.ORANGE_MAPLE_LEAVES, COPBlocks.ORANGE_MAPLE_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.ORANGE_MAPLE_LEAVES, (Supplier<Block>)COPBlocks.ORANGE_MAPLE_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.ORANGE_MAPLE_LEAVES, Blocks.f_50004_, (Supplier<Block>)COPBlocks.ORANGE_MAPLE_HEDGE);
        this.leafPileBlock(BOPBlocks.YELLOW_MAPLE_LEAVES, COPBlocks.YELLOW_MAPLE_LEAF_PILE);
        this.leafCarpetBlock(BOPBlocks.YELLOW_MAPLE_LEAVES, (Supplier<Block>)COPBlocks.YELLOW_MAPLE_LEAF_CARPET);
        this.hedgeBlock(BOPBlocks.YELLOW_MAPLE_LEAVES, Blocks.f_50001_, (Supplier<Block>)COPBlocks.YELLOW_MAPLE_HEDGE);
    }

    public void cabinetBlock(Supplier<Block> cabinet) {
        Block cabinetBlock = cabinet.get();
        this.horizontalBlock(cabinetBlock, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(COPBlockStateProvider.name((Block)cabinetBlock) + suffix, this.blockTexture(cabinetBlock).m_266382_("_side"), this.blockTexture(cabinetBlock).m_266382_("_front" + suffix), this.blockTexture(cabinetBlock).m_266382_("_top"));
        });
        this.blockItem(cabinetBlock);
    }

    public void tableBlock(Block planks, Supplier<Block> table) {
        Block tableBlock = table.get();
        Function<String, ModelFile> model = suffix -> ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(COPBlockStateProvider.name((Block)tableBlock) + suffix, "twigs:block/template_table" + suffix)).texture("side", this.blockTexture(tableBlock))).texture("bottom", this.blockTexture(tableBlock).m_266382_("_bottom"))).texture("top", this.blockTexture(tableBlock).m_266382_("_top"))).texture("particle", this.blockTexture(planks));
        ModelFile tableLeg = model.apply("_leg");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(tableBlock).part().modelFile(model.apply("_top")).addModel()).end().part().modelFile(tableLeg).addModel()).condition((Property)TwigsProperties.TABLE_LEG1, (Comparable[])new Boolean[]{true}).end().part().modelFile(tableLeg).rotationY(90).addModel()).condition((Property)TwigsProperties.TABLE_LEG2, (Comparable[])new Boolean[]{true}).end().part().modelFile(tableLeg).rotationY(180).addModel()).condition((Property)TwigsProperties.TABLE_LEG3, (Comparable[])new Boolean[]{true}).end().part().modelFile(tableLeg).rotationY(270).addModel()).condition((Property)TwigsProperties.TABLE_LEG4, (Comparable[])new Boolean[]{true}).end();
        this.simpleBlockItem(tableBlock, model.apply("_inventory"));
    }

    public void hollowLogBlock(Block log, Supplier<Block> hollowLog) {
        Block block = hollowLog.get();
        if (block instanceof RotatedPillarBlock) {
            RotatedPillarBlock hollowLogBlock = (RotatedPillarBlock)block;
            ResourceLocation logLoc = this.blockTexture(log);
            Function<String, ModelFile> model = suffix -> ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(COPBlockStateProvider.name((Block)hollowLogBlock) + suffix, "quark:block/hollow_log" + suffix)).texture("end", logLoc.m_266382_("_top"))).texture("side", logLoc)).texture("inside", logLoc.toString().replace("block/", "block/stripped_"));
            this.axisBlock(hollowLogBlock, model.apply(""), model.apply("_horizontal"));
            this.blockItem((Block)hollowLogBlock);
        }
    }

    public void verticalPlanksBlock(Block planks, Supplier<Block> verticalPlanks) {
        this.simpleBlockWithItem(verticalPlanks.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(COPBlockStateProvider.name((Block)verticalPlanks.get()), "quark:block/vertical_planks")).texture("all", this.blockTexture(planks)));
    }

    public void leafCarpetBlock(Block leaves, Supplier<Block> leafCarpet) {
        this.simpleBlockWithItem(leafCarpet.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(COPBlockStateProvider.name((Block)leafCarpet.get()), "quark:block/leaf_carpet")).texture("all", this.blockTexture(leaves)));
    }

    public void hedgeBlock(Block leaves, Block log, Supplier<Block> hedge) {
        String name = COPBlockStateProvider.name((Block)hedge.get());
        ResourceLocation leavesLoc = this.blockTexture(leaves);
        ModelBuilder hedgePost = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_post", "quark:block/hedge_post")).texture("log", this.blockTexture(log))).texture("leaf", leavesLoc);
        ModelBuilder hedgeExtend = ((BlockModelBuilder)this.models().withExistingParent(name + "_extend", "quark:block/hedge_extend")).texture("leaf", leavesLoc);
        ModelBuilder hedgeSide = ((BlockModelBuilder)this.models().withExistingParent(name + "_side", "quark:block/hedge_side")).texture("leaf", leavesLoc);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(hedge.get()).part().modelFile((ModelFile)hedgePost).addModel()).condition((Property)HedgeBlock.EXTEND, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)hedgeExtend).addModel()).condition((Property)HedgeBlock.EXTEND, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)hedgeSide).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)hedgeSide).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)hedgeSide).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)hedgeSide).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
        this.simpleBlockItem(hedge.get(), (ModelFile)hedgePost);
    }

    public void verticalSlabBlock(Block block, Supplier<Block> verticalSlab) {
        ResourceLocation blockLoc = this.blockTexture(block);
        ModelBuilder verticalSlabModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(COPBlockStateProvider.name((Block)verticalSlab.get()), "quark:block/vertical_slab")).texture("bottom", blockLoc)).texture("top", blockLoc)).texture("side", blockLoc);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(verticalSlab.get()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.NORTH).modelForState().modelFile((ModelFile)verticalSlabModel).rotationY(0).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.EAST).modelForState().modelFile((ModelFile)verticalSlabModel).rotationY(90).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.SOUTH).modelForState().modelFile((ModelFile)verticalSlabModel).rotationY(180).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.WEST).modelForState().modelFile((ModelFile)verticalSlabModel).rotationY(270).uvLock(true).addModel()).partialState().with((Property)VerticalSlabBlock.TYPE, (Comparable)VerticalSlabBlock.VerticalSlabType.DOUBLE).modelForState().modelFile((ModelFile)this.models().getExistingFile(blockLoc)).addModel();
        this.blockItem(verticalSlab.get());
    }

    public void woodPostBlock(Block log, Supplier<Block> post) {
        String materialName = COPBlockStateProvider.name((Block)post.get()).replace("_post", "");
        ResourceLocation logLoc = this.blockTexture(log);
        ModelBuilder postModel = ((BlockModelBuilder)this.models().withExistingParent(materialName + "_post", "quark:block/post")).texture("texture", logLoc);
        ModelFile.ExistingModelFile chainSmall = this.models().getExistingFile(this.mcLoc("quark:block/chain_small"));
        ModelFile.ExistingModelFile chainSmallTop = this.models().getExistingFile(this.mcLoc("quark:block/chain_small_top"));
        ModelBuilder postConnect = ((BlockModelBuilder)this.models().withExistingParent("block/" + materialName + "_post_connect", "quark:block/post_connect")).texture("texture", logLoc);
        ModelBuilder postConnectTop = ((BlockModelBuilder)this.models().withExistingParent("block/" + materialName + "_post_connect_top", "quark:block/post_connect_top")).texture("texture", logLoc);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(post.get()).part().modelFile((ModelFile)postModel).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile((ModelFile)postModel).rotationX(90).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile((ModelFile)postModel).rotationX(90).addModel()).condition((Property)BlockStateProperties.f_61365_, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end().part().modelFile((ModelFile)chainSmall).addModel()).condition((Property)WoodPostBlock.SIDES[0], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.CHAIN}).end().part().modelFile((ModelFile)chainSmallTop).addModel()).condition((Property)WoodPostBlock.SIDES[1], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.CHAIN}).end().part().modelFile((ModelFile)chainSmallTop).rotationX(90).addModel()).condition((Property)WoodPostBlock.SIDES[2], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.CHAIN}).end().part().modelFile((ModelFile)chainSmall).rotationX(90).addModel()).condition((Property)WoodPostBlock.SIDES[3], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.CHAIN}).end().part().modelFile((ModelFile)chainSmall).rotationX(90).rotationY(90).addModel()).condition((Property)WoodPostBlock.SIDES[4], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.CHAIN}).end().part().modelFile((ModelFile)chainSmallTop).rotationX(90).rotationY(90).addModel()).condition((Property)WoodPostBlock.SIDES[5], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.CHAIN}).end().part().modelFile((ModelFile)postConnect).addModel()).condition((Property)WoodPostBlock.SIDES[0], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.OTHER_POST}).end().part().modelFile((ModelFile)postConnectTop).addModel()).condition((Property)WoodPostBlock.SIDES[1], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.OTHER_POST}).end().part().modelFile((ModelFile)postConnectTop).rotationX(90).addModel()).condition((Property)WoodPostBlock.SIDES[2], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.OTHER_POST}).end().part().modelFile((ModelFile)postConnect).rotationX(90).addModel()).condition((Property)WoodPostBlock.SIDES[3], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.OTHER_POST}).end().part().modelFile((ModelFile)postConnect).rotationX(90).rotationY(90).addModel()).condition((Property)WoodPostBlock.SIDES[4], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.OTHER_POST}).end().part().modelFile((ModelFile)postConnectTop).rotationX(90).rotationY(90).addModel()).condition((Property)WoodPostBlock.SIDES[5], (Comparable[])new WoodPostBlock.PostSideType[]{WoodPostBlock.PostSideType.OTHER_POST}).end();
        this.simpleBlockItem(post.get(), (ModelFile)postModel);
    }
}

