/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.other;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;

public class IcicleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public IcicleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return IcicleBlock.isValidPointedDripstonePlacement(level, pos, (Direction)state.m_61143_((Property)TIP_DIRECTION));
    }

    public BlockState m_7417_(BlockState state1, Direction direction, BlockState state, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        if (((Boolean)state1.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state1;
        }
        Direction direction1 = (Direction)state1.m_61143_((Property)TIP_DIRECTION);
        if (direction1 == Direction.DOWN && level.m_183326_().m_183582_(pos, (Object)this)) {
            return state1;
        }
        if (direction == direction1.m_122424_() && !this.m_7898_(state1, (LevelReader)level, pos)) {
            if (direction1 == Direction.DOWN) {
                level.m_186460_(pos, (Block)this, 2);
            } else {
                level.m_186460_(pos, (Block)this, 1);
            }
            return state1;
        }
        boolean flag = state1.m_61143_(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = IcicleBlock.calculateDripstoneThickness((LevelReader)level, pos, direction1, flag);
        return (BlockState)state1.m_61124_(THICKNESS, (Comparable)dripstonethickness);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        BlockPos blockpos = hitResult.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && projectile instanceof ThrownTrident && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockpos, true);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float v) {
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP && state.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            entity.m_142535_(v + 2.0f, 2.0f, level.m_269111_().m_269571_());
        } else {
            super.m_142072_(level, state, pos, entity, v);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float f;
        if (IcicleBlock.canDrip(state) && !((f = random.m_188501_()) > 0.12f)) {
            IcicleBlock.getFluidAboveStalactite(level, pos, state).filter(p_221848_ -> f < 0.02f || IcicleBlock.canFillCauldron(p_221848_.fluid)).ifPresent(p_221881_ -> IcicleBlock.spawnDripParticle(level, pos, state, p_221881_.fluid));
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = context.m_43725_();
        Direction direction1 = IcicleBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = context.m_8083_(), direction = context.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !context.m_7078_();
        DripstoneThickness dripstonethickness = IcicleBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction1)).m_61124_(THICKNESS, (Comparable)dripstonethickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (state.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.m_60824_(getter, pos);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    public float m_142740_() {
        return 0.125f;
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state, Fluid fluid) {
        Vec3 vec3 = state.m_60824_((BlockGetter)level, pos);
        double d0 = 0.0625;
        double d1 = (double)pos.m_123341_() + 0.5 + vec3.f_82479_;
        double d2 = (double)((float)(pos.m_123342_() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.m_123343_() + 0.5 + vec3.f_82481_;
        Fluid fluid1 = IcicleBlock.getDripFluid(level, fluid);
        SimpleParticleType particleoptions = fluid1.m_205067_(FluidTags.f_13132_) ? ParticleTypes.f_175822_ : ParticleTypes.f_175824_;
        level.m_7106_((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction direction) {
        Direction direction1;
        if (IcicleBlock.isValidPointedDripstonePlacement(level, pos, direction)) {
            direction1 = direction;
        } else {
            if (!IcicleBlock.isValidPointedDripstonePlacement(level, pos, direction.m_122424_())) {
                return null;
            }
            direction1 = direction.m_122424_();
        }
        return direction1;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction direction, boolean bool) {
        Direction direction1 = direction.m_122424_();
        BlockState blockState = level.m_8055_(pos.m_121945_(direction));
        if (IcicleBlock.isPointedDripstoneWithDirection(blockState, direction1)) {
            return !bool && blockState.m_61143_(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!IcicleBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockState.m_61143_(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = level.m_8055_(pos.m_121945_(direction1));
            return !IcicleBlock.isPointedDripstoneWithDirection(blockstate1, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return IcicleBlock.isStalactite(state) && state.m_61143_(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    private static Optional<BlockPos> findRootBlock(Level level, BlockPos pos, BlockState state, int i) {
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (pos1, state1) -> state1.m_60713_((Block)RuBlocks.ICICLE.get()) && state1.m_61143_((Property)TIP_DIRECTION) == direction;
        return IcicleBlock.findBlockVertical((LevelAccessor)level, pos, direction.m_122424_().m_122421_(), bipredicate, state1 -> !state1.m_60713_((Block)RuBlocks.ICICLE.get()), i);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)level, blockpos, direction) || blockstate.m_204336_(BlockTags.f_13035_) || IcicleBlock.isPointedDripstoneWithDirection(blockstate, direction);
    }

    private static boolean isStalactite(BlockState state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return IcicleBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction direction) {
        return state.m_60713_((Block)RuBlocks.ICICLE.get()) && state.m_61143_((Property)TIP_DIRECTION) == direction;
    }

    private static Optional<FluidInfo> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !IcicleBlock.isStalactite(state) ? Optional.empty() : IcicleBlock.findRootBlock(level, pos, state, 11).map(pos1 -> {
            BlockPos blockpos = pos1.m_7494_();
            BlockState blockstate = level.m_8055_(blockpos);
            Object fluid = blockstate.m_60713_(Blocks.f_220864_) && !level.m_6042_().f_63857_() ? Fluids.f_76193_ : level.m_6425_(blockpos).m_76152_();
            return new FluidInfo(blockpos, (Fluid)fluid, blockstate);
        });
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.f_76195_ || fluid == Fluids.f_76193_;
    }

    private static Fluid getDripFluid(Level level, Fluid fluid) {
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return level.m_6042_().f_63857_() ? Fluids.f_76195_ : Fluids.f_76193_;
        }
        return fluid;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BiPredicate<BlockPos, BlockState> biPredicate, Predicate<BlockState> statePredicate, int a) {
        Direction direction1 = Direction.m_122390_((Direction.AxisDirection)direction, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockPos = pos.m_122032_();
        for (int i = 1; i < a; ++i) {
            blockPos.m_122173_(direction1);
            BlockState blockstate = level.m_8055_((BlockPos)blockPos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockPos.m_7949_());
            }
            if (!level.m_151562_(blockPos.m_123342_()) && biPredicate.test((BlockPos)blockPos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    record FluidInfo(BlockPos pos, Fluid fluid, BlockState state) {
    }
}

