/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuAquaticPlacements;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class AquaticBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseIslandSpawning(boolean isTropical) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        if (isTropical) {
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
            spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2));
            spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 2, 1, 1));
        }
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static MobSpawnSettings.Builder baseOceanSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126740_((MobSpawnSettings.Builder)spawnBuilder, (int)3, (int)4, (int)15);
        return spawnBuilder;
    }

    private static MobSpawnSettings.Builder baseRiverSpawning(boolean moreDrowned) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 2, 1, 4));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        if (moreDrowned) {
            spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 100, 1, 1));
        } else {
            spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 1, 1, 1));
        }
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseOceanGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126840_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseRiverGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195221_);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseIslandGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean isTropical) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (isTropical) {
            BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_198933_((BiomeGenerationSettings.Builder)biomeBuilder);
            BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)biomeBuilder);
        }
        return biomeBuilder;
    }

    public static Biome alphaGrove(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AquaticBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(1857757).m_48037_(4485074).m_48043_(6028091).m_48045_(8901207).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283788_));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ALPHA_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ALPHA_DANDELION);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ALPHA_ROSE);
        MobSpawnSettings.Builder spawnBuilder = AquaticBiomes.baseIslandSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.6f).m_47611_(0.6f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome coldRiver(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AquaticBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-5718172).m_48045_(-4733087).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283788_));
        BiomeGenerationSettings.Builder biomeBuilder = AquaticBiomes.baseRiverGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.ROCK_ON_GRAVEL);
        MobSpawnSettings.Builder spawnBuilder = AquaticBiomes.baseRiverSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.4f).m_47611_(0.7f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome hyacinthDeeps(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AquaticBiomes.calculateSkyColor(0.0f)).m_48019_(12638463).m_48034_(3770057).m_48037_(336179).m_48043_(-8275350).m_48045_(-9782677).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184220_));
        BiomeGenerationSettings.Builder biomeBuilder = AquaticBiomes.baseOceanGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195219_);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, RuAquaticPlacements.HYACINTH_ROCKS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.TALL_HYACINTH_STOCK);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.HYACINTH_PLANTS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.HYACINTH_FLOWERS);
        MobSpawnSettings.Builder spawnBuilder = AquaticBiomes.baseOceanSpawning();
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.5f).m_47611_(0.5f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome muddyRiver(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AquaticBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(-12619852).m_48037_(7436392).m_48043_(-7159980).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283788_));
        BiomeGenerationSettings.Builder biomeBuilder = AquaticBiomes.baseRiverGeneration(featureGetter, carverGetter);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.CATTAIL_RIVER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_GRASS);
        MobSpawnSettings.Builder spawnBuilder = AquaticBiomes.baseRiverSpawning(true);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.75f).m_47611_(0.7f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome tropicalRiver(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AquaticBiomes.calculateSkyColor(1.0f)).m_48019_(12638463).m_48034_(2202835).m_48037_(677798).m_48043_(4237620).m_48045_(6798388).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283788_));
        BiomeGenerationSettings.Builder biomeBuilder = AquaticBiomes.baseRiverGeneration(featureGetter, carverGetter);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PALM_TREE_ON_SAND);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.FERNS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.TALL_GRASS);
        MobSpawnSettings.Builder spawnBuilder = AquaticBiomes.baseRiverSpawning(false);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20490_, 5, 1, 1));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8));
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.75f).m_47611_(0.7f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome rockyReef(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AquaticBiomes.calculateSkyColor(1.0f)).m_48019_(12638463).m_48034_(-13255466).m_48037_(-11171160).m_48043_(-11617740).m_48045_(-11225797).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184220_));
        BiomeGenerationSettings.Builder biomeBuilder = AquaticBiomes.baseOceanGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195218_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195227_);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, RuAquaticPlacements.MOSSY_SEA_ROCKS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.BLUE_MAGNOLIA_FLOWERS_AQUATIC);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.PINK_MAGNOLIA_FLOWERS_AQUATIC);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.WHITE_MAGNOLIA_FLOWERS_AQUATIC);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.PALM_SAPLING_AQUATIC);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.ELEPHANT_EAR_AQUATIC);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.JUNGLE_TREE_AQUATIC);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuAquaticPlacements.PALM_TREE_AQUATIC);
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 1, 1, 3)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8)).m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20559_, 2, 1, 2));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.8f).m_47611_(0.5f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome ashenWoodland(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(11644572).m_48019_(-6384241).m_48034_(-10073800).m_48037_(-11585236).m_48043_(15326658).m_48045_(12434605).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.05f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283788_));
        BiomeGenerationSettings.Builder biomeBuilder = AquaticBiomes.baseIslandGeneration(featureGetter, carverGetter, false);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.SMOULDERING_DIRT);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ASHEN_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ASHEN_PINE_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.WILTING_TRILLIUM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ASHEN_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ASHEN_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 100, 4, 4));
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawnBuilder);
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome tropics(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(AquaticBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(-13255466).m_48037_(-11171160).m_48043_(-11617740).m_48045_(-11225797).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_283786_));
        BiomeGenerationSettings.Builder biomeBuilder = AquaticBiomes.baseIslandGeneration(featureGetter, carverGetter, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PALM_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PALM_TREE_SHRUB);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.JUNGLE_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIG_JUNGLE_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_WITH_FLOWERS_SPARSE);
        RuBiomeDefaultFeatures.addHibiscus(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.ELEPHANT_EAR_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PALM_JUNGLE_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = AquaticBiomes.baseIslandSpawning(true);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.05f).m_47611_(0.95f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }
}

