/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.api.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;

public class Food {
    private final int hunger;
    private final float saturationModifier;
    private final List<MobEffectInstance> effect = new ArrayList<MobEffectInstance>();
    private float effectChance;
    private boolean meat = false;
    private boolean snack = false;
    private boolean alwaysEdible = false;

    public Food(int hunger, float saturationModifier) {
        this.hunger = hunger;
        this.saturationModifier = saturationModifier;
    }

    public Food addEffect(MobEffect effect, int effectDurationInTicks, float chance) {
        this.effect.add(new MobEffectInstance(effect, effectDurationInTicks));
        this.effectChance = chance;
        return this;
    }

    public Food isMeat() {
        this.meat = true;
        return this;
    }

    public Food isSnack() {
        this.snack = true;
        return this;
    }

    public Food alwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }

    public FoodProperties createComponent() {
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(this.hunger).m_38758_(this.saturationModifier);
        for (MobEffectInstance me : this.effect) {
            builder.m_38762_(me, this.effectChance);
        }
        if (this.meat) {
            builder.m_38757_();
        }
        if (this.snack) {
            builder.m_38766_();
        }
        if (this.alwaysEdible) {
            builder.m_38765_();
        }
        return builder.m_38767_();
    }

    public Item asItem() {
        return new Item(new Item.Properties().m_41489_(this.createComponent()));
    }
}

