/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.oculus_for_simpleclouds.mixin;

import java.util.Locale;
import net.irisshaders.iris.gui.element.ShaderPackSelectionList;
import net.irisshaders.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderPackScreen.class}, remap=false)
public abstract class ShaderPackScreenMixin {
    @Shadow
    private ShaderPackSelectionList shaderPackList;
    @Unique
    private boolean ocs$skipUnsupportedShaderPrompt;

    @Inject(method={"applyChanges"}, at={@At(value="HEAD")}, cancellable=true)
    private void ocs$warnUnsupportedShader(CallbackInfo ci) {
        if (this.ocs$skipUnsupportedShaderPrompt) {
            this.ocs$skipUnsupportedShaderPrompt = false;
            return;
        }
        ShaderPackSelectionList.BaseEntry selected = (ShaderPackSelectionList.BaseEntry)this.shaderPackList.m_93511_();
        if (!(selected instanceof ShaderPackSelectionList.ShaderPackEntry)) {
            return;
        }
        ShaderPackSelectionList.ShaderPackEntry entry = (ShaderPackSelectionList.ShaderPackEntry)selected;
        String packName = entry.getPackName();
        if (packName == null || packName.isBlank() || this.ocs$isAtmosphericPack(packName)) {
            return;
        }
        ShaderPackScreen self = (ShaderPackScreen)this;
        Minecraft client = Minecraft.m_91087_();
        client.m_91152_((Screen)new ConfirmScreen(accepted -> {
            client.m_91152_((Screen)self);
            if (accepted) {
                this.ocs$skipUnsupportedShaderPrompt = true;
                self.applyChanges();
            }
        }, (Component)Component.m_237113_((String)"Unsupported shader selected"), (Component)Component.m_237113_((String)"You have selected a shader that is not supported. Only Atmospheric Shaders is compatible. Any other shader will behave exactly as if shaders were enabled without Oculus for Simple Clouds. By choosing Yes, you accept that visual issues will occur and agree not to report them since you are intentionally using an unsupported shader."), (Component)Component.m_237113_((String)"Yes"), (Component)Component.m_237113_((String)"No")));
    }

    @Unique
    private boolean ocs$isAtmosphericPack(String packName) {
        return packName.toLowerCase(Locale.ROOT).contains("atmosphericshaders");
    }
}

