/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.oculus_for_simpleclouds.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import dev.nonamecrackers2.simpleclouds.client.renderer.SimpleCloudsRenderer;
import dev.nonamecrackers2.simpleclouds.mixin.MixinRenderTargetAccessor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nonamecrackers2.crackerslib.common.compat.CompatHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

@Mod.EventBusSubscriber(modid="oculus_for_simpleclouds", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class FinalCloudCompositeHandler {
    private static int compositeProgram = -1;
    private static int compositeVao = -1;
    private static int compositeVbo = -1;
    private static int locCloudColor = -1;
    private static int locCloudDepth = -1;
    private static int locSceneDepth = -1;
    private static int locDepthBias = -1;
    private static int locReverseDepth = -1;
    private static int externalSceneDepthTex = -1;
    private static int capturedSceneDepthTex = -1;
    private static int captureFbo = -1;
    private static int capturedW = -1;
    private static int capturedH = -1;
    private static long lastDepthLogMs = 0L;
    private static boolean capturedThisFrame = false;
    private static boolean reverseDepthDetected = false;

    private FinalCloudCompositeHandler() {
    }

    @SubscribeEvent
    public static void onRenderStage(RenderLevelStageEvent event) {
        if (CompatHelper.areShadersRunning() && event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            FinalCloudCompositeHandler.compositeClouds();
            capturedThisFrame = false;
        }
    }

    public static void captureDepth(RenderTarget source) {
        if (source != null) {
            int w = source.f_83915_;
            int h = source.f_83916_;
            FinalCloudCompositeHandler.ensureSceneDepthTarget(w, h);
            int prevReadFbo = GL11.glGetInteger((int)36010);
            int prevDrawFbo = GL11.glGetInteger((int)36006);
            int sourceFbo = ((MixinRenderTargetAccessor)source).simpleclouds$getFrameBufferId();
            if (sourceFbo > 0 && capturedSceneDepthTex > 0 && captureFbo > 0) {
                int depthName;
                GL30.glBindFramebuffer((int)36160, (int)sourceFbo);
                int attachmentType = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36048);
                if (attachmentType == 5890 && (depthName = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36049)) > 0) {
                    externalSceneDepthTex = depthName;
                    capturedW = w;
                    capturedH = h;
                    capturedThisFrame = true;
                    GL30.glBindFramebuffer((int)36160, (int)prevReadFbo);
                    GL30.glBindFramebuffer((int)36160, (int)prevDrawFbo);
                    return;
                }
                GL30.glBindFramebuffer((int)36160, (int)prevReadFbo);
                GL30.glBindFramebuffer((int)36160, (int)prevDrawFbo);
                GL30.glBindFramebuffer((int)36008, (int)sourceFbo);
                GL30.glBindFramebuffer((int)36009, (int)captureFbo);
                GL11.glReadBuffer((int)0);
                GL30.glBlitFramebuffer((int)0, (int)0, (int)w, (int)h, (int)0, (int)0, (int)w, (int)h, (int)256, (int)9728);
                GL30.glBindFramebuffer((int)36008, (int)prevReadFbo);
                GL30.glBindFramebuffer((int)36009, (int)prevDrawFbo);
                capturedThisFrame = true;
            }
        }
    }

    private static void compositeClouds() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && capturedThisFrame && capturedSceneDepthTex > 0 && capturedW > 0 && capturedH > 0) {
            SimpleCloudsRenderer.getOptionalInstance().ifPresent(renderer -> {
                if (renderer.getCloudTarget() != null) {
                    int windowW = mc.m_91268_().m_85441_();
                    int windowH = mc.m_91268_().m_85442_();
                    int cloudColorTex = renderer.getCloudTarget().m_83975_();
                    int cloudDepthTex = renderer.getCloudTarget().m_83980_();
                    if (cloudColorTex > 0 && cloudDepthTex > 0 && FinalCloudCompositeHandler.ensureCompositeProgram()) {
                        int depthTex;
                        int prevProgram = GL11.glGetInteger((int)35725);
                        int prevFbo = GL11.glGetInteger((int)36006);
                        int prevVAO = GL11.glGetInteger((int)34229);
                        boolean depthEnabled = GL11.glIsEnabled((int)2929);
                        boolean blendEnabled = GL11.glIsEnabled((int)3042);
                        boolean depthMask = GL11.glGetBoolean((int)2930);
                        int mainFbo = ((MixinRenderTargetAccessor)mc.m_91385_()).simpleclouds$getFrameBufferId();
                        int originalDepthTex = mc.m_91385_().m_83980_();
                        GL30.glBindFramebuffer((int)36160, (int)mainFbo);
                        GL11.glViewport((int)0, (int)0, (int)windowW, (int)windowH);
                        boolean depthAttachmentOk = false;
                        int n = depthTex = externalSceneDepthTex > 0 ? externalSceneDepthTex : capturedSceneDepthTex;
                        if (depthTex > 0) {
                            GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)depthTex, (int)0);
                            int status = GL30.glCheckFramebufferStatus((int)36160);
                            boolean bl = depthAttachmentOk = status == 36053;
                            if (!depthAttachmentOk) {
                                System.out.println("[OFSC WARN] Composite FBO incomplete for depth (" + status + "); falling back to shader compare.");
                                GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)originalDepthTex, (int)0);
                            }
                        }
                        if (depthAttachmentOk) {
                            GL11.glEnable((int)2929);
                            GL11.glDepthFunc((int)(reverseDepthDetected ? 518 : 515));
                        } else {
                            GL11.glDisable((int)2929);
                        }
                        GL11.glDepthMask((boolean)false);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL20.glUseProgram((int)compositeProgram);
                        GL13.glActiveTexture((int)33984);
                        GL11.glBindTexture((int)3553, (int)cloudColorTex);
                        GL20.glUniform1i((int)locCloudColor, (int)0);
                        GL13.glActiveTexture((int)33985);
                        GL11.glBindTexture((int)3553, (int)cloudDepthTex);
                        GL20.glUniform1i((int)locCloudDepth, (int)1);
                        GL13.glActiveTexture((int)33986);
                        GL11.glBindTexture((int)3553, (int)(externalSceneDepthTex > 0 ? externalSceneDepthTex : capturedSceneDepthTex));
                        GL20.glUniform1i((int)locSceneDepth, (int)2);
                        GL20.glUniform1f((int)locDepthBias, (float)0.001f);
                        GL20.glUniform1i((int)locReverseDepth, (int)(reverseDepthDetected ? 1 : 0));
                        GL30.glBindVertexArray((int)compositeVao);
                        GL11.glDrawArrays((int)4, (int)0, (int)3);
                        GL30.glBindVertexArray((int)prevVAO);
                        if (!blendEnabled) {
                            GL11.glDisable((int)3042);
                        }
                        GL11.glDepthMask((boolean)depthMask);
                        if (originalDepthTex > 0) {
                            GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)originalDepthTex, (int)0);
                        }
                        if (depthEnabled) {
                            GL11.glEnable((int)2929);
                        } else {
                            GL11.glDisable((int)2929);
                        }
                        GL20.glUseProgram((int)prevProgram);
                        GL30.glBindFramebuffer((int)36160, (int)prevFbo);
                        GL13.glActiveTexture((int)33984);
                        GL11.glBindTexture((int)3553, (int)0);
                    }
                }
            });
        }
    }

    private static boolean ensureCompositeProgram() {
        if (compositeProgram != -1 && compositeVao != -1 && compositeVbo != -1) {
            return true;
        }
        String vertexSrc = "#version 150\nin vec2 aPos;out vec2 vUv;void main(){vUv=aPos*0.5+0.5;gl_Position=vec4(aPos,0.0,1.0);}";
        String fragmentSrc = "#version 150\nin vec2 vUv;uniform sampler2D uCloudColor;uniform sampler2D uCloudDepth;uniform sampler2D uSceneDepth;uniform float uBias;uniform int uReverse;out vec4 fragColor;void main(){float cloudD=texture(uCloudDepth,vUv).r;float sceneD=texture(uSceneDepth,vUv).r;if(cloudD<=0.0||cloudD>=1.0){discard;}if(sceneD<0.999){discard;}gl_FragDepth = cloudD - uBias;fragColor=texture(uCloudColor,vUv);}";
        int vert = GL20.glCreateShader((int)35633);
        GL20.glShaderSource((int)vert, (CharSequence)vertexSrc);
        GL20.glCompileShader((int)vert);
        if (GL20.glGetShaderi((int)vert, (int)35713) != 1) {
            System.out.println("[OFSC WARN] Composite vertex shader compile failed: " + GL20.glGetShaderInfoLog((int)vert));
            GL20.glDeleteShader((int)vert);
            return false;
        }
        int frag = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)frag, (CharSequence)fragmentSrc);
        GL20.glCompileShader((int)frag);
        if (GL20.glGetShaderi((int)frag, (int)35713) != 1) {
            System.out.println("[OFSC WARN] Composite fragment shader compile failed: " + GL20.glGetShaderInfoLog((int)frag));
            GL20.glDeleteShader((int)vert);
            GL20.glDeleteShader((int)frag);
            return false;
        }
        compositeProgram = GL20.glCreateProgram();
        GL20.glAttachShader((int)compositeProgram, (int)vert);
        GL20.glAttachShader((int)compositeProgram, (int)frag);
        GL20.glLinkProgram((int)compositeProgram);
        GL20.glDeleteShader((int)vert);
        GL20.glDeleteShader((int)frag);
        if (GL20.glGetProgrami((int)compositeProgram, (int)35714) != 1) {
            System.out.println("[OFSC WARN] Composite program link failed: " + GL20.glGetProgramInfoLog((int)compositeProgram));
            GL20.glDeleteProgram((int)compositeProgram);
            compositeProgram = -1;
            return false;
        }
        locCloudColor = GL20.glGetUniformLocation((int)compositeProgram, (CharSequence)"uCloudColor");
        locCloudDepth = GL20.glGetUniformLocation((int)compositeProgram, (CharSequence)"uCloudDepth");
        locSceneDepth = GL20.glGetUniformLocation((int)compositeProgram, (CharSequence)"uSceneDepth");
        locDepthBias = GL20.glGetUniformLocation((int)compositeProgram, (CharSequence)"uBias");
        locReverseDepth = GL20.glGetUniformLocation((int)compositeProgram, (CharSequence)"uReverse");
        compositeVao = GL30.glGenVertexArrays();
        compositeVbo = GL15.glGenBuffers();
        GL30.glBindVertexArray((int)compositeVao);
        GL15.glBindBuffer((int)34962, (int)compositeVbo);
        GL15.glBufferData((int)34962, (float[])new float[]{-1.0f, -1.0f, 3.0f, -1.0f, -1.0f, 3.0f}, (int)35044);
        int posLoc = GL20.glGetAttribLocation((int)compositeProgram, (CharSequence)"aPos");
        GL20.glEnableVertexAttribArray((int)posLoc);
        GL20.glVertexAttribPointer((int)posLoc, (int)2, (int)5126, (boolean)false, (int)8, (long)0L);
        GL30.glBindVertexArray((int)0);
        return true;
    }

    private static void ensureSceneDepthTarget(int w, int h) {
        if (capturedSceneDepthTex == -1) {
            capturedSceneDepthTex = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)capturedSceneDepthTex);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        } else {
            GL11.glBindTexture((int)3553, (int)capturedSceneDepthTex);
        }
        if (w != capturedW || h != capturedH) {
            GL11.glTexImage2D((int)3553, (int)0, (int)33190, (int)w, (int)h, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
            capturedW = w;
            capturedH = h;
        }
        if (captureFbo == -1) {
            captureFbo = GL30.glGenFramebuffers();
        }
        GL30.glBindFramebuffer((int)36160, (int)captureFbo);
        GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)capturedSceneDepthTex, (int)0);
        GL30.glDrawBuffer((int)0);
        GL30.glReadBuffer((int)0);
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    private static void maybeLogDepthSamples(int cloudDepthTex, int sceneDepthTex, int w, int h) {
        long now = System.currentTimeMillis();
        if (now - lastDepthLogMs >= 1000L) {
            lastDepthLogMs = now;
            float sceneCenter = FinalCloudCompositeHandler.sampleDepthAt(sceneDepthTex, 0.5f, 0.5f);
            float sceneNearX = FinalCloudCompositeHandler.sampleDepthAt(sceneDepthTex, 0.25f, 0.5f);
            float sceneFarX = FinalCloudCompositeHandler.sampleDepthAt(sceneDepthTex, 0.75f, 0.5f);
            float cloudCenter = FinalCloudCompositeHandler.sampleDepthAt(cloudDepthTex, 0.5f, 0.5f);
            float cloudNearX = FinalCloudCompositeHandler.sampleDepthAt(cloudDepthTex, 0.25f, 0.5f);
            float cloudFarX = FinalCloudCompositeHandler.sampleDepthAt(cloudDepthTex, 0.75f, 0.5f);
            System.out.println("[OFSC DEBUG] Composite depth samples: sceneCenter=" + sceneCenter + " cloudCenter=" + cloudCenter + " size=" + w + "x" + h);
            System.out.println("[OFSC DEBUG] Composite depth spans: sceneNearX=" + sceneNearX + " sceneFarX=" + sceneFarX + " cloudNearX=" + cloudNearX + " cloudFarX=" + cloudFarX);
            reverseDepthDetected = false;
        }
    }

    private static float sampleDepthAt(int tex, float u, float v) {
        if (tex <= 0) {
            return -1.0f;
        }
        GL11.glBindTexture((int)3553, (int)tex);
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (w > 0 && h > 0 && (long)w * (long)h <= 4000000L) {
            int x = Math.max(0, Math.min(w - 1, (int)(u * (float)w)));
            int y = Math.max(0, Math.min(h - 1, (int)(v * (float)h)));
            int idx = y * w + x;
            FloatBuffer buf = ByteBuffer.allocateDirect((int)((long)w * (long)h * 4L)).order(ByteOrder.nativeOrder()).asFloatBuffer();
            GL11.glGetTexImage((int)3553, (int)0, (int)6402, (int)5126, (FloatBuffer)buf);
            float val = buf.get(idx);
            GL11.glBindTexture((int)3553, (int)0);
            return val;
        }
        GL11.glBindTexture((int)3553, (int)0);
        return -1.0f;
    }
}

