/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.oculus_for_simpleclouds;

import dev.nonamecrackers2.simpleclouds.api.SimpleCloudsAPI;
import dev.nonamecrackers2.simpleclouds.api.common.world.ScAPICloudManager;
import dev.nonamecrackers2.simpleclouds.client.renderer.SimpleCloudsRenderer;
import dev.nonamecrackers2.simpleclouds.client.renderer.WorldEffects;
import dev.nonamecrackers2.simpleclouds.common.cloud.CloudType;
import dev.nonamecrackers2.simpleclouds.common.cloud.region.CloudRegion;
import dev.nonamecrackers2.simpleclouds.common.world.CloudManager;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Optional;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11C;

@OnlyIn(value=Dist.CLIENT)
public final class SimpleCloudsUniforms {
    private static long lastDebugTime = 0L;
    private static final long DEBUG_INTERVAL_MS = 1000L;

    private SimpleCloudsUniforms() {
    }

    public static void debugPrint(String msg) {
        long now = System.currentTimeMillis();
        if (now - lastDebugTime >= 1000L) {
            System.out.println("[OCS DEBUG] " + msg);
            lastDebugTime = now;
        }
    }

    public static Vector4f sampleCloudState() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null || mc.f_91063_ == null || mc.f_91063_.m_109153_() == null) {
            return new Vector4f();
        }
        Optional<CloudManager<ClientLevel>> manager = SimpleCloudsUniforms.tryGetManager(level);
        if (manager.isEmpty()) {
            return new Vector4f();
        }
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        Pair info = manager.get().getCloudTypeAtWorldPos((float)cameraPos.f_82479_, (float)cameraPos.f_82481_);
        CloudType type = (CloudType)info.getLeft();
        float edgeFade = ((Float)info.getRight()).floatValue();
        OptionalWorldEffects effects = OptionalWorldEffects.grab();
        float fade = 1.0f - effects.fade().orElse(Float.valueOf(edgeFade)).floatValue();
        float baseStorminess = effects.instantStorminess().orElseGet(() -> Float.valueOf(SimpleCloudsUniforms.computeStorminess((CloudManager<ClientLevel>)((CloudManager)manager.get()), type, cameraPos, fade))).floatValue();
        float tickDelta = CapturedRenderingState.INSTANCE.getTickDelta();
        float smoothed = effects.smoothedStorminess(tickDelta).orElse(Float.valueOf(baseStorminess)).floatValue();
        Vector4f out = new Vector4f((float)type.weatherType().ordinal(), fade, baseStorminess, smoothed);
        return out;
    }

    public static Vector4f sampleCloudType() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null || mc.f_91063_ == null || mc.f_91063_.m_109153_() == null) {
            return new Vector4f();
        }
        Optional<CloudManager<ClientLevel>> manager = SimpleCloudsUniforms.tryGetManager(level);
        if (manager.isEmpty()) {
            return new Vector4f();
        }
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        Pair info = manager.get().getCloudTypeAtWorldPos((float)cameraPos.f_82479_, (float)cameraPos.f_82481_);
        CloudType type = (CloudType)info.getLeft();
        Vector4f out = new Vector4f(type.storminess(), type.stormStart(), type.stormFadeDistance(), type.transparencyFade());
        return out;
    }

    private static float smoothstep(float edge0, float edge1, float x) {
        x = Mth.m_14036_((float)((x - edge0) / (edge1 - edge0)), (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    public static float sampleCloudShadow() {
        Vector4f state = SimpleCloudsUniforms.sampleCloudState();
        float thick = state.y();
        float storm = state.z();
        float coverage = Math.max(0.0f, Math.min(1.0f, thick * 0.65f + storm * 0.45f));
        float shadow = SimpleCloudsUniforms.smoothstep(0.25f, 0.85f, coverage);
        return shadow * 0.85f;
    }

    public static Optional<CloudLayerTextureState> prepareCloudLayerTexture() {
        return CloudLayerTexture.prepare();
    }

    private static float computeStorminess(CloudManager<ClientLevel> manager, CloudType type, Vec3 cameraPos, float fade) {
        if (manager.shouldUseVanillaWeather() || !type.weatherType().causesDarkening()) {
            return 0.0f;
        }
        float cameraY = (float)cameraPos.f_82480_;
        float cloudCeiling = type.stormStart() * 8.0f + (float)manager.getCloudHeight();
        float verticalFade = 1.0f - Mth.m_14036_((float)((cameraY - cloudCeiling) / 32.0f), (float)0.0f, (float)1.0f);
        float horizontalFade = Mth.m_14036_((float)((1.0f - fade) * 3.0f), (float)0.0f, (float)1.0f);
        return type.storminess() * horizontalFade * verticalFade;
    }

    private static Optional<CloudManager<ClientLevel>> tryGetManager(ClientLevel level) {
        try {
            ScAPICloudManager apiManager = SimpleCloudsAPI.getApi().getCloudManager((Level)level);
            if (apiManager instanceof CloudManager) {
                CloudManager manager;
                CloudManager typed = manager = (CloudManager)apiManager;
                return Optional.ofNullable(typed);
            }
        }
        catch (IllegalStateException | NullPointerException apiManager) {
            // empty catch block
        }
        try {
            return Optional.ofNullable(CloudManager.get((Level)level));
        }
        catch (IllegalStateException | NullPointerException ex) {
            return Optional.empty();
        }
    }

    private record OptionalWorldEffects(Optional<WorldEffects> delegate) {
        static OptionalWorldEffects grab() {
            return new OptionalWorldEffects(SimpleCloudsRenderer.getOptionalInstance().map(SimpleCloudsRenderer::getWorldEffectsManager));
        }

        Optional<Float> fade() {
            return this.delegate.map(WorldEffects::getFadeRegionAtCamera);
        }

        Optional<Float> instantStorminess() {
            return this.delegate.map(WorldEffects::getStorminessAtCamera);
        }

        Optional<Float> smoothedStorminess(float tickDelta) {
            return this.delegate.map(worldEffects -> Float.valueOf(worldEffects.getStorminessSmoothed(tickDelta)));
        }
    }

    private static final class CloudLayerTexture {
        private static final int GRID_RESOLUTION = 64;
        private static final float SAMPLE_SPAN = 2048.0f;
        private static final long UPDATE_INTERVAL_MS = 50L;
        private static final FloatBuffer BUFFER = BufferUtils.createFloatBuffer((int)4096);
        private static int textureId = -1;
        private static int textureUnit = -1;
        private static long lastUploadMs;
        private static boolean valid;

        private CloudLayerTexture() {
        }

        private static Optional<CloudLayerTextureState> prepare() {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91063_ == null || mc.f_91063_.m_109153_() == null) {
                valid = false;
                return Optional.empty();
            }
            if (!CloudLayerTexture.isHighQualityModeActive()) {
                return Optional.empty();
            }
            Optional<CloudManager<ClientLevel>> managerOpt = SimpleCloudsUniforms.tryGetManager(mc.f_91073_);
            if (managerOpt.isEmpty()) {
                valid = false;
                return Optional.empty();
            }
            CloudLayerTexture.ensureTexture();
            long now = System.currentTimeMillis();
            if (!valid || now - lastUploadMs >= 50L) {
                if (!CloudLayerTexture.upload(managerOpt.get(), mc.f_91063_.m_109153_().m_90583_())) {
                    valid = false;
                    return Optional.empty();
                }
                lastUploadMs = now;
                valid = true;
            }
            if (!valid) {
                return Optional.empty();
            }
            return Optional.of(new CloudLayerTextureState(textureId, CloudLayerTexture.resolveTextureUnit()));
        }

        private static void ensureTexture() {
            if (textureId != -1) {
                return;
            }
            textureId = GL11C.glGenTextures();
            GL11C.glBindTexture((int)3553, (int)textureId);
            GL11C.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11C.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11C.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11C.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11C.glBindTexture((int)3553, (int)0);
        }

        private static boolean upload(CloudManager<ClientLevel> manager, Vec3 camera) {
            List regions = manager.getClouds();
            if (regions.isEmpty()) {
                return false;
            }
            FloatBuffer buffer = BUFFER;
            buffer.clear();
            float halfSpan = 1024.0f;
            float startX = (float)camera.f_82479_ - halfSpan;
            float startZ = (float)camera.f_82481_ - halfSpan;
            float step = 32.0f;
            for (int z = 0; z < 64; ++z) {
                float sampleZ = startZ + (float)z * step;
                for (int x = 0; x < 64; ++x) {
                    float sampleX = startX + (float)x * step;
                    float coverage = CloudLayerTexture.sampleCoverage(regions, sampleX, sampleZ);
                    buffer.put(coverage);
                }
            }
            buffer.flip();
            GL11C.glBindTexture((int)3553, (int)textureId);
            GL11C.glPixelStorei((int)3317, (int)4);
            GL11C.glTexImage2D((int)3553, (int)0, (int)33326, (int)64, (int)64, (int)0, (int)6403, (int)5126, (FloatBuffer)buffer);
            GL11C.glBindTexture((int)3553, (int)0);
            return true;
        }

        private static float sampleCoverage(List<CloudRegion> regions, float worldX, float worldZ) {
            Pair result = CloudRegion.calculateAt(regions, (float)worldX, (float)worldZ);
            if (result == null || result.getRight() == null) {
                return 0.0f;
            }
            return Mth.m_14036_((float)((Float)result.getRight()).floatValue(), (float)0.0f, (float)1.0f);
        }

        private static boolean isHighQualityModeActive() {
            return SimpleCloudsRenderer.getOptionalInstance().flatMap(SimpleCloudsRenderer::getShadowMap).isPresent();
        }

        private static int resolveTextureUnit() {
            if (textureUnit >= 0) {
                return textureUnit;
            }
            int maxUnits = GL11C.glGetInteger((int)34930);
            textureUnit = Math.max(0, maxUnits - 1);
            return textureUnit;
        }
    }

    public record CloudLayerTextureState(int textureId, int textureUnit) {
    }
}

