/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.network.packet;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;

public class SetWallDecorationTextPacket {
    private final BlockPos pos;
    private final List<String> texts;

    public SetWallDecorationTextPacket(BlockPos pos, List<String> texts) {
        this.pos = pos;
        this.texts = texts;
    }

    public static void encode(SetWallDecorationTextPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.texts.size());
        for (String text : msg.texts) {
            buf.m_130070_(text);
        }
    }

    public static SetWallDecorationTextPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<String> texts = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            texts.add(buf.m_130136_(50));
        }
        return new SetWallDecorationTextPacket(pos, texts);
    }

    public static void handle(SetWallDecorationTextPacket msg, ServerPlayer player) {
        BlockEntity entity;
        Level level = player.m_9236_();
        if (level.m_46749_(msg.pos) && (entity = level.m_7702_(msg.pos)) instanceof WallDecorationBlockEntity) {
            WallDecorationBlockEntity signEntity = (WallDecorationBlockEntity)entity;
            for (int i = 0; i < msg.texts.size() && i < 4; ++i) {
                signEntity.setText(i, (Component)Component.m_237113_((String)msg.texts.get(i)));
            }
        }
    }
}

