/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.satisfy.meadow.core.recipes.CookingCauldronRecipe;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronCategory
implements IRecipeCategory<CookingCauldronRecipe> {
    public static final RecipeType<CookingCauldronRecipe> COOKING_CAULDRON = RecipeType.create((String)"meadow", (String)"cooking_cauldron", CookingCauldronRecipe.class);
    private static final int BACKGROUND_WIDTH = 160;
    private static final int BACKGROUND_HEIGHT = 70;
    private static final int X_OFFSET = 10;
    private static final int Y_OFFSET = 10;
    private static final int ARROW_U = 176;
    private static final int ARROW_V = 14;
    private static final int ARROW_WIDTH = 24;
    private static final int ARROW_HEIGHT = 17;
    private static final int MAX_TIME = 200;
    private static final int WIDTH_OF = 26;
    private static final int HEIGHT_OF = 10;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnIcon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;
    private static final int FLUID_X = 173;
    private static final int FLUID_Y = 23;
    private static final int FLUID_WIDTH = 8;
    private static final int FLUID_HEIGHT = 43;
    private final ResourceLocation texture = new ResourceLocation("meadow", "textures/gui/cooking_cauldron_gui.png");

    public CookingCauldronCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(this.texture, 10, 10, 160, 70);
        this.arrow = helper.drawableBuilder(this.texture, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.COOKING_CAULDRON.get()).m_5456_().m_7968_());
        this.burnIcon = helper.createDrawable(this.texture, 176, 0, 14, 14);
        this.localizedName = ((Block)ObjectRegistry.COOKING_CAULDRON.get()).m_49954_();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CookingCauldronRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        for (int i = 0; i < ingredients.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + i % 3 * 18, 7 + i / 3 * 18).addIngredients((Ingredient)ingredients.get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 17).addItemStack(recipe.getResultItem());
    }

    public void draw(CookingCauldronRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 60, 17);
        this.burnIcon.draw(guiGraphics, 98, 42);
        this.drawFluid(guiGraphics, recipe.getFluidAmount());
    }

    private void drawFluid(GuiGraphics guiGraphics, int fluidAmount) {
        int filledHeight = Math.min(fluidAmount, 100) * 43 / 100;
        int x = 147;
        int y = 13 + (43 - filledHeight);
        guiGraphics.m_280218_(this.texture, x, y, 176, 31 + (43 - filledHeight), 8, filledHeight);
    }

    @NotNull
    public RecipeType<CookingCauldronRecipe> getRecipeType() {
        return COOKING_CAULDRON;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

