/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import net.satisfy.meadow.core.block.CookingCauldronBlock;
import net.satisfy.meadow.core.recipes.CookingCauldronRecipe;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import net.satisfy.meadow.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingCauldronBlockEntity
extends BlockEntity
implements ImplementedInventory,
MenuProvider {
    private static final int MAX_CAPACITY = 8;
    private static final int OUTPUT_SLOT = 0;
    public static final int MAX_COOKING_TIME = 200;
    private static final int INGREDIENTS_START = 1;
    private static final int INGREDIENTS_END = 6;
    private static final int FLUID_INPUT_SLOT = 7;
    private static final int[] SLOTS_FOR_REST = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 7};
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private int cookingTime;
    private boolean isBeingBurned;
    private int fluidLevel;
    private int currentCraftingDuration;
    private final ContainerData delegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CookingCauldronBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingCauldronBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> CookingCauldronBlockEntity.this.fluidLevel;
                case 3 -> CookingCauldronBlockEntity.this.currentCraftingDuration;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CookingCauldronBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingCauldronBlockEntity.this.isBeingBurned = value != 0;
                    break;
                }
                case 2: {
                    CookingCauldronBlockEntity.this.fluidLevel = value;
                    break;
                }
                case 3: {
                    CookingCauldronBlockEntity.this.currentCraftingDuration = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private boolean fluidInputProcessed = false;

    public CookingCauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.COOKING_CAULDRON.get(), pos, state);
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_REST;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.cookingTime = nbt.m_128451_("CookingTime");
        this.isBeingBurned = nbt.m_128471_("IsBeingBurned");
        this.fluidLevel = nbt.m_128451_("FluidLevel");
        this.currentCraftingDuration = nbt.m_128451_("CurrentCraftingDuration");
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("CookingTime", this.cookingTime);
        nbt.m_128379_("IsBeingBurned", this.isBeingBurned);
        nbt.m_128405_("FluidLevel", this.fluidLevel);
        nbt.m_128405_("CurrentCraftingDuration", this.currentCraftingDuration);
    }

    public boolean isBeingBurned() {
        if (this.m_58904_() == null) {
            throw new NullPointerException("Null world invoked");
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)CookingCauldronBlock.HANGING)).booleanValue()) {
            return true;
        }
        Optional optionalList = BuiltInRegistries.f_256975_.m_203431_(TagRegistry.ALLOWS_COOKING);
        HolderSet.Named entryList = optionalList.orElse(null);
        return entryList != null && entryList.m_203333_((Holder)this.m_58904_().m_8055_(this.m_58899_().m_7495_()).m_60734_().m_204297_());
    }

    private boolean canCraft(CookingCauldronRecipe recipe) {
        if (recipe == null || recipe.getResultItem().m_41619_()) {
            return false;
        }
        ItemStack outputSlotStack = this.m_8020_(0);
        ItemStack result = recipe.getResultItem().m_41777_();
        if (outputSlotStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)outputSlotStack, (ItemStack)result)) {
            return false;
        }
        return outputSlotStack.m_41613_() + result.m_41613_() <= outputSlotStack.m_41741_();
    }

    private void craft(CookingCauldronRecipe recipe) {
        if (!this.canCraft(recipe)) {
            return;
        }
        ItemStack recipeOutput = recipe.assemble();
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            this.m_6836_(0, recipeOutput.m_41777_());
        } else if (ItemStack.m_41656_((ItemStack)outputSlotStack, (ItemStack)recipe.getResultItem()) && outputSlotStack.m_41613_() < outputSlotStack.m_41741_()) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
        boolean[] ingredientUsed = new boolean[7];
        block0: for (Ingredient ingredient : recipe.m_7527_()) {
            for (int slotIndex = 1; slotIndex <= 6; ++slotIndex) {
                if (ingredientUsed[slotIndex] || !ingredient.test(this.m_8020_(slotIndex))) continue;
                ingredientUsed[slotIndex] = true;
                ItemStack stackInSlot = this.m_8020_(slotIndex);
                ItemStack remainderStack = this.getRemainderItem(stackInSlot);
                stackInSlot.m_41774_(1);
                if (remainderStack.m_41619_()) continue block0;
                if (stackInSlot.m_41619_()) {
                    this.m_6836_(slotIndex, remainderStack);
                    continue block0;
                }
                this.handleRemainder(remainderStack, slotIndex);
                continue block0;
            }
        }
        this.consumeFluid(recipe.getFluidAmount());
    }

    private void handleRemainder(ItemStack remainderStack, int originalSlot) {
        if (originalSlot == 7) {
            ItemStack currentFluidSlot = this.m_8020_(7);
            if (currentFluidSlot.m_41619_()) {
                this.m_6836_(7, remainderStack.m_41777_());
            } else {
                this.dropItemIntoWorld(remainderStack, this.f_58858_);
            }
            return;
        }
        boolean added = false;
        for (int i = 1; i <= 6; ++i) {
            ItemStack is = this.m_8020_(i);
            if (is.m_41619_()) {
                this.m_6836_(i, remainderStack.m_41777_());
                added = true;
                break;
            }
            if (!ItemStack.m_41656_((ItemStack)is, (ItemStack)remainderStack) || is.m_41613_() + remainderStack.m_41613_() > is.m_41741_()) continue;
            is.m_41769_(remainderStack.m_41613_());
            added = true;
            break;
        }
        if (!added) {
            this.dropItemIntoWorld(remainderStack, this.f_58858_);
        }
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_()));
        }
        return ItemStack.f_41583_;
    }

    private void dropItemIntoWorld(ItemStack itemStack, BlockPos pos) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            double offsetX = this.f_58857_.f_46441_.m_188500_() * 0.7 + 0.15;
            double offsetY = this.f_58857_.f_46441_.m_188500_() * 0.5 + 0.1;
            double offsetZ = this.f_58857_.f_46441_.m_188500_() * 0.7 + 0.15;
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, itemStack);
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
    }

    private void processFluidInput() {
        ItemStack fluidItem = this.m_8020_(7);
        if (!fluidItem.m_41619_()) {
            boolean processed = false;
            int fluidAmount = 0;
            if (fluidItem.m_204117_(TagRegistry.SMALL_WATER_FILL)) {
                fluidAmount = 25;
                processed = true;
            } else if (fluidItem.m_204117_(TagRegistry.LARGE_WATER_FILL)) {
                fluidAmount = 50;
                processed = true;
            }
            if (processed) {
                ItemStack consumedItem = fluidItem.m_41620_(1);
                this.m_6836_(7, fluidItem);
                ItemStack remainder = this.getRemainderItem(consumedItem);
                if (!remainder.m_41619_()) {
                    this.handleRemainder(remainder, 7);
                }
                this.addFluid(fluidAmount);
                this.m_6596_();
            }
        }
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        ItemStack fluidItem;
        if (world.m_5776_()) {
            return;
        }
        if (!this.fluidInputProcessed) {
            this.processFluidInput();
            this.fluidInputProcessed = true;
        }
        if ((fluidItem = this.m_8020_(7)).m_41619_() || !fluidItem.m_204117_(TagRegistry.SMALL_WATER_FILL) && !fluidItem.m_204117_(TagRegistry.LARGE_WATER_FILL)) {
            this.fluidInputProcessed = false;
        }
        this.isBeingBurned = this.isBeingBurned();
        if (!this.isBeingBurned && ((Boolean)state.m_61143_((Property)CookingCauldronBlock.LIT)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        CookingCauldronRecipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.COOKING.get(), (Container)this, world).orElse(null);
        if (this.canCraft(recipe) && this.fluidLevel >= recipe.getFluidAmount()) {
            if (this.currentCraftingDuration == 0) {
                this.currentCraftingDuration = recipe.getCraftingDuration() * 20;
                this.delegate.m_8050_(3, this.currentCraftingDuration);
            }
            ++this.cookingTime;
            this.delegate.m_8050_(0, this.cookingTime);
            if (this.cookingTime >= this.currentCraftingDuration) {
                this.cookingTime = 0;
                this.currentCraftingDuration = 0;
                this.delegate.m_8050_(3, 0);
                this.craft(recipe);
            }
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.cookingTime = 0;
            this.currentCraftingDuration = 0;
            this.delegate.m_8050_(0, 0);
            this.delegate.m_8050_(3, 0);
            if (((Boolean)state.m_61143_((Property)CookingCauldronBlock.COOKING)).booleanValue()) {
                world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)CookingCauldronBlock.COOKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CookingCauldronBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public boolean m_6542_(Player player) {
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return ((Block)ObjectRegistry.COOKING_CAULDRON.get()).m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new CookingCauldronGuiHandler(syncId, inv, (Container)this, this.delegate);
    }

    public int getFluidLevel() {
        return Math.min(this.fluidLevel, 100);
    }

    private void addFluid(int amount) {
        this.fluidLevel = Math.min(this.fluidLevel + amount, 100);
        this.delegate.m_8050_(2, this.fluidLevel);
    }

    private void consumeFluid(int amount) {
        this.fluidLevel = Math.max(this.fluidLevel - amount, 0);
        this.delegate.m_8050_(2, this.fluidLevel);
    }
}

