/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.entity.CookingCauldronBlockEntity;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingCauldronBlock
extends BaseEntityBlock {
    private static final VoxelShape LOWER_SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.0625, (double)0.75);
    private static final VoxelShape UPPER_SHAPE = Shapes.m_83048_((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.5625, (double)0.8125);
    private static final VoxelShape COMBINED_SHAPE = Shapes.m_83110_((VoxelShape)LOWER_SHAPE, (VoxelShape)UPPER_SHAPE);
    private static final VoxelShape HANGING_SHAPE = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.25, (double)0.8125);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final BooleanProperty COOKING = BooleanProperty.m_61465_((String)"cooking");
    public static final BooleanProperty HANGING = BooleanProperty.m_61465_((String)"hanging");

    public CookingCauldronBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COOKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, COOKING, LIT, HANGING});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? HANGING_SHAPE : COMBINED_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof MenuProvider) {
            MenuProvider factory = (MenuProvider)entity;
            player.m_5893_(factory);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CookingCauldronBlockEntity) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((CookingCauldronBlockEntity)blockEntity));
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)COOKING)).booleanValue() || ((Boolean)state.m_61143_((Property)LIT)).booleanValue() || ((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (double)pos.m_123342_() + ((Boolean)state.m_61143_((Property)HANGING) != false ? 1.0 : 0.7);
            double f = (double)pos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.3) {
                world.m_7785_(d, e, f, SoundEvents.f_11784_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
                world.m_7785_(d, e, f, (SoundEvent)SoundEventRegistry.COOKING_POT_BOILING.get(), SoundSource.BLOCKS, 0.05f, 1.0f, true);
            }
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Direction.Axis axis = direction.m_122434_();
            double h = random.m_188500_() * 0.6 - 0.3;
            double i = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.0 : h;
            double j = random.m_188500_() * 9.0 / 16.0;
            double k = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.0 : h;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123774_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123772_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return CookingCauldronBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.COOKING_CAULDRON.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CookingCauldronBlockEntity(pos, state);
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)this));
        if (((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
            list.add(new ItemStack((ItemLike)ObjectRegistry.FRAME.get()));
        }
        return list;
    }
}

