/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.satisfy.meadow.client.model.WoolySheepFurModel;
import net.satisfy.meadow.client.model.WoolySheepModel;
import net.satisfy.meadow.core.entity.WoolySheepEntity;
import net.satisfy.meadow.core.entity.WoolySheepVar;
import net.satisfy.meadow.core.util.MeadowIdentifier;

public class WoolySheepFurLayerRenderer
extends RenderLayer<WoolySheepEntity, WoolySheepModel<WoolySheepEntity>> {
    private static final ResourceLocation FLECKED_FUR_LOCATION = new MeadowIdentifier("textures/entity/sheep/flecked_sheep_fur.png");
    private static final ResourceLocation PATCHED_FUR_LOCATION = new MeadowIdentifier("textures/entity/sheep/patched_sheep_fur.png");
    private static final ResourceLocation ROCKY_FUR_LOCATION = new MeadowIdentifier("textures/entity/sheep/rocky_sheep_fur.png");
    private static final ResourceLocation INKY_FUR_LOCATION = new MeadowIdentifier("textures/entity/sheep/inky_sheep_fur.png");
    private static final ResourceLocation FUZZY_FUR_LOCATION = new MeadowIdentifier("textures/entity/sheep/fuzzy_sheep_fur.png");
    private static final ResourceLocation LONG_NOSED_FUR_LOCATION = new MeadowIdentifier("textures/entity/sheep/long_nosed_sheep_fur.png");
    private final WoolySheepFurModel<WoolySheepEntity> sheepModel;

    public WoolySheepFurLayerRenderer(RenderLayerParent<WoolySheepEntity, WoolySheepModel<WoolySheepEntity>> parent, EntityRendererProvider.Context context) {
        super(parent);
        this.sheepModel = new WoolySheepFurModel(context.m_174023_(ModelLayers.f_171178_));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, WoolySheepEntity sheep, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (sheep.isSheared() || sheep.m_20145_()) {
            return;
        }
        ResourceLocation furLocation = switch (sheep.getVariant()) {
            case WoolySheepVar.PATCHED -> PATCHED_FUR_LOCATION;
            case WoolySheepVar.ROCKY -> ROCKY_FUR_LOCATION;
            case WoolySheepVar.INKY -> INKY_FUR_LOCATION;
            case WoolySheepVar.FUZZY -> FUZZY_FUR_LOCATION;
            case WoolySheepVar.LONG_NOSED -> LONG_NOSED_FUR_LOCATION;
            default -> FLECKED_FUR_LOCATION;
        };
        float[] fs = sheep.getVariant().getTextureDiffuseColors();
        WoolySheepFurLayerRenderer.m_117359_((EntityModel)this.m_117386_(), this.sheepModel, (ResourceLocation)furLocation, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (LivingEntity)sheep, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)fs[0], (float)fs[1], (float)fs[2]);
    }
}

