/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronGuiHandler
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData propertyDelegate;

    public CookingCauldronGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(4));
    }

    public CookingCauldronGuiHandler(int syncId, Inventory playerInventory, Container container, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerRegistry.COOKING_CAULDRON_SCREEN_HANDLER.get(), syncId);
        int i;
        this.container = container;
        this.propertyDelegate = propertyDelegate;
        this.m_38884_(this.propertyDelegate);
        this.m_38897_((Slot)new FurnaceResultSlot(playerInventory.f_35978_, container, 0, 107, 27));
        for (i = 1; i <= 6; ++i) {
            int x = 11 + (i - 1) % 3 * 18;
            int y = 17 + (i - 1) / 3 * 18;
            this.m_38897_(new Slot(container, i, x, y));
        }
        this.m_38897_(new Slot(container, 7, 134, 23){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(TagRegistry.SMALL_WATER_FILL) || stack.m_204117_(TagRegistry.LARGE_WATER_FILL);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(1) != 0;
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(0);
        int total = this.propertyDelegate.m_6413_(3);
        if (total == 0) {
            return 0;
        }
        return progress * arrowWidth / total;
    }

    public int getFluidLevel() {
        return this.propertyDelegate.m_6413_(2);
    }

    public int getCookingTime() {
        return this.propertyDelegate.m_6413_(0);
    }

    public int getRequiredDuration() {
        return this.propertyDelegate.m_6413_(3);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack item = slot.m_7993_();
        ItemStack copy = item.m_41777_();
        if (index == 0) {
            if (!this.m_38903_(item, 8, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(item, copy);
        } else if (index >= 1 && index <= 6) {
            if (!this.m_38903_(item, 8, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
        } else if (index == 7) {
            if (!this.m_38903_(item, 8, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
        } else if (!this.m_38903_(item, 1, 7, false)) {
            if (item.m_150930_((Item)ObjectRegistry.WOODEN_WATER_BUCKET.get()) || item.m_150930_(Items.f_42447_)) {
                if (!this.m_38903_(item, 7, 8, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
        }
        if (item.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, item);
        return copy;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }
}

