/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import net.satisfy.meadow.core.util.MeadowIdentifier;
import org.joml.Vector2i;

public class CookingCauldronGui
extends AbstractContainerScreen<CookingCauldronGuiHandler> {
    private static final ResourceLocation BACKGROUND = new MeadowIdentifier("textures/gui/cooking_cauldron_gui.png");
    private static final int ARROW_X = 70;
    private static final int ARROW_Y = 27;
    private static final int FLUID_X = 157;
    private static final int FLUID_Y = 23;
    private static final int FLUID_WIDTH = 8;
    private static final int FLUID_HEIGHT = 43;
    private final Vector2i screenPos = new Vector2i();

    public CookingCauldronGui(CookingCauldronGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.screenPos.set(this.f_97735_, this.f_97736_);
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(BACKGROUND, this.screenPos.x(), this.screenPos.y(), 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgressArrow(guiGraphics);
        this.renderBurnIcon(guiGraphics);
        this.renderFluidBar(guiGraphics);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics) {
        int progress = ((CookingCauldronGuiHandler)this.f_97732_).getScaledProgress(24);
        guiGraphics.m_280218_(BACKGROUND, this.screenPos.x() + 70, this.screenPos.y() + 27, 176, 14, progress, 17);
    }

    private void renderBurnIcon(GuiGraphics guiGraphics) {
        if (((CookingCauldronGuiHandler)this.f_97732_).isBeingBurned()) {
            guiGraphics.m_280218_(BACKGROUND, this.screenPos.x() + 108, this.screenPos.y() + 52, 176, 0, 14, 14);
        }
    }

    private void renderFluidBar(GuiGraphics guiGraphics) {
        int fluidLevel = ((CookingCauldronGuiHandler)this.f_97732_).getFluidLevel();
        int filledHeight = fluidLevel * 43 / 100;
        guiGraphics.m_280218_(BACKGROUND, this.screenPos.x() + 157, this.screenPos.y() + 23 + 43 - filledHeight, 176, 74 - filledHeight, 8, filledHeight);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        if (this.isMouseOverFluidArea(mouseX, mouseY)) {
            int fluidLevel = ((CookingCauldronGuiHandler)this.f_97732_).getFluidLevel();
            MutableComponent tooltip = Component.m_237110_((String)"tooltip.meadow.cooking_cauldron.water_level", (Object[])new Object[]{fluidLevel});
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
        }
        if (this.isMouseOverProgressArrow(mouseX, mouseY)) {
            int remainingTicks = ((CookingCauldronGuiHandler)this.f_97732_).getRequiredDuration() - ((CookingCauldronGuiHandler)this.f_97732_).getCookingTime();
            String formattedTime = this.formatTicks(remainingTicks);
            MutableComponent tooltip = Component.m_237110_((String)"tooltip.meadow.cooking_cauldron.remaining_time", (Object[])new Object[]{formattedTime});
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, mouseX, mouseY);
        }
        super.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private boolean isMouseOverFluidArea(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 157;
        int top = this.screenPos.y() + 23;
        return mouseX >= left && mouseX < left + 8 && mouseY >= top && mouseY < top + 43;
    }

    private boolean isMouseOverProgressArrow(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 70;
        int top = this.screenPos.y() + 27;
        return mouseX >= left && mouseX < left + 24 && mouseY >= top && mouseY < top + 17;
    }

    private String formatTicks(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }
}

