/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.worker;

import com.example.soundattract.worker.WorkerScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

public final class WorkerComputations {
    private WorkerComputations() {
    }

    /*
     * WARNING - void declaration
     */
    public static WorkerScheduler.GroupComputeResult computeGroups(List<WorkerScheduler.MobSnapshot> mobs, WorkerScheduler.ConfigSnapshot cfg, long deadlineMs, ResourceLocation dimension) {
        double dz;
        double dx;
        if (mobs == null || mobs.isEmpty()) {
            return null;
        }
        ArrayList<WorkerScheduler.MobSnapshot> candidates = new ArrayList<WorkerScheduler.MobSnapshot>();
        for (WorkerScheduler.MobSnapshot m : mobs) {
            if (!m.alive()) continue;
            candidates.add(m);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.sort(Comparator.comparingDouble(WorkerScheduler.MobSnapshot::health).reversed());
        ArrayList<WorkerScheduler.MobSnapshot> leaders = new ArrayList<WorkerScheduler.MobSnapshot>();
        HashMap<UUID, UUID> mobToLeader = new HashMap<UUID, UUID>();
        double groupRadius = cfg.leaderGroupRadius();
        double leaderSpacing = groupRadius * cfg.leaderSpacingMultiplier();
        int maxLeaders = cfg.maxLeaders();
        int maxGroupSize = cfg.maxGroupSize();
        int sectors = cfg.numEdgeSectors();
        int perSector = cfg.edgeMobsPerSector();
        for (WorkerScheduler.MobSnapshot mobSnapshot : candidates) {
            if (leaders.size() >= maxLeaders) break;
            boolean bl = false;
            for (WorkerScheduler.MobSnapshot mobSnapshot2 : leaders) {
                double dz2;
                double dx2 = mobSnapshot.x() - mobSnapshot2.x();
                double dist2 = dx2 * dx2 + (dz2 = mobSnapshot.z() - mobSnapshot2.z()) * dz2;
                if (!(dist2 < leaderSpacing * leaderSpacing)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                leaders.add(mobSnapshot);
            }
            if (System.currentTimeMillis() <= deadlineMs) continue;
            break;
        }
        if (leaders.isEmpty()) {
            leaders.add((WorkerScheduler.MobSnapshot)candidates.get(0));
        }
        HashMap<UUID, List<UUID>> leaderToGroup = new HashMap<UUID, List<UUID>>();
        for (WorkerScheduler.MobSnapshot mobSnapshot : leaders) {
            leaderToGroup.put(mobSnapshot.uuid(), new ArrayList<UUID>(Collections.singletonList(mobSnapshot.uuid())));
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (WorkerScheduler.MobSnapshot mobSnapshot : candidates) {
            void var20_30;
            if (leaders.contains(mobSnapshot)) {
                hashSet.add(mobSnapshot.uuid());
                mobToLeader.put(mobSnapshot.uuid(), mobSnapshot.uuid());
                continue;
            }
            Object var20_29 = null;
            double bestDist = Double.MAX_VALUE;
            for (WorkerScheduler.MobSnapshot mobSnapshot3 : leaders) {
                double dist;
                List group = (List)leaderToGroup.get(mobSnapshot3.uuid());
                if (group.size() >= maxGroupSize || !((dist = Math.hypot(dx = mobSnapshot.x() - mobSnapshot3.x(), dz = mobSnapshot.z() - mobSnapshot3.z())) <= groupRadius) || !(dist < bestDist)) continue;
                bestDist = dist;
                WorkerScheduler.MobSnapshot mobSnapshot4 = mobSnapshot3;
            }
            if (var20_30 != null) {
                ((List)leaderToGroup.get(var20_30.uuid())).add(mobSnapshot.uuid());
                mobToLeader.put(mobSnapshot.uuid(), var20_30.uuid());
                hashSet.add(mobSnapshot.uuid());
            }
            if (System.currentTimeMillis() <= deadlineMs) continue;
            break;
        }
        HashMap<UUID, Set<UUID>> hashMap = new HashMap<UUID, Set<UUID>>();
        for (WorkerScheduler.MobSnapshot mobSnapshot : leaders) {
            List group = leaderToGroup.getOrDefault(mobSnapshot.uuid(), Collections.emptyList());
            HashMap<Integer, List> sectorLists = new HashMap<Integer, List>();
            for (UUID uUID : group) {
                WorkerScheduler.MobSnapshot m;
                if (uUID.equals(mobSnapshot.uuid()) || (m = WorkerComputations.find(mobs, uUID)) == null) continue;
                dx = m.x() - mobSnapshot.x();
                dz = m.z() - mobSnapshot.z();
                double angle = Math.atan2(dz, dx);
                int sector = (int)Math.floor((angle + Math.PI) / (Math.PI * 2) * (double)sectors) % sectors;
                sectorLists.computeIfAbsent(sector, k -> new ArrayList()).add(uUID);
            }
            HashSet<Object> edge = new HashSet<Object>();
            for (Map.Entry e : sectorLists.entrySet()) {
                List ids = (List)e.getValue();
                ids.sort((a, b) -> {
                    WorkerScheduler.MobSnapshot ma = WorkerComputations.find(mobs, a);
                    WorkerScheduler.MobSnapshot mb = WorkerComputations.find(mobs, b);
                    double da = ma == null ? 0.0 : WorkerComputations.distance(ma, leader);
                    double db = mb == null ? 0.0 : WorkerComputations.distance(mb, leader);
                    return Double.compare(db, da);
                });
                int count = Math.min(perSector, ids.size());
                for (int i = 0; i < count; ++i) {
                    edge.add((UUID)ids.get(i));
                }
            }
            if (edge.isEmpty() && group.size() > 1) {
                void var24_51;
                Object var24_50 = null;
                double best = -1.0;
                for (UUID id : group) {
                    double d;
                    WorkerScheduler.MobSnapshot m;
                    if (id.equals(mobSnapshot.uuid()) || (m = WorkerComputations.find(mobs, id)) == null || !((d = WorkerComputations.distance(m, mobSnapshot)) > best)) continue;
                    best = d;
                    UUID uUID = id;
                }
                if (var24_51 != null) {
                    edge.add(var24_51);
                }
            }
            hashMap.put(mobSnapshot.uuid(), edge);
            if (System.currentTimeMillis() <= deadlineMs) continue;
            break;
        }
        HashSet<UUID> hashSet2 = new HashSet<UUID>();
        for (WorkerScheduler.MobSnapshot m : candidates) {
            if (hashSet.contains(m.uuid())) continue;
            hashSet2.add(m.uuid());
        }
        return new WorkerScheduler.GroupComputeResult(dimension, mobToLeader, hashMap, hashSet2);
    }

    public static List<WorkerScheduler.SoundScoreResult> computeSoundScores(List<WorkerScheduler.SoundScoreRequest> batch, long deadlineMs) {
        if (batch == null || batch.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WorkerScheduler.SoundScoreResult> out = new ArrayList<WorkerScheduler.SoundScoreResult>(batch.size());
        for (WorkerScheduler.SoundScoreRequest req : batch) {
            if (System.currentTimeMillis() > deadlineMs) break;
            out.add(WorkerComputations.computeSoundScore(req, deadlineMs));
        }
        return out;
    }

    public static WorkerScheduler.SoundScoreResult computeSoundScore(WorkerScheduler.SoundScoreRequest req, long deadlineMs) {
        if (req == null) {
            return new WorkerScheduler.SoundScoreResult(null, null, 0.0);
        }
        if (req.candidates == null || req.candidates.isEmpty()) {
            return new WorkerScheduler.SoundScoreResult(req.mobUuid, null, 0.0);
        }
        Double currentScore = null;
        if (req.currentTargetSoundId != null) {
            for (WorkerScheduler.SoundCandidate c : req.candidates) {
                if (req.currentTargetSoundId.equals(c.soundId)) {
                    currentScore = WorkerComputations.scoreCandidate(req, c);
                    break;
                }
                if (System.currentTimeMillis() <= deadlineMs) continue;
                break;
            }
        }
        String bestId = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        double bestDist = Double.MAX_VALUE;
        for (WorkerScheduler.SoundCandidate c : req.candidates) {
            double dx = req.mobX - c.x;
            double dz = req.mobZ - c.z;
            double dist = Math.hypot(dx, dz);
            double s = WorkerComputations.scoreCandidate(req, c);
            if (s > bestScore || Math.abs(s - bestScore) < 0.001 && dist < bestDist) {
                bestScore = s;
                bestId = c.soundId;
                bestDist = dist;
            }
            if (System.currentTimeMillis() <= deadlineMs) continue;
            break;
        }
        if (currentScore != null && req.currentTargetSoundId != null && bestId != null && !req.currentTargetSoundId.equals(bestId) && bestScore < currentScore * req.switchRatio) {
            bestId = req.currentTargetSoundId;
            bestScore = currentScore;
        }
        return new WorkerScheduler.SoundScoreResult(req.mobUuid, bestId, bestScore == Double.NEGATIVE_INFINITY ? 0.0 : bestScore);
    }

    private static double scoreCandidate(WorkerScheduler.SoundScoreRequest req, WorkerScheduler.SoundCandidate c) {
        double effectiveRange;
        double dx = req.mobX - c.x;
        double dz = req.mobZ - c.z;
        double dist = Math.hypot(dx, dz);
        if (dist > (effectiveRange = Math.max(1.0E-4, c.range))) {
            return Double.NEGATIVE_INFINITY;
        }
        double score = c.weight;
        long ageTicks = Math.max(0L, req.gameTime - c.gameTime);
        if (ageTicks <= (long)req.noveltyTicks) {
            score += req.noveltyBonus;
        }
        return score;
    }

    private static double distance(WorkerScheduler.MobSnapshot a, WorkerScheduler.MobSnapshot b) {
        double dx = a.x() - b.x();
        double dz = a.z() - b.z();
        return Math.hypot(dx, dz);
    }

    private static WorkerScheduler.MobSnapshot find(List<WorkerScheduler.MobSnapshot> list, UUID id) {
        for (WorkerScheduler.MobSnapshot m : list) {
            if (!m.uuid().equals(id)) continue;
            return m;
        }
        return null;
    }
}

