/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.worker;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.quantified.QuantifiedWorkScheduler;
import com.example.soundattract.worker.LocalWorkScheduler;
import com.example.soundattract.worker.SoundAttractWorkScheduler;
import net.minecraftforge.fml.ModList;

public final class WorkSchedulerManager {
    private static volatile SoundAttractWorkScheduler INSTANCE;
    private static volatile boolean QUANTIFIED_INIT_FAILED;

    private WorkSchedulerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoundAttractWorkScheduler get() {
        SoundAttractWorkScheduler local = INSTANCE;
        if (local != null) {
            return local;
        }
        Class<WorkSchedulerManager> clazz = WorkSchedulerManager.class;
        synchronized (WorkSchedulerManager.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = WorkSchedulerManager.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        Class<WorkSchedulerManager> clazz = WorkSchedulerManager.class;
        synchronized (WorkSchedulerManager.class) {
            QUANTIFIED_INIT_FAILED = false;
            INSTANCE = WorkSchedulerManager.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static SoundAttractWorkScheduler build() {
        boolean quantifiedLoaded = ModList.get().isLoaded("quantified");
        boolean enableQuantifiedIntegration = true;
        try {
            enableQuantifiedIntegration = (Boolean)SoundAttractConfig.COMMON.enableQuantifiedIntegration.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (quantifiedLoaded && enableQuantifiedIntegration && !QUANTIFIED_INIT_FAILED) {
            try {
                return new QuantifiedWorkScheduler();
            }
            catch (Throwable t) {
                QUANTIFIED_INIT_FAILED = true;
                SoundAttractMod.LOGGER.warn("[WorkSchedulerManager] Failed to initialize QuantifiedWorkScheduler, falling back to LocalWorkScheduler", t);
            }
        }
        return new LocalWorkScheduler();
    }

    static {
        QUANTIFIED_INIT_FAILED = false;
    }
}

