/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.worker;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.worker.LocalWorkScheduler;
import com.example.soundattract.worker.SoundAttractWorkScheduler;
import com.example.soundattract.worker.WorkerComputations;
import com.example.soundattract.worker.WorkerScheduler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public final class QuantifiedWorkScheduler
implements SoundAttractWorkScheduler {
    private final BlockingQueue<WorkerScheduler.GroupComputeResult> groupResults = new LinkedBlockingQueue<WorkerScheduler.GroupComputeResult>();
    private final BlockingQueue<WorkerScheduler.SoundScoreResult> soundResults = new LinkedBlockingQueue<WorkerScheduler.SoundScoreResult>();
    private final LocalWorkScheduler fallback = new LocalWorkScheduler();
    private final Method register;
    private final Method submit;

    public QuantifiedWorkScheduler() {
        try {
            Class<?> api = Class.forName("org.admany.quantified.api.QuantifiedAPI");
            this.register = api.getMethod("register", String.class);
            this.submit = api.getMethod("submit", String.class, Supplier.class);
            this.register.invoke(null, "soundattract");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public Future<?> submitGroupCompute(List<WorkerScheduler.MobSnapshot> mobs, WorkerScheduler.ConfigSnapshot cfg, ResourceLocation dimension) {
        long computedDeadline = System.currentTimeMillis() + 10L;
        try {
            Integer budget = (Integer)SoundAttractConfig.COMMON.workerTaskBudgetMs.get();
            if (budget != null) {
                long cfgBudget = budget.longValue();
                computedDeadline = System.currentTimeMillis() + Math.max(5L, cfgBudget);
            }
        }
        catch (Throwable budget) {
            // empty catch block
        }
        long deadlineMs = computedDeadline;
        CompletableFuture<?> future = this.submitFuture("soundattract_group_compute", () -> WorkerComputations.computeGroups(mobs, cfg, deadlineMs, dimension));
        if (future.isCompletedExceptionally()) {
            return this.fallback.submitGroupCompute(mobs, cfg, dimension);
        }
        return future.handle((result, throwable) -> {
            WorkerScheduler.GroupComputeResult r;
            if (throwable != null) {
                return this.fallback.submitGroupCompute(mobs, cfg, dimension);
            }
            if (result instanceof WorkerScheduler.GroupComputeResult && (r = (WorkerScheduler.GroupComputeResult)result).dimension() != null) {
                this.groupResults.offer(r);
            }
            return null;
        });
    }

    @Override
    public Future<?> submitSoundScore(List<WorkerScheduler.SoundScoreRequest> batch) {
        if (batch == null || batch.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        long computedDeadline = System.currentTimeMillis() + 10L;
        try {
            Integer budget = (Integer)SoundAttractConfig.COMMON.workerTaskBudgetMs.get();
            if (budget != null) {
                long cfgBudget = budget.longValue();
                computedDeadline = System.currentTimeMillis() + Math.max(5L, cfgBudget);
            }
        }
        catch (Throwable budget) {
            // empty catch block
        }
        long deadlineMs = computedDeadline;
        CompletableFuture<?> future = this.submitFuture("soundattract_sound_score", () -> WorkerComputations.computeSoundScores(batch, deadlineMs));
        if (future.isCompletedExceptionally()) {
            return this.fallback.submitSoundScore(batch);
        }
        return future.handle((result, throwable) -> {
            if (throwable != null) {
                return this.fallback.submitSoundScore(batch);
            }
            if (result instanceof List) {
                List list = (List)result;
                for (Object o : list) {
                    if (!(o instanceof WorkerScheduler.SoundScoreResult)) continue;
                    WorkerScheduler.SoundScoreResult r = (WorkerScheduler.SoundScoreResult)o;
                    this.soundResults.offer(r);
                }
            }
            return null;
        });
    }

    @Override
    public List<WorkerScheduler.GroupComputeResult> drainGroupResults() {
        ArrayList<WorkerScheduler.GroupComputeResult> out = new ArrayList<WorkerScheduler.GroupComputeResult>();
        this.groupResults.drainTo(out);
        out.addAll(WorkerScheduler.drainGroupResults());
        return out;
    }

    @Override
    public List<WorkerScheduler.SoundScoreResult> drainSoundScoreResults() {
        ArrayList<WorkerScheduler.SoundScoreResult> out = new ArrayList<WorkerScheduler.SoundScoreResult>();
        this.soundResults.drainTo(out);
        out.addAll(WorkerScheduler.drainSoundScoreResults());
        return out;
    }

    private CompletableFuture<?> submitFuture(String taskName, Supplier<?> work) {
        try {
            Object future = this.submit.invoke(null, taskName, work);
            if (future instanceof CompletableFuture) {
                CompletableFuture cf = (CompletableFuture)future;
                return cf;
            }
            if (future instanceof Future) {
                Future f = (Future)future;
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return f.get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable t) {
            CompletableFuture failed = new CompletableFuture();
            failed.completeExceptionally(t);
            return failed;
        }
    }
}

