/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.quantified;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.minecraftforge.fml.ModList;

public final class QuantifiedIntegration {
    private static final AtomicBoolean INIT = new AtomicBoolean(false);

    private QuantifiedIntegration() {
    }

    public static void bootstrap() {
        block9: {
            if (!INIT.compareAndSet(false, true)) {
                return;
            }
            if (!ModList.get().isLoaded("quantified")) {
                return;
            }
            try {
                if (!((Boolean)SoundAttractConfig.COMMON.enableQuantifiedIntegration.get()).booleanValue()) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class<?> api = Class.forName("org.admany.quantified.api.QuantifiedAPI");
                Method register = api.getMethod("register", String.class);
                register.invoke(null, "soundattract");
                try {
                    Class<?> priorityManager = Class.forName("org.admany.quantified.core.common.async.task.ModPriorityManager");
                    Method setMaxTasks = priorityManager.getMethod("setMaxTasksForMod", String.class, Long.TYPE);
                    setMaxTasks.invoke(null, "soundattract", 1000000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                QuantifiedIntegration.redirectJulLogging();
            }
            catch (Throwable t) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block9;
                SoundAttractMod.LOGGER.debug("[Quantified] Registration failed: {}", (Object)t.getMessage());
            }
        }
    }

    private static void redirectJulLogging() {
        block3: {
            try {
                Logger jul = Logger.getLogger("org.admany.quantified");
                jul.setUseParentHandlers(false);
                for (Handler h : jul.getHandlers()) {
                    jul.removeHandler(h);
                }
                jul.setLevel(Level.ALL);
                jul.addHandler(new Handler(){

                    @Override
                    public void publish(LogRecord record) {
                        if (!this.isLoggable(record)) {
                            return;
                        }
                        String msg = record.getMessage();
                        Throwable thrown = record.getThrown();
                        Level lvl = record.getLevel();
                        if (lvl.intValue() >= Level.SEVERE.intValue()) {
                            SoundAttractMod.LOGGER.error("[Quantified] {}", (Object)msg, (Object)thrown);
                        } else if (lvl.intValue() >= Level.WARNING.intValue()) {
                            SoundAttractMod.LOGGER.warn("[Quantified] {}", (Object)msg, (Object)thrown);
                        } else if (lvl.intValue() >= Level.INFO.intValue()) {
                            SoundAttractMod.LOGGER.info("[Quantified] {}", (Object)msg, (Object)thrown);
                        } else {
                            SoundAttractMod.LOGGER.debug("[Quantified] {}", (Object)msg, (Object)thrown);
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() {
                    }
                });
            }
            catch (Throwable t) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block3;
                SoundAttractMod.LOGGER.debug("[Quantified] Logging bridge failed: {}", (Object)t.getMessage());
            }
        }
    }
}

