/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.mixin;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.FovEvents;
import com.example.soundattract.event.StealthDetectionEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sensing.class})
public abstract class SensingMixin {
    @Shadow
    @Final
    private Mob f_26784_;

    @Inject(method={"hasLineOfSight(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void soundattract$hasLineOfSight(Entity target, CallbackInfoReturnable<Boolean> cir) {
        double distSq;
        double xrayRange;
        if (target instanceof Player) {
            Player player = (Player)target;
            boolean visible = FovEvents.hasSmartLineOfSight(this.f_26784_, (Entity)player);
            cir.setReturnValue((Object)visible);
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableXrayTargeting.get()).booleanValue() && (xrayRange = StealthDetectionEvents.getEffectiveXrayRange(this.f_26784_)) > 0.0 && (distSq = this.f_26784_.m_20280_(target)) <= xrayRange * xrayRange) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SensingMixin] {} can see {} through walls with X-ray (range: {}, distSq: {})", new Object[]{this.f_26784_.m_7755_().getString(), target.m_7755_().getString(), String.format("%.2f", xrayRange), String.format("%.2f", distSq)});
            }
            cir.setReturnValue((Object)true);
            return;
        }
        boolean visible = FovEvents.hasSmartLineOfSight(this.f_26784_, target);
        cir.setReturnValue((Object)visible);
    }
}

