/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.los;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.async.AsyncManager;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.FovEvents;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="soundattract", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class OptimizedLOS {
    private static final double TIE_EPS = 1.0E-12;
    private static final AtomicInteger DEBUG_CANSEE_CALLS = new AtomicInteger(0);
    private static final AtomicInteger DEBUG_HASLOS_CALLS = new AtomicInteger(0);
    private static final AtomicInteger DEBUG_DDA_CALLS = new AtomicInteger(0);
    private static final AtomicLong DEBUG_LAST_LOG_GAME_TIME = new AtomicLong(-1L);
    private static final ConcurrentHashMap<LosPairKey, LosPairEntry> LOS_PAIR_CACHE = new ConcurrentHashMap();
    private static final Queue<LosRequest> LOS_QUEUE = new ConcurrentLinkedQueue<LosRequest>();
    private static final ConcurrentHashMap<LosPairKey, CompletableFuture<Boolean>> LOS_IN_FLIGHT = new ConcurrentHashMap();
    private static final AtomicInteger LOS_QUEUE_SIZE = new AtomicInteger(0);

    private OptimizedLOS() {
    }

    public static boolean canSee(Mob looker, Entity target) {
        boolean result;
        LosPairEntry existing;
        if (looker == null || target == null) {
            return false;
        }
        Level level = looker.m_9236_();
        if (level == null || level != target.m_9236_()) {
            return false;
        }
        boolean enableOptimized = true;
        boolean enablePairCache = true;
        int pairCacheMax = 8192;
        try {
            enableOptimized = (Boolean)SoundAttractConfig.COMMON.enableOptimizedLos.get();
            enablePairCache = (Boolean)SoundAttractConfig.COMMON.enableOptimizedLosPairCache.get();
            pairCacheMax = (Integer)SoundAttractConfig.COMMON.optimizedLosPairCacheMaxEntries.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long now = level.m_46467_();
        String dim = level.m_46472_().m_135782_().toString();
        boolean debug = false;
        try {
            debug = (Boolean)SoundAttractConfig.COMMON.debugLogging.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (debug) {
            DEBUG_CANSEE_CALLS.incrementAndGet();
            long last = DEBUG_LAST_LOG_GAME_TIME.get();
            if ((last < 0L || now - last >= 200L) && DEBUG_LAST_LOG_GAME_TIME.compareAndSet(last, now)) {
                SoundAttractMod.LOGGER.info("[OptimizedLOS] canSee active. calls={} enableOptimized={} pairCache={} pairCacheSize={} queue={} inFlight={}", new Object[]{DEBUG_CANSEE_CALLS.get(), enableOptimized, enablePairCache, LOS_PAIR_CACHE.size(), LOS_QUEUE_SIZE.get(), LOS_IN_FLIGHT.size()});
            }
        }
        LosPairKey key = new LosPairKey(dim, looker.m_19879_(), target.m_19879_());
        if (enablePairCache && (existing = LOS_PAIR_CACHE.get(key)) != null && now - existing.gameTime() <= 1L) {
            return existing.result();
        }
        Vec3 start = looker.m_146892_();
        Vec3 eyeToEye = target.m_146892_();
        Vec3 center = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 feet = target.m_20182_().m_82520_(0.0, Math.max(0.1, (double)target.m_20206_() * 0.15), 0.0);
        if (enableOptimized) {
            result = OptimizedLOS.hasLineOfSight(level, start, eyeToEye, looker) || OptimizedLOS.hasLineOfSight(level, start, center, looker) || OptimizedLOS.hasLineOfSight(level, start, feet, looker);
        } else {
            boolean bl = result = OptimizedLOS.hasLineOfSightVanillaIgnoringNonBlocking(level, start, eyeToEye, looker) || OptimizedLOS.hasLineOfSightVanillaIgnoringNonBlocking(level, start, center, looker) || OptimizedLOS.hasLineOfSightVanillaIgnoringNonBlocking(level, start, feet, looker);
        }
        if (enablePairCache) {
            LOS_PAIR_CACHE.put(key, new LosPairEntry(result, now));
            int maxEntries = Math.max(512, pairCacheMax);
            if (LOS_PAIR_CACHE.size() > maxEntries) {
                LOS_PAIR_CACHE.entrySet().removeIf(e -> now - ((LosPairEntry)e.getValue()).gameTime() > 1L);
                if (LOS_PAIR_CACHE.size() > maxEntries) {
                    int toRemove = LOS_PAIR_CACHE.size() - maxEntries;
                    Iterator<Map.Entry<LosPairKey, LosPairEntry>> it = LOS_PAIR_CACHE.entrySet().iterator();
                    for (int i = 0; i < toRemove && it.hasNext(); ++i) {
                        it.next();
                        it.remove();
                    }
                }
            }
        }
        return result;
    }

    public static CompletableFuture<Boolean> canSeeAsync(Mob looker, Entity target) {
        if (looker == null || target == null) {
            return CompletableFuture.completedFuture(false);
        }
        Level level = looker.m_9236_();
        if (level == null || level.m_5776_() || level != target.m_9236_()) {
            return CompletableFuture.completedFuture(false);
        }
        boolean enableBatching = false;
        int queueMax = 4096;
        try {
            enableBatching = (Boolean)SoundAttractConfig.COMMON.enableLosBatching.get();
            queueMax = (Integer)SoundAttractConfig.COMMON.losBatchQueueMaxSize.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!enableBatching) {
            return AsyncManager.callOnMain(() -> OptimizedLOS.canSee(looker, target)).thenApply(Boolean::booleanValue);
        }
        String dim = level.m_46472_().m_135782_().toString();
        LosPairKey key = new LosPairKey(dim, looker.m_19879_(), target.m_19879_());
        CompletableFuture<Boolean> existing = LOS_IN_FLIGHT.get(key);
        if (existing != null) {
            return existing;
        }
        if (LOS_IN_FLIGHT.size() >= Math.max(64, queueMax)) {
            return AsyncManager.callOnMain(() -> OptimizedLOS.canSee(looker, target)).thenApply(Boolean::booleanValue);
        }
        if (LOS_QUEUE_SIZE.get() >= Math.max(64, queueMax)) {
            return AsyncManager.callOnMain(() -> OptimizedLOS.canSee(looker, target)).thenApply(Boolean::booleanValue);
        }
        CompletableFuture<Boolean> created = new CompletableFuture<Boolean>();
        CompletableFuture<Boolean> prior = LOS_IN_FLIGHT.putIfAbsent(key, created);
        if (prior != null) {
            return prior;
        }
        LOS_QUEUE.add(new LosRequest(level, looker, target, key));
        LOS_QUEUE_SIZE.incrementAndGet();
        return created;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        LosRequest req;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (LOS_QUEUE.isEmpty()) {
            return;
        }
        int budget = 64;
        try {
            budget = (Integer)SoundAttractConfig.COMMON.losBatchBudgetPerTick.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        budget = Math.max(1, budget);
        for (int i = 0; i < budget && (req = LOS_QUEUE.poll()) != null; ++i) {
            LOS_QUEUE_SIZE.decrementAndGet();
            CompletableFuture<Boolean> future = LOS_IN_FLIGHT.remove(req.key());
            if (future == null || future.isDone()) continue;
            boolean result = false;
            try {
                Level level = req.level();
                Mob looker = req.looker();
                Entity target = req.target();
                if (!(level == null || looker == null || target == null || level.m_5776_() || looker.m_9236_() != level || target.m_9236_() != level || looker.m_213877_() || target.m_213877_())) {
                    result = OptimizedLOS.canSee(looker, target);
                }
            }
            catch (Throwable t) {
                result = false;
            }
            future.complete(result);
        }
    }

    public static boolean hasLineOfSight(Level level, Vec3 start, Vec3 end, Mob looker) {
        if (level == null || start == null || end == null) {
            return false;
        }
        boolean debug = false;
        try {
            debug = (Boolean)SoundAttractConfig.COMMON.debugLogging.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (debug) {
            DEBUG_HASLOS_CALLS.incrementAndGet();
        }
        if (!(Double.isFinite(start.f_82479_) && Double.isFinite(start.f_82480_) && Double.isFinite(start.f_82481_) && Double.isFinite(end.f_82479_) && Double.isFinite(end.f_82480_) && Double.isFinite(end.f_82481_))) {
            return false;
        }
        BlockPos startPos = BlockPos.m_274446_((Position)start);
        BlockPos endPos = BlockPos.m_274446_((Position)end);
        if (!level.m_46749_(startPos) || !level.m_46749_(endPos)) {
            return false;
        }
        boolean enableOptimized = true;
        boolean enableFallback = true;
        try {
            enableOptimized = (Boolean)SoundAttractConfig.COMMON.enableOptimizedLos.get();
            enableFallback = (Boolean)SoundAttractConfig.COMMON.enableOptimizedLosVanillaFallback.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!enableOptimized) {
            return OptimizedLOS.hasLineOfSightVanillaIgnoringNonBlocking(level, start, end, looker);
        }
        try {
            return OptimizedLOS.hasLineOfSightDda(level, start, end, looker);
        }
        catch (Throwable t) {
            if (!enableFallback) {
                return false;
            }
            return OptimizedLOS.hasLineOfSightVanillaIgnoringNonBlocking(level, start, end, looker);
        }
    }

    private static boolean hasLineOfSightDda(Level level, Vec3 start, Vec3 end, Mob looker) {
        double tMaxY;
        double tMaxX;
        double invDz;
        int stepY;
        int stepX;
        try {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                DEBUG_DDA_CALLS.incrementAndGet();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        double dx = end.f_82479_ - start.f_82479_;
        double dy = end.f_82480_ - start.f_82480_;
        double dz = end.f_82481_ - start.f_82481_;
        double distSqr = dx * dx + dy * dy + dz * dz;
        if (distSqr < 1.0E-8) {
            return true;
        }
        int x = Mth.m_14107_((double)start.f_82479_);
        int y = Mth.m_14107_((double)start.f_82480_);
        int z = Mth.m_14107_((double)start.f_82481_);
        int endX = Mth.m_14107_((double)end.f_82479_);
        int endY = Mth.m_14107_((double)end.f_82480_);
        int endZ = Mth.m_14107_((double)end.f_82481_);
        if (x == endX && y == endY && z == endZ) {
            return true;
        }
        int n = dx > 0.0 ? 1 : (stepX = dx < 0.0 ? -1 : 0);
        int n2 = dy > 0.0 ? 1 : (stepY = dy < 0.0 ? -1 : 0);
        int stepZ = dz > 0.0 ? 1 : (dz < 0.0 ? -1 : 0);
        double invDx = stepX == 0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dx);
        double invDy = stepY == 0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dy);
        double d = invDz = stepZ == 0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dz);
        double d2 = stepX == 0 ? Double.POSITIVE_INFINITY : (tMaxX = (stepX > 0 ? (double)x + 1.0 - start.f_82479_ : start.f_82479_ - (double)x) * invDx);
        double d3 = stepY == 0 ? Double.POSITIVE_INFINITY : (tMaxY = (stepY > 0 ? (double)y + 1.0 - start.f_82480_ : start.f_82480_ - (double)y) * invDy);
        double tMaxZ = stepZ == 0 ? Double.POSITIVE_INFINITY : (stepZ > 0 ? (double)z + 1.0 - start.f_82481_ : start.f_82481_ - (double)z) * invDz;
        double tDeltaX = invDx;
        double tDeltaY = invDy;
        double tDeltaZ = invDz;
        int maxSteps = 4 + Math.abs(endX - x) + Math.abs(endY - y) + Math.abs(endZ - z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        CollisionContext ctx = looker == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)looker);
        for (int steps = 0; steps < maxSteps; ++steps) {
            boolean stepAxisZ;
            double tMin = Math.min(tMaxX, Math.min(tMaxY, tMaxZ));
            boolean stepAxisX = tMaxX - tMin <= 1.0E-12;
            boolean stepAxisY = tMaxY - tMin <= 1.0E-12;
            boolean bl = stepAxisZ = tMaxZ - tMin <= 1.0E-12;
            if (stepAxisX) {
                x += stepX;
                tMaxX += tDeltaX;
            }
            if (stepAxisY) {
                y += stepY;
                tMaxY += tDeltaY;
            }
            if (stepAxisZ) {
                z += stepZ;
                tMaxZ += tDeltaZ;
            }
            pos.m_122178_(x, y, z);
            if (!level.m_46749_((BlockPos)pos)) {
                return false;
            }
            BlockState state = level.m_8055_((BlockPos)pos);
            if (!FovEvents.isNonBlockingVisionForLos(state, level, (BlockPos)pos)) {
                if (state.m_60838_((BlockGetter)level, (BlockPos)pos)) {
                    return false;
                }
                VoxelShape shape = state.m_60742_((BlockGetter)level, (BlockPos)pos, ctx);
                if (!shape.m_83281_()) {
                    for (AABB part : shape.m_83299_()) {
                        if (!OptimizedLOS.segmentIntersectsAabb(start, end, part.m_82338_((BlockPos)pos))) continue;
                        return false;
                    }
                }
            }
            if (x != endX || y != endY || z != endZ) continue;
            return true;
        }
        boolean enableFallback = true;
        try {
            enableFallback = (Boolean)SoundAttractConfig.COMMON.enableOptimizedLosVanillaFallback.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!enableFallback) {
            return false;
        }
        return OptimizedLOS.hasLineOfSightVanillaIgnoringNonBlocking(level, start, end, looker);
    }

    private static boolean hasLineOfSightVanillaIgnoringNonBlocking(Level level, Vec3 start, Vec3 end, Mob looker) {
        if (level == null || start == null || end == null) {
            return false;
        }
        Vec3 currentStart = start;
        for (int i = 0; i < 64; ++i) {
            if (currentStart.m_82557_(end) < 1.0E-8) {
                return true;
            }
            BlockHitResult hit = level.m_45547_(new ClipContext(currentStart, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)looker));
            if (hit.m_6662_() == HitResult.Type.MISS) {
                return true;
            }
            BlockPos hitPos = hit.m_82425_();
            if (!level.m_46749_(hitPos)) {
                return false;
            }
            BlockState state = level.m_8055_(hitPos);
            if (!FovEvents.isNonBlockingVisionForLos(state, level, hitPos)) {
                return false;
            }
            Vec3 loc = hit.m_82450_();
            Vec3 dir = end.m_82546_(currentStart);
            double len = dir.m_82553_();
            if (len < 1.0E-8) {
                return true;
            }
            Vec3 n = dir.m_82490_(1.0 / len);
            currentStart = loc.m_82549_(n.m_82490_(0.001));
        }
        return true;
    }

    private static boolean segmentIntersectsAabb(Vec3 start, Vec3 end, AABB box) {
        double dz;
        double dy;
        double t0 = 0.0;
        double t1 = 1.0;
        double dx = end.f_82479_ - start.f_82479_;
        if (Math.abs(dx) < 1.0E-12) {
            if (start.f_82479_ < box.f_82288_ || start.f_82479_ > box.f_82291_) {
                return false;
            }
        } else {
            double inv = 1.0 / dx;
            double tNear = (box.f_82288_ - start.f_82479_) * inv;
            double tFar = (box.f_82291_ - start.f_82479_) * inv;
            if (tNear > tFar) {
                double tmp = tNear;
                tNear = tFar;
                tFar = tmp;
            }
            t0 = Math.max(t0, tNear);
            if ((t1 = Math.min(t1, tFar)) < t0) {
                return false;
            }
        }
        if (Math.abs(dy = end.f_82480_ - start.f_82480_) < 1.0E-12) {
            if (start.f_82480_ < box.f_82289_ || start.f_82480_ > box.f_82292_) {
                return false;
            }
        } else {
            double inv = 1.0 / dy;
            double tNear = (box.f_82289_ - start.f_82480_) * inv;
            double tFar = (box.f_82292_ - start.f_82480_) * inv;
            if (tNear > tFar) {
                double tmp = tNear;
                tNear = tFar;
                tFar = tmp;
            }
            t0 = Math.max(t0, tNear);
            if ((t1 = Math.min(t1, tFar)) < t0) {
                return false;
            }
        }
        if (Math.abs(dz = end.f_82481_ - start.f_82481_) < 1.0E-12) {
            if (start.f_82481_ < box.f_82290_ || start.f_82481_ > box.f_82293_) {
                return false;
            }
        } else {
            double inv = 1.0 / dz;
            double tNear = (box.f_82290_ - start.f_82481_) * inv;
            double tFar = (box.f_82293_ - start.f_82481_) * inv;
            if (tNear > tFar) {
                double tmp = tNear;
                tNear = tFar;
                tFar = tmp;
            }
            t0 = Math.max(t0, tNear);
            if ((t1 = Math.min(t1, tFar)) < t0) {
                return false;
            }
        }
        return true;
    }

    private record LosPairKey(String dim, int lookerId, int targetId) {
    }

    private record LosPairEntry(boolean result, long gameTime) {
    }

    private record LosRequest(Level level, Mob looker, Entity target, LosPairKey key) {
    }
}

