/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.voicechat;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.voicechat.VoiceChatThresholds;
import com.example.soundattract.network.SoundAttractNetwork;
import com.example.soundattract.network.SoundMessage;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VoiceChatIntegrationClient {
    public static void handleClientSound(ClientSoundEvent event) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientPlayer == null || clientWorld == null || !((Boolean)SoundAttractConfig.COMMON.enableVoiceChatIntegration.get()).booleanValue()) {
            return;
        }
        short[] rawAudio = event.getRawAudio();
        if (rawAudio == null || rawAudio.length == 0) {
            return;
        }
        double db = VoiceChatIntegrationClient.computePeakDb(rawAudio);
        double normDb = db - -127.0;
        double factor = 0.0;
        List<VoiceChatThresholds.Threshold> pairs = VoiceChatThresholds.getThresholds((List)SoundAttractConfig.COMMON.voiceChatDbThresholdMap.get());
        if (!pairs.isEmpty()) {
            for (VoiceChatThresholds.Threshold p : pairs) {
                if (!(normDb >= p.threshold)) continue;
                factor = p.multiplier;
                break;
            }
        } else {
            factor = normDb >= 50.0 ? 1.0 : (normDb >= 30.0 ? 0.7 : (normDb >= 10.0 ? 0.3 : 0.0));
        }
        boolean isWhispering = event.isWhispering();
        int baseRange = isWhispering ? (Integer)SoundAttractConfig.COMMON.voiceChatWhisperRange.get() : (Integer)SoundAttractConfig.COMMON.voiceChatNormalRange.get();
        int effectiveRange = (int)Math.round((double)baseRange * factor);
        if (effectiveRange <= 0) {
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[SVC Client] dbFS={} normDb={} factor={} whispering={} baseRange={} effectiveRange={}", new Object[]{db, normDb, factor, isWhispering, baseRange, effectiveRange});
        }
        double x = clientPlayer.m_20185_();
        double y = clientPlayer.m_20186_();
        double z = clientPlayer.m_20189_();
        ResourceLocation dim = clientWorld.m_46472_().m_135782_();
        Optional<UUID> sourcePlayerUUID = Optional.of(clientPlayer.m_20148_());
        double weight = (Double)SoundAttractConfig.COMMON.voiceChatWeight.get();
        SoundMessage msg = new SoundMessage(SoundMessage.VOICE_CHAT_SOUND_ID, x, y, z, dim, sourcePlayerUUID, effectiveRange, weight);
        SoundAttractNetwork.INSTANCE.sendToServer((Object)msg);
    }

    private static double computePeakDb(short[] samples) {
        int highest = 0;
        for (short s : samples) {
            int a;
            int n = a = s == Short.MIN_VALUE ? 32768 : Math.abs(s);
            if (a <= highest) continue;
            highest = a;
        }
        if (highest == 0) {
            return -127.0;
        }
        double norm = (double)highest / 32768.0;
        double db = 20.0 * Math.log10(norm);
        if (!Double.isFinite(db)) {
            return -127.0;
        }
        if (db > 0.0) {
            db = 0.0;
        }
        if (db < -127.0) {
            db = -127.0;
        }
        return db;
    }
}

